// ---------- disptime.cpp

#include "disptime.h"

inline int adjust(int hour)
{
    return hour > 12 ? hour - 12 : (hour == 0 ? 12 : hour);
}

inline char makeampm(int hour) 
{
    return hour < 12 ? 'a' : 'p';
}

DispTime::DispTime(int hr, int min, int sec, timezone zn) 
            : TimeZone(adjust(hr), min, sec, zn)
{
    ampm = makeampm(hr);
}

void DispTime::display()
{
    Time::display();
    cout << ' ' << ampm << 'm';
    cout << ' ' << Zone();
}

