// An organization's class structure
// ------------ org.h

#ifndef ORG_H
#define ORG_H

#include <iostream.h>
#include <string.h>

class OrgEntity {
    char name[25];
    int employee_count;
public:
    OrgEntity(char *s, int ec);
    int number_employees()
        { return employee_count; }
    char *org_name()
        { return name; }
    virtual int office_party() = 0;
};

class Company : public OrgEntity    {
public:
    Company(char *s, int ec);
    virtual int office_party();
};

class Division : public Company    {
public:
    Division(char *s, int ec);
    virtual int office_party();
};

class Department : public Division    {
public:
    Department(char *s, int ec);
    int office_party();
};

#endif

