// ex09014.cpp
// Virtual base classes
#include <iostream.h>
#include <string.h>

class BillingItem    {
protected:
    char name[25];
    int cost;
public:
    virtual void display() = 0;
};

class Product : public virtual BillingItem    {
    int qty_sold;
public:
    Product(char *nm, int qty, int cst);
    void display();
};
Product::Product(char *nm, int qty, int cst)
{
	qty_sold = qty;
	strcpy(name, nm);
	cost = cst;
}
void Product::display()
{
	cout << qty_sold;
}

class Service : public virtual BillingItem    {
    int manhours;
public:
    Service(char *nm, int mh, int cst);
    void display();
};

Service::Service(char *nm, int mh, int cst)
{
	manhours = mh;
	strcpy(name, nm);
	cost = cst;
}
void Service::display()
{
	cout << manhours;
}

class Installation : public Product, public Service    {
public:
    Installation(char *nm, int qty, int hrs, int cst)
        : Product(nm, qty, cst), Service(nm, hrs, cst) { }
    void display();
};
void Installation::display()
{
    cout << "\nInstalled ";
    Product::display();
     cout << ' ' << name << 's';
    cout << "\nLabor: ";
    Service::display();
    cout << " hours";
    cout << "\nCost: $" << cost;
}
main()
{
    Installation inst("refrigerator", 2, 3, 75);
    inst.display();
}

