// ex07033.cpp
// Copy constructor
#include <iostream.h>
#include <string.h>

// ------- date class
class Date {
    int mo, da, yr;
    char *month;
public:
    Date(int m, int d, int y);
    Date(Date&);  // copy constructor
    ~Date();
    void display();
};

// constructor that is called for an initialized Date
Date::Date(int m, int d, int y)
{
    static char *mos[] = {
        "January", "February", "March", "April", "May", 
        "June", "July", "August", "September", "October", 
        "November", "December"
    };
    mo = m; da = d; yr = y;
    month = new char[strlen(mos[m-1])+1];
    strcpy(month, mos[m-1]);
}
// ---------- Date copy constructor
Date::Date(Date& dt)
{
    mo = dt.mo;
    da = dt.da;
    yr = dt.yr;
    month = new char [strlen(dt.month)+1];
    strcpy(month, dt.month);
}
// Destructor for a Date
Date::~Date()
{
    delete month;
}
// ----------- display member function
void Date::display() 
{
    if (month != 0)
        cout << '\n' << month << ' ' << da << ", " 
             << yr+1900;
}
main()
{
    // ------ first date
    Date birthday(6,24,40);
    birthday.display();
    // ------ second date
    Date newday = birthday;
    newday.display();
    // ------ third date
    Date lastday(birthday);
    lastday.display();
}

