// ex07032.cpp
// Class-specific new and delete operators with constructor, destructor
#include <iostream.h>
#include <stddef.h>

class Name    {
    char name[25];
public:
    Name()  { cout << "\nName constructor running"; }
    ~Name() { cout << "\nName destructor running";    }
    void *operator new(size_t);
    void operator delete(void *);
};

// -------- simple memory pool to handle one Name
char pool [sizeof(Name)];

// -------- overloaded new operator for the Name class
void *Name::operator new(size_t)
{
    cout << "\nName's new running";
    return pool; 
}

// --------- overloaded delete operator for the Name class
void Name::operator delete(void *)
{
    cout << "\nName's delete running";
}

main()
{
    cout << "\nBuilding a new name";
    Name *nm = new Name;
    cout << "\nDeleting a name";
    delete nm;
}

