// ex07031.cpp
// Class-specific new and delete operators
#include <iostream.h>
#include <string.h>
#include <stddef.h>

const int MAXNAMES = 5;

class Names    {
    char name[25];
public:
    void setname(char *s) { strcpy(name, s); }
    void display() { cout << '\n' << name; }
    void *operator new(size_t);
    void operator delete(void *);
};

// -------- simple memory pool to handle fixed number of Names
char pool[MAXNAMES] [sizeof(Names)];
int inuse[MAXNAMES];

// -------- overloaded new operator for the Names class
void *Names::operator new(size_t)
{
    for (int p = 0; p < MAXNAMES; p++)
        if (!inuse[p])    {
            inuse[p] = 1;
            return pool+p;
        }
    return 0; 
}

// --------- overloaded delete operator for the Names class
void Names::operator delete(void *p)
{
    inuse[((char *)p - pool[0]) / sizeof(Names)] = 0;
}

main()
{
    Names *nm[MAXNAMES];
    for (int i = 0; i < MAXNAMES; i++)    {
        cout << "\nEnter name # " << i+1 << ": ";
        char name[25];
        cin >> name;
        nm[i] = new Names;
        nm[i]->setname(name);
    }
    for (i = 0; i < MAXNAMES; i++)    {
        nm[i]->display();
        delete nm[i];
    }
}

