// ex07020.cpp
// this and the Linked List
#include <iostream.h>
#include <string.h>

class ListEntry {
    char *listvalue;
    ListEntry *preventry;
public:
    ListEntry(char *);
    ~ListEntry() { delete listvalue; }
    ListEntry *PrevEntry() { return preventry; };
    void display() { cout << '\n' << listvalue; }
    // ---------- use the 'this' pointer to chain the list
    void AddEntry(ListEntry& le) { le.preventry = this; }
};

ListEntry::ListEntry(char *s)
{
    listvalue = new char[strlen(s)+1];
    strcpy(listvalue, s);
    preventry = 0;
}

main()
{
    ListEntry *prev = 0;
    // ---------- read in some names
    while (1)    {
        cout << "\nEnter a name ('end' when done): ";
        char name[25];
        cin >> name;
        if (strncmp(name, "end", 3) == 0)
            break;
        // -------- make a list entry of the name
        ListEntry *list = new ListEntry(name);
        if (prev != 0)
            // -------- add the entry to the linked list
            prev->AddEntry(*list);
        prev = list;
    }
    // ------- display the names in reverse order
    while (prev != 0)    {
        prev->display();
        ListEntry *hold = prev;
        prev = prev->PrevEntry();
        // -------- delete the ListEntry
        delete hold;
    }
}

