// ex07018.cpp
// Class Assignment
#include <iostream.h>
#include <string.h>

// ------- date class
class Date {
    int mo, da, yr;
    char *month;
public:
    Date();
    Date(int m, int d, int y);
    ~Date();
    void operator=(Date&); // overloaded assignment operator
    void display();
};

// constructor that is called for an uninitialized Date
Date::Date()
{
    mo = 0; da = 0; yr = 0;
    month = 0;    
}

// constructor that is called for an initialized Date
Date::Date(int m, int d, int y)
{
    static char *mos[] = {
        "January", "February", "March", "April", "May", 
        "June", "July", "August", "September", "October", 
        "November", "December"
    };
    mo = m; da = d; yr = y;
    month = new char[strlen(mos[m-1])+1];
    strcpy(month, mos[m-1]);
}
// Destructor for a Date
Date::~Date()
{
    delete month;
}

// ----------- display member function
void Date::display() 
{
    if (month != 0)
        cout << '\n' << month << ' ' << da << ", " 
             << yr+1900;
}

// ---------- overloaded Date assignment
void Date::operator=(Date& dt)
{
    mo = dt.mo;
    da = dt.da;
    yr = dt.yr;
    delete month;
    if (dt.month != 0)    {
        month = new char [strlen(dt.month)+1];
        strcpy(month, dt.month);
    }
    else
        month = 0;
}

main()
{
    // ------ first date
    Date birthday(6,24,40);
    birthday.display();
    // ------ second date
    Date newday(7,29,41);
    newday.display();
    // ------ assign first to second
    newday = birthday;
    newday.display();
}

