// ex07026.cpp
// public static member functions
#include <iostream.h>
#include <string.h>

class ListEntry {
    static ListEntry *lastentry; // a static list head pointer
    char *listvalue;
    ListEntry *nextentry;
public:
    ListEntry();
    ListEntry(char *);
    ~ListEntry() { delete listvalue; }
    ListEntry *NextEntry() { return nextentry; };
    void display() { cout << '\n' << listvalue; }
    // ------- a static member function
    static void showlast();
};

ListEntry *ListEntry::lastentry;

ListEntry::ListEntry()
{
    listvalue = 0;
    nextentry = 0;
    lastentry = this;
}
ListEntry::ListEntry(char *s)
{
    lastentry->nextentry = this;
    lastentry = this;
    listvalue = new char[strlen(s)+1];
    strcpy(listvalue, s);
    nextentry = 0;
}

// ---------- a static member function
void ListEntry::showlast()
{
    lastentry->display();
    cout << " is the last entry in the list";
}

main()
{
    ListEntry listhead;    // ---- this is the list head
    // ---------- read in some names
    while (1)    {
        cout << "\nEnter a name ('end' when done): ";
        char name[25];
        cin >> name;
        if (strncmp(name, "end", 3) == 0)
            break;
        // -------- make a list entry of the name
        new ListEntry(name);
        // ----- call the static member function
        // ----- with no object reference
        ListEntry::showlast();
    }
    // ------- delete the entries
    ListEntry *next = listhead.NextEntry();
    while (next != 0)    {
        ListEntry *hold = next;
        next = next->NextEntry();
        // -------- delete the ListEntry
        delete hold;
    }
}

