// ex07024.cpp
// static members and the Linked List
#include <iostream.h>
#include <string.h>

class ListEntry {
    static ListEntry *lastentry; // static list head pointer
    char *listvalue;
    ListEntry *nextentry;
public:
    ListEntry();
    ListEntry(char *);
    ~ListEntry() { delete listvalue;}
    ListEntry *NextEntry() { return nextentry; };
    void display() { cout << '\n' << listvalue; }
};

ListEntry *ListEntry::lastentry;

ListEntry::ListEntry()
{
    listvalue = 0;
    nextentry = 0;
    lastentry = this;
}

ListEntry::ListEntry(char *s)
{
    lastentry->nextentry = this;
    lastentry = this;
    listvalue = new char[strlen(s)+1];
    strcpy(listvalue, s);
    nextentry = 0;
}

main()
{
    ListEntry listhead;    // ---- this is the list head
    // ---------- read in some names
    while (1)    {
        cout << "\nEnter a name ('end' when done): ";
        char name[25];
        cin >> name;
        if (strncmp(name, "end", 3) == 0)
            break;
        // -------- make a list entry of the name
        new ListEntry(name);
    }
    ListEntry *next = listhead.NextEntry();
    // ------- display the names
    while (next != 0)    {
        next->display();
        ListEntry *hold = next;
        next = next->NextEntry();
        // -------- delete the ListEntry
        delete hold;
    }
}

