// ex06005.cpp
// Call by reference
#include <iostream.h>

// ------ simple date class
struct Date {
    int da, mo, yr;
    void display();
};
void Date::display()
{
    cout << da << '/' << mo << '/' << yr;
}
void swapper(Date&, Date&);
void display(Date&, Date&);

main()
{
    static Date now  = {23,2,90};    // two dates
    static Date then = {10,9,60};    
    
    display(now, then);        // display the dates
    swapper(now, then);        // swap them
    display(now, then);        // display them swapped
}

// ----- this function swaps the caller's dates
void swapper(Date& dt1, Date& dt2)
{
    Date save;
    save = dt1;
    dt1 = dt2;
    dt2 = save;
}

void display(Date& now, Date& then)
{
    cout << "\n Now:  ";
    now.display();
    cout << "\n Then: ";
    then.display();
}

