// ex03008.cpp
// Home-brew new and delete with a _new_handler
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <new.h>

static void all_gone()
{
    cerr << "\n\aThe free store is empty\n";
    exit(1);
}

// ------------- overloaded new operator
void *operator new(size_t size)
{
    void *rtn;
    if ((rtn = malloc(size)) == 0)
        all_gone();
    return rtn;
}

// ----------- overloaded delete operator
void operator delete(void *type)
{
    free(type);
}

main()
{
    set_new_handler(all_gone);
    char *ip;
    // ----- get more heap than exists
    for (;;)
        ip = new char[30000];
}

