/****************************************************************************\
 *                                                                          *
 *  VMS Crack V1.0 security program                                         *
 *                                                                          *
 *  Coded by Davide Casale in June 1994                                     *
 *   (email address : casale@pmn.it)                                        *
 *  Coded and optimized by Mario Ambrogetti in June 1994                    *
 *   (email address : s65710@galileo.polito.it)                             *
 *  Original algorithm by Shawn Clifford in February 1993                   *
 *   (email address : sysop@robot.nuceng.ufl.edu)                           *
 *                                                                          *
\****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <signal.h>
#include "mytypes.h"
#include "getopt.h"
#include "sysuaf.h"
#include "hpwd.h"

#if defined(__TURBOC__) || defined(__WATCOMC__)
  #include <io.h>
#endif

#define MAXBUF 2048                  /* maximun buffer input       */
#define NPASS  32                    /* maxinum size password      */
#define MASKWH 0x1FU                 /* mask for wheel             */
#define AFF(BIT) (BIT)?"YES":"NO"    /* affirmative                */
#define SALT_TEST 0x85F7U            /* test for proper encryption */

typedef struct user_p {

          char   *username;         /* username (loginid)                */
          byte   passwd1[8];        /* Encrypted primary password        */
          byte   passwd2[8];        /* Encrypted secondary password      */
          word   passwd_salt;       /* Password encryption salt          */
          byte   encr_algo1;        /* Encryption algorithm code - pass1 */
          byte   encr_algo2;        /* Encryption algorithm code - pass2 */
          struct user_p *next;      /* next username                     */

        } user_t;


enum {VOCABULARY,SINGLE,USER,CREATE,LIST_ALL,LIST_ONE,TEST} opr=VOCABULARY;

int encrypt;             /* encryption algorithm        */
int encryptions;         /* amount of encryptions       */
int num_users=0;         /* number of users             */
int debug=0;             /* debug mode                  */
int quiet=0;             /* quiet mode                  */
int skip=0;              /* skip user account sisabled  */
dword comparisions;      /* comparisions password       */
dword test_low;          /* low part of test hash       */
dword test_high;         /* high part of test hash      */
double elapsed=1.0;      /* time elapsed                */
double report;           /* comparisions/elapsed        */
double performance;      /* algorithm performance       */
char *SYSUAF_name=NULL;  /* SYSUAF file name            */
char *voc_name=NULL;     /* vocabulary name             */
char *out_name=NULL;     /* out file name               */
char *pass_name=NULL;    /* password name               */
char *user_name=NULL;    /* username                    */
FILE *fSYSUAF=NULL;      /* SYSUAF file                 */
FILE *fvoc=NULL;         /* vocabulary file             */
FILE *fout=NULL;         /* output file                 */
time_t start_time;       /* start time encryption       */
time_t end_time;         /* start time encryption       */
UAF  user;               /* user in SYSUAF              */

char obuf[8];	             /* output buffer      */
char pbuf[NPASS];            /* password buffer    */
char ubuf[NPASS];            /* username buffer    */
char usertest[NPASS];        /* username for test  */
char passtest[NPASS];        /* password for test  */
char read_passwd[NPASS]="";  /* last read password */

dscdescriptor outdsc = {sizeof(obuf),obuf};
dscdescriptor pwddsc = {sizeof(pbuf),pbuf};
dscdescriptor usrdsc = {sizeof(ubuf),ubuf};

static char *restore_name="RESTORE.DAT";  /* default restore name file */
static char str_MODE[]="[mode]\n";
static char str_SYSUAF[]="[SYSUAF]\n";
static char str_OUT[]="[output]\n";
static char str_VOCA[]="[vocabulary]\n";
static char str_PASS[]="[password]\n";
static char str_USER[]="[user]\n";
static char str_LASTPASS[]="[last password]\n";
static char str_voca[]="vocabulary";
static char str_sing[]="single";
static char str_user[]="user";

const char user_test[]="ALBATROS";
const char passwd_test[]="THISISPASSWORDTEST";

byte hash_test[4][8]={{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF},
                      {0xB1,0xC1,0xD7,0xA0,0x8C,0xD3,0x81,0xF3},
                      {0x60,0xC6,0x2D,0x06,0xAF,0xA5,0x10,0x7C},
                      {0x50,0xAF,0x82,0xD5,0x4D,0x14,0x60,0xBA}};

const char *wheel[4]={"\b/","\b-","\b\\","\b|"};

char buffer[MAXBUF];   /* buffer input */

/* function prototypes */

void print_title(FILE *);
int  find_user(char *);
int  find_passwd(char *);
void print_record(int);
void init_stat(void);
void end_stat(void);
void print_stat(FILE *);
void strip_name(char *,char *,int);
void print_bytes(byte *,int);
void print_date(byte *);
void print_hours(byte *);
void print_days(char *,byte);
void exit_fn(void);
char *str_dup(const char *);
void str_upr(char *s);
static void sgn_fn(void);

typedef void (*fptr)();

int main(int argc,char *argv[])
{
  int  option;             /* option flag                 */
  int  ind_wheel=0;        /* index wheel                 */
  int  con_wheel=0;        /* counter wheel               */
  user_t *first_user;      /* first user                  */
  user_t *last_user;       /* last  user                  */
  user_t *cur_user;        /* current user                */
  user_t *pre_user;        /* precedent user              */
  char *ps;

  if (atexit(exit_fn)) {

    fputs("Error: no space left to register the exit function.\n",stderr);
    exit(EXIT_FAILURE);
  }

#ifdef __WATCOMC__
  signal(SIGBREAK,(fptr)sgn_fn);
#else
  signal(SIGFPE,(fptr)sgn_fn);
#endif

  signal(SIGABRT,(fptr)sgn_fn);
  signal(SIGILL ,(fptr)sgn_fn);
  signal(SIGINT ,(fptr)sgn_fn);
  signal(SIGSEGV,(fptr)sgn_fn);
  signal(SIGTERM,(fptr)sgn_fn);

  while ((option=getopt(argc,argv,"?hHsualckdqtS:V:O:P:U:")) != EOF) {

    switch(option) {

      case 's':

        opr=SINGLE;
        break;

      case 'u':

        opr=USER;
        break;

      case 'a':

        opr=LIST_ALL;
        break;

      case 'l':

        opr=LIST_ONE;
        break;

      case 'c':

        opr=CREATE;
        break;

      case 't':

        opr=TEST;
        break;

      case 'k':

        skip=1;
        break;

      case 'd':

        debug=1;
        quiet=0;
        break;

      case 'q':

        quiet=1;
        debug=0;
        break;

      case 'S':

        SYSUAF_name=str_dup(optarg);
        break;

      case 'V':

        voc_name=str_dup(optarg);
        break;

      case 'O':

        out_name=str_dup(optarg);
        break;

      case 'P':

        pass_name=str_dup(optarg);
        break;

      case 'U':

        user_name=str_dup(optarg);
        break;

      case '?':
      case 'h':
      case 'H':
      default:

        print_title(stdout);

        puts("VMSC [Options]\n");
        puts("  Options :");
        puts("    -?,-h,-H  : Show this help page.");
        puts("    -s        : Single word mode.");
        puts("    -u        : Single user mode.");
        puts("    -a        : Look all user's record.");
        puts("    -l        : Look a specific user's record.");
        puts("    -c        : Create a namelist from a SYSUAF to use as words.");
        puts("    -k        : Don't skip user account disabled.");
        puts("    -t        : Test crypt result for proper encryption.");
        puts("    -d        : Debug mode.");
        puts("    -q        : Quiet mode.");
        puts("    -S file   : Specific SYSUAF file.");
        puts("    -V file   : Specific vocabulary file.");
        puts("    -O file   : Specific output file.");
        puts("    -P pass   : Specific password.");
        puts("    -U name   : Specific username.");

        exit(EXIT_SUCCESS);

    } /* switch */

  } /* while */

  if (!quiet)
    print_title(stdout);




  if (opr!=TEST) {

    /* get SYSUAF file name */

    if (SYSUAF_name==NULL) {

      printf("SYSUAF name file : ");
      gets(buffer);

      SYSUAF_name=str_dup(buffer);
    }

    /* open file SYSUAF */

    if ((fSYSUAF=fopen(SYSUAF_name,"rb"))==NULL) {

      fprintf(stderr,"Can't open SYSUAF's file: %s\n",SYSUAF_name);
      exit(EXIT_FAILURE);
    }

    if (opr==SINGLE) {

      /* get password for check */

      if (pass_name==NULL) {

        printf("Password to check : ");
        gets(buffer);
        pass_name=str_dup(buffer);
      }

      /* check for the null password */

      if (*pass_name=='\0') {

        fputs("Error: null password.\n",stderr);
        exit(EXIT_FAILURE);
      }

      /* check long password */

      if (strlen(pass_name)>31) {

        fputs("Error: password is more than 31 character long.\n",stderr);
        exit(EXIT_FAILURE);
      }
    }

    if ((opr!=LIST_ALL) && (opr!=LIST_ONE)) {

      if ((opr!=CREATE) && (opr!=SINGLE)) {

        /* get vocabulary file name */

        if (voc_name==NULL) {

          printf("Vocabulary name file : ");
          gets(buffer);

          voc_name=str_dup(buffer);
        }

        /* open file vocabulary */

        if ((fvoc=fopen(voc_name,"r"))==NULL) {

          fprintf(stderr,"Can't read vocabulary file: %s\n",voc_name);
          exit(EXIT_FAILURE);
        }
      }

      if ((opr==LIST_ONE) || (opr==USER)) {

        /* get username */

        if (user_name==NULL) {

          printf("Username : ");
          gets(buffer);
          user_name=str_dup(buffer);
        }

        /* Check for the null username */

        if (*user_name=='\0') {

          fputs("Error: null username.\n",stderr);
          exit(EXIT_FAILURE);
        }

        /* check long password */

        if (strlen(user_name)>31) {

          fputs("Error: username is more than 31 character long.\n",stderr);
          exit(EXIT_FAILURE);
        }
      }

      /* get output file name */

      if (out_name==NULL) {

        printf("Output name file : ");
        gets(buffer);

        out_name=str_dup(buffer);
      }

      /* open file output */

      if ((fout=fopen(out_name,"a"))==NULL) {

        fprintf(stderr,"Can't write output file: %s\n",out_name);
        exit(EXIT_FAILURE);
      }

    }

    if ((opr==LIST_ONE) || (opr==USER)) {

      str_upr(user_name);

      if (!quiet)
        printf("\nFind username: %s\n",user_name);

      if ((num_users=find_user(user_name))==0) {

        fputs("Error: username not found.\n",stderr);
        exit(EXIT_FAILURE);
      }
    }
  }

  /* process operation */

  switch (opr) {

    case VOCABULARY:

      print_title(fout);

      if (!quiet)
        puts("\nReading users");

      first_user=last_user=NULL;

      while (fread(&user,sizeof(user),1,fSYSUAF)) {

        if (skip || (!((L_Flags_0 *)(&user.Login_Flags_0))->user_account)) {

          strip_name(buffer,user.Username,NPASS);

          /* control encryption algorithm */

          if (user.Encr_algo1==0) {

            if (debug)
              printf("%s * algorithm 0 *\n",buffer);

            continue;  /* while */
          }

          if (debug)
            puts(buffer);

          /* create in memory new user */

          if ((cur_user=(user_t *)malloc(sizeof(user_t)))==NULL) {

            fputs("Error: out of memory.\n",stderr);
            exit(EXIT_FAILURE);
          }

          /* initialize new user */

          cur_user->username=str_dup(buffer);
          cur_user->passwd_salt=user.Passwd_salt;
          memcpy(cur_user->passwd1,user.Passwd1,8);
          memcpy(cur_user->passwd2,user.Passwd2,8);
          cur_user->encr_algo1=user.Encr_algo1;
          cur_user->encr_algo2=user.Encr_algo2;
          cur_user->next=NULL;

          /* insert new user */

          if (first_user==NULL)
            first_user=cur_user;
          else
            last_user->next=cur_user;

          last_user=cur_user;

          num_users++;
        }
        else
          if (debug) {
            strip_name(buffer,user.Username,NPASS);
            printf("%s * User account is disabled *\n",buffer);
          }

      } /* while */

      if (!quiet)
        putchar('\n');

      init_stat();

      if (num_users!=0) {


        while (fgets(buffer,sizeof(buffer),fvoc)!=NULL) {

          if ((ps=strchr(buffer,'\n'))!=NULL)
            *ps='\0';

          strncpy(passtest,buffer,NPASS-1);
          str_upr(passtest);

          if (!quiet) {
            printf("%-33s",passtest);
            fflush(stdout);
          }

          ind_wheel=con_wheel=0;

          pre_user=NULL;
          cur_user=first_user;

          while (cur_user!=NULL) {

            usrdsc.dscw_length=strlen(cur_user->username);
            pwddsc.dscw_length=strlen(passtest);

            memcpy(ubuf,cur_user->username,usrdsc.dscw_length+1);
            memcpy(pbuf,passtest          ,pwddsc.dscw_length+1);

            usrdsc.dsca_pointer=ubuf;
            pwddsc.dsca_pointer=pbuf;

            if ((!quiet) && (!((con_wheel++) & MASKWH)))
              write(1,wheel[ind_wheel=(ind_wheel+1) & 0x3],2);

            comparisions++;

            lgihpwd(&outdsc,&pwddsc,cur_user->encr_algo1,cur_user->passwd_salt,&usrdsc);

            if ((*((dword *)cur_user->passwd1)    ==*((dword *)obuf)) &&
                (*((dword *)(cur_user->passwd1+4))==*((dword *)(obuf+4)))) {

              encryptions++;

              fprintf(fout,"User : [%s], Password : [%s]\n",cur_user->username,passtest);

              /* delete user from user's list */

              if (pre_user==NULL)
                first_user=cur_user->next;
              else
                pre_user->next=cur_user->next;
            }
            else
              pre_user=cur_user;

            /* next user */

            cur_user=cur_user->next;

          } /* while */

          if (!quiet)
            printf("\bfound: %u\n",encryptions);

          memcpy(read_passwd,passtest,pwddsc.dscw_length+1);

        } /* while */

      } /* for */

      end_stat();

      if (!quiet)
        print_stat(stdout);

      print_stat(fout);

      break;

    case SINGLE:

      print_title(fout);
      str_upr(pass_name);

      if (!quiet)
        putchar('\n');

      init_stat();

      while (fread(&user,sizeof(user),1,fSYSUAF)) {

        if (skip || (!((L_Flags_0 *)(&user.Login_Flags_0))->user_account)) {

          strip_name(usertest,user.Username,NPASS);

          usrdsc.dscw_length=strlen(usertest);
          pwddsc.dscw_length=strlen(pass_name);

          memcpy(ubuf,usertest ,usrdsc.dscw_length+1);
          memcpy(pbuf,pass_name,pwddsc.dscw_length+1);

          usrdsc.dsca_pointer=ubuf;
          pwddsc.dsca_pointer=pbuf;

          if ((!quiet) && (!((con_wheel++) & MASKWH)))
            write(1,wheel[ind_wheel=(ind_wheel+1) & 0x3],2);

          num_users++;
          comparisions++;

          lgihpwd(&outdsc,&pwddsc,user.Encr_algo1,user.Passwd_salt,&usrdsc);

          if ((*((dword *)user.Passwd1)    ==*((dword *)obuf)) &&
              (*((dword *)(user.Passwd1+4))==*((dword *)(obuf+4)))) {

            encryptions++;

            if (!quiet) {

              printf("\bUser : [%s], Password : [%s]\n",usertest,pass_name);
              ind_wheel=con_wheel=0;
            }

            fprintf(fout,"User : [%s], Password : [%s]\n",usertest,pass_name);

          }
        }
        else
          if (debug) {

            strip_name(buffer,user.Username,NPASS);
            printf("\b%s * User account is disabled *\n",buffer);
          }

      } /* while */

      end_stat();

      if (!quiet) {

        write(1,"\b ",2);
        print_stat(stdout);
      }

      print_stat(fout);

      break;

    case USER:

      print_title(fout);

      num_users=1;

      usrdsc.dscw_length=strlen(user_name);

      if (!quiet)
        putchar('\n');

      init_stat();

      while (fgets(buffer,sizeof(buffer),fvoc)!=NULL) {

        if ((ps=strchr(buffer,'\n'))!=NULL)
          *ps='\0';

        strncpy(passtest,buffer,NPASS-1);
        str_upr(passtest);

        if (!quiet)
          fputs(passtest,stdout);

        pwddsc.dscw_length=strlen(passtest);

        memcpy(ubuf,user_name,usrdsc.dscw_length+1);
        memcpy(pbuf,passtest ,pwddsc.dscw_length+1);

        usrdsc.dsca_pointer=ubuf;
        pwddsc.dsca_pointer=pbuf;

        comparisions++;

        lgihpwd(&outdsc,&pwddsc,user.Encr_algo1,user.Passwd_salt,&usrdsc);

        if ((*((dword *)user.Passwd1)    ==*((dword *)obuf)) &&
            (*((dword *)(user.Passwd1+4))==*((dword *)(obuf+4)))) {

          encryptions++;

          fprintf(fout,"User : %s, Password : %s\n",user_name,passtest);

          if (!quiet)
            puts(" ** HITTED **");

          break;  /* while */

        }

        if (!quiet)
          putchar('\n');

      } /* while */

      end_stat();

      if (!quiet)
        print_stat(stdout);

      print_stat(fout);

      break;

    case CREATE:

      while (fread(&user,sizeof(user),1,fSYSUAF)) {

        if (skip || (!((L_Flags_0 *)(&user.Login_Flags_0))->user_account)) {

          strip_name(buffer,user.Username,NPASS);

          if (debug)
            puts(buffer);

          fputs(buffer,fout);
          fputc('\n',fout);
        }
        else {

          if (debug) {

            strip_name(buffer,user.Username,NPASS);
            printf("%s * User account is disabled *\n",buffer);
          }
        }
      }

      break;

    case TEST:

      puts("Testing encrypted password\n");

      printf("  Username: %s  Password: %s  Salt: %04X\n",user_test,passwd_test,SALT_TEST);

      for (encrypt=0;encrypt<4;encrypt++) {

        switch (encrypt) {

          case 0:

            puts("\n  AUTODIN-II 32 bit crc code:");
            puts("\n    Algorithms is not currently supported.");

            continue; /* FOR */

          case 1:

            puts("\n  Purdy polynomial over salted input:");
            break;

          case 2:

            puts("\n  Purdy polynomial + variable length username:");
            break;

          case 3:

            puts("\n  PURDY_V + additional bit rotation:");
            break;

        }

        usrdsc.dscw_length=strlen(user_test);
        pwddsc.dscw_length=strlen(passwd_test);

        memcpy(ubuf,user_test  ,usrdsc.dscw_length+1);
        memcpy(pbuf,passwd_test,pwddsc.dscw_length+1);

        usrdsc.dsca_pointer=ubuf;
        pwddsc.dsca_pointer=pbuf;

        lgihpwd(&outdsc,&pwddsc,encrypt,SALT_TEST,&usrdsc);

        printf("\n    True     : ");
        print_bytes(hash_test[encrypt],8);

        printf("\n    Encrypted: ");
        print_bytes((byte *)obuf,8);

        if ((*((dword *)hash_test[encrypt])    !=*((dword *)obuf)) ||
            (*((dword *)(hash_test[encrypt]+4))!=*((dword *)(obuf+4))))
          puts("    TEST ERROR");
        else
          puts("    TEST OK");

      } /* for */

      break;

    case LIST_ALL:

      while (fread(&user,sizeof(user),1,fSYSUAF))
        print_record(++num_users);

      break;

    case LIST_ONE:

      print_record(num_users);

      break;

  } /* switch */

  return EXIT_SUCCESS;
}

/************************************
 *
 * Print the title of this program
 *
 */

void print_title(FILE *f)
{
  char *ps;

  if (f!=stdout) {

    memset(buffer,'=',77);
    buffer[77]='\0';

    fprintf(f,"\n*%s*\n",buffer);
  }

  fputs("\nVMS Crack V1.0 security program\n",f);
  fputs("Coded by Davide Casale in June 1994\n",f);
  fputs(" (email address: casale@pmn.it)\n",f);
  fputs("Coded and optimized by Mario Ambrogetti in June 1994\n",f);
  fputs(" (email address: s65710@galileo.polito.it)\n",f);
  fputs("Original algorithm by Shawn Clifford in February 1993\n",f);
  fputs(" (email address : sysop@robot.nuceng.ufl.edu)\n\n",f);

  if (f!=stdout) {

    switch (opr) {

      case VOCABULARY:

        ps=str_voca;
        break;

      case SINGLE:

        ps=str_sing;
        break;

      case USER:

        ps=str_user;
        break;
    }


    fprintf(f,"Mode : %s\n",ps);

    fprintf(f,"SYSUAF name file : %s\n",SYSUAF_name);

    if ((opr==VOCABULARY) || (opr==USER))
      fprintf(f,"Vocabulary name file : %s\n",voc_name);

    if (opr==SINGLE)
      fprintf(f,"Password to check : %s\n",pass_name);

    if (opr==USER)
      fprintf(f,"Username : %s\n",user_name);

    fprintf(f,"Output name file : %s\n",out_name);
    fprintf(f,"\n*%s*\n\n",buffer);
  }

  fflush(f);
}

/************************************
 *
 * Find a specific user
 *
 */

int find_user(char *user_name)
{
  int count=0;

  while (fread(&user,sizeof(user),1,fSYSUAF)) {

    count++;

    strip_name(buffer,user.Username,NPASS);

    if (debug)
      puts(buffer);

    if (strcmp(buffer,user_name)==0)
      return count;
  }

  return 0;
}

/************************************
 *
 * Find a specific password
 *
 */

int find_passwd(char *passwd)
{
  char *ps;

  while (fgets(buffer,sizeof(buffer),fvoc)!=NULL) {

    if ((ps=strchr(buffer,'\n'))!=NULL)
      *ps='\0';

    str_upr(buffer);

    if (strcmp(buffer,passwd)==0)
      return 1;
  }

  return 0;
}

/*****************************
 *
 * Print user's record
 *
 */

void print_record(int num_user)
{
  printf("*%05u*********************************************\n\n",num_user);

  printf("Record Header :%04X\n",user.Record_Header);
  printf("Username (loginid) :%.32s\n",user.Username);
  printf("Member UIC :%04X\n",user.Member_UIC);
  printf("Group  UIC :%04X\n",user.Group_UIC);
  printf("Nulls: ");print_bytes(user.Nulls,12);putchar('\n');
  printf("Account name :%.32s\n",user.Account_name);
  printf("Owner :%.*s\n",(int)user.length_owner,user.Owner);
  printf("Device :%.*s\n",(int)user.length_device,user.Device);
  printf("Default (SYS$LOGIN) directory :%.*s\n",(int)user.length_default,user.Default);
  printf("Default login command file :%.*s\n",(int)user.length_command,user.Default_command);
  printf("Default CLI :%.*s\n",(int)user.length_CLI,user.Default_CLI);
  printf("User defined CLI table name :%.*s\n",(int)user.length_CLI_tables,user.User_CLI_table);
  printf("Encrypted primary password   :");print_bytes(user.Passwd1,8);putchar('\n');
  printf("Encrypted secondary password :");print_bytes(user.Passwd2,8);putchar('\n');
  printf("Number of login fails :%u\n",user.Number_login_fails);
  printf("Password encryption salt :%04X\n",user.Passwd_salt);
  printf("Encryption algorithm code - primary password   :%u\n",user.Encr_algo1);
  printf("Encryption algorithm code - secondary password :%u\n",user.Encr_algo2);
  printf("Password minimum length :%u\n",user.Pass_minimum_length);
  printf("Filler :%02X\n",user.Filler1);
  printf("Account expiration date :");print_date(user.Account_ex_date);putchar('\n');
  printf("Password lifetime :");print_date(user.Password_lifetime);putchar('\n');
  printf("Password change date/time - primary password   :");print_date(user.Pass1_change_date);putchar('\n');
  printf("Password change date/time - secondary password :");print_date(user.Pass2_change_date);putchar('\n');
  printf("Last interactive login date/time     :");print_date(user.Last_interactive);putchar('\n');
  printf("Last non interactive login date/time :");print_date(user.Last_non_interactive);putchar('\n');
  printf("Authorize priviledges :");print_bytes(user.Authorize_priviledges,8);putchar('\n');
  printf("Default priviledges   :");print_bytes(user.Default_priviledges,8);putchar('\n');
  printf("Filler :");print_bytes(user.Filler2   ,20);putchar('\n');
  printf("        ");print_bytes(user.Filler2+20,20);putchar('\n');

  printf("Login Flags bits byte 0:\n");

  printf("  User can not use CTRL-Y :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->CTRL_Y));
  printf("  User is restricted to default command interpeter :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->default_com));
  printf("  SET PASSWORD command is disabled :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->set_pass));
  printf("  Prevent user from changing any defaults at login :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->prevent_login));
  printf("  User account is disabled :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->user_account));
  printf("  User will not receive the login welcome message :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->welcome));
  printf("  Announcement of new mail is suppressed :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->new_mail));
  printf("  Mail delivery to user is disabled :%s\n",AFF(((L_Flags_0 *)(&user.Login_Flags_0))->mail_delivery));

  printf("Login Flags bits byte 1:\n");

  printf("  User is required to use generated passwords :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->gen_passed));
  printf("  Primary password is expired   :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->primary_pass));
  printf("  Secondary password is expired :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->secondary_pass));
  printf("  All actions are audited :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->act_audited));
  printf("  User will not receive last login messages :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->last_login));
  printf("  User can not reconnect to existing processes :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->existing_proc));
  printf("  User can only login to terminals defined by the automatic login facility :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->user_login));
  printf("  User is required to change expired passwords :%s\n",AFF(((L_Flags_1 *)(&user.Login_Flags_1))->change_pass));

  printf("Login Flags bits byte 2:\n");

  printf("  User is restricted to captive account :%s\n",AFF(((L_Flags_2 *)(&user.Login_Flags_2))->captive_acc));
  printf("  Prevent user from executing RUN, MCR commands, or foreign commands :%s\n",AFF(((L_Flags_2 *)(&user.Login_Flags_2))->user_execut));
  printf("  Bits 2-7 Reserved for future use :%02X\n",((L_Flags_2 *)(&user.Login_Flags_2))->future_use);

  printf("Login Flags bits byte 3:\n");

  printf("  Reserved for future use :%02X\n",user.Login_Flags_3);

  printf("Network access bytes - primary days:\n");print_hours(user.Network_primary_days);
  printf("Network access bytes - seconday days:\n");print_hours(user.Network_seconday_days);
  printf("Batch access bytes - primary days:\n");print_hours(user.Batch_primary_days);
  printf("Batch access bytes - seconday days:\n");print_hours(user.Batch_seconday_days);
  printf("Local access bytes - primary days:\n");print_hours(user.Local_primary_days);
  printf("Local access bytes - seconday days:\n");print_hours(user.Local_seconday_days);
  printf("Dialup access bytes - primary days:\n");print_hours(user.Dialup_primary_days);
  printf("Dialup access bytes - secondary days:\n");print_hours(user.Dialup_secondary_days);
  printf("Remote access bytes - primary days:\n");print_hours(user.Remote_primary_days);
  printf("Remote access bytes - seconday days:\n");print_hours(user.Remote_seconday_days);

  printf("Filler :");print_bytes(user.Filler3,12);putchar('\n');
  print_days("Prime days :",user.Prime_days);
  printf("Filler :%02X\n",user.Filler4);
  printf("Default base priority :%u\n",user.Default_base_priority);
  printf("Maximum job queue priority :%u\n",user.Maximum_job_queue_priority);
  printf("Active process limit :%u\n",user.Active_process_limit);
  printf("Max. number of interactive, detached, and batch jobs :%u\n",user.Max_number_jobs);
  printf("Detached process limit :%u\n",user.Detached_process_limit);
  printf("Subprocess creation limit :%u\n",user.Subprocess_creation_limit);
  printf("Buffered I/O count :%u\n",user.Buffered_IO_count);
  printf("Timer queue entry limit :%u\n",user.Timer_queue_entry_limit);
  printf("AST queue limit :%u\n",user.AST_queue_limit);
  printf("Lock queue limit :%u\n",user.Lock_queue_limit);
  printf("Open file limit :%u\n",user.Open_file_limit);

  printf("Unknown :%u\n",user.unknown1);

  printf("Shared file limit :%u\n",user.Shared_file_limit);
  printf("Working set quota :%lu\n",user.Working_set_quota);

  printf("Unknown :%lu\n",user.unknown2);

  printf("Working set extent :%lu\n",user.Working_set_extent);
  printf("Paging file quota :%lu\n",user.Paging_file_quota);
  printf("Maximum CPU time limit (in 10-milliseconds) :%lu\n",user.Maximum_CPU_time_limit);
  printf("Buffered I/O byte limit :%lu\n",user.Buffered_IO_byte_limit);
  printf("Paged buffer I/O byte count limit :%lu\n",user.Paged_buffer_IO_count_limit);
  printf("Initial byte quota (jobwide logical name table uses) :%lu\n",user.Initial_byte_quota);

  printf("Filler :");print_bytes(user.Filler5   ,16);putchar('\n');
  printf("        ");print_bytes(user.Filler5+16,16);putchar('\n');
  printf("        ");print_bytes(user.Filler5+32,16);putchar('\n');
  printf("        ");print_bytes(user.Filler5+48,16);putchar('\n');

  putchar('\n');
}


/**************************
 *
 * Initialize statistic
 *
 */

void init_stat(void)
{
  comparisions=0UL;
  encryptions=0;

  time(&start_time);
}

/****************************
 *
 * End statistic
 *
 */

void end_stat(void)
{
  time(&end_time);

  elapsed=difftime(end_time,start_time);

  if (elapsed<1.0)
    elapsed=1.0;

  report=(double)comparisions/elapsed;

  if (num_users!=0)
    performance=((double)encryptions/(double)num_users)*100.0;
  else
    performance=0.0;
}

/*************************
 *
 * Print statistic
 *
 */

void print_stat(FILE *f)
{
  if (f!=stdout) {

    buffer[0]='\n';
    buffer[1]='*';
    memset(buffer+2,'=',77);
    buffer[79]='*';
    buffer[80]='\n';
    buffer[81]='\0';

    fputs(buffer,f);
  }

#ifdef __WATCOMC__

  fputs("\nUsers                  : ",f);
  utoa(num_users,buffer,10);
  fputs(buffer,f);
  putc('\n',f);

  fputs("Password found         : ",f);
  utoa(encryptions,buffer,10);
  fputs(buffer,f);
  putc('\n',f);

  fputs("Comparisions           : ",f);
  ultoa(comparisions,buffer,10);
  fputs(buffer,f);
  putc('\n',f);

  fputs("Time elapsed in seconds: ",f);
  ultoa((dword)elapsed,buffer,10);
  fputs(buffer,f);
  putc('\n',f);

  fputs("Comparisions/seconds   : ",f);
  ultoa((dword)report,buffer,10);
  fputs(buffer,f);
  putc('.',f);
  utoa((word)((report-(double)((word)report))*100.0),buffer,10);
  fputs(buffer,f);
  putc('\n',f);

  fputs("Encryption performance : ",f);
  ultoa((dword)performance,buffer,10);
  fputs(buffer,f);
  putc('.',f);
  utoa((word)((performance-(double)((word)performance))*100.0),buffer,10);
  fputs(buffer,f);
  fputs("%\n",f);

#else

  fprintf(f,"\nUsers                  : %u\n",num_users);
  fprintf(f,"Password found         : %u\n",encryptions);
  fprintf(f,"Comparisons            : %lu\n",comparisions);
  fprintf(f,"Time elapsed in seconds: %.0f\n",elapsed);
  fprintf(f,"Comparisons/seconds    : %.2f\n",report);
  fprintf(f,"Encryption performance : %.2f%%\n",performance);

#endif  /* __WATCOMC__ */

  if (f!=stdout) {

    buffer[0]='\n';
    buffer[1]='*';
    memset(buffer+2,'=',77);
    buffer[79]='*';
    buffer[80]='\n';
    buffer[81]='\0';

    fputs(buffer,f);
  }

}

/**********************************************
 *
 * Copy and strip final space from string
 *
 */

void strip_name(char *str,char *name,int num)
{
  int i;

  for (i=0;(i<num) && (*name!=' ');i++)
    *str++=*name++;

  *str='\0';
}

/******************
 *
 * Dump bytes
 *
 */

void print_bytes(byte *bytes,int num)
{
  for (;num--;bytes++)
    printf("%02X ",*bytes);
}

/******************
 *
 * print data
 *
 */

void print_date(byte *date)
{
  print_bytes(date,8);
}

/************************
 *
 * Print mask hours
 *
 */

void print_hours(byte *byte_hours)
{
  register int i;

  printf("        ");

  for (i=0;i<24;i++)
    putchar((byte_hours[i>>3] & (1<<(i & 7)))?'.':'*');

  putchar('\n');

  printf("  hours=000000000111111111122222\n");
  printf("        123456789012345678901234\n");
}

/**********************
 *
 * Print mask days
 *
 */

void print_days(char *string,byte week)
{
  register int i;

  printf("%s",string);

  for (i=0;i<7;i++)
    putchar((week & (1<<i))?'.':'*');

  puts("\n            MTWTFSS");
}

/**********************
 *
 * Signal function
 *
 */

static void sgn_fn(void)
{
  static const char msg_abort[]="\n** ABORT **\n";

#ifdef __WATCOMC__
  signal(SIGBREAK,SIG_IGN);
#else
  signal(SIGFPE,SIG_IGN);
#endif

  signal(SIGABRT,SIG_IGN);
  signal(SIGILL ,SIG_IGN);
  signal(SIGINT ,SIG_IGN);
  signal(SIGSEGV,SIG_IGN);
  signal(SIGTERM,SIG_IGN);

  if(!quiet)
    fputs(msg_abort,stdout);

  if ((fout!=NULL) && ((opr==VOCABULARY) || (opr==SINGLE) || (opr==USER))) {

    end_stat();

    if (!quiet)
      print_stat(stdout);

    fputs(msg_abort,fout);

    print_stat(fout);

    fflush(fout);


  }

  exit(EXIT_FAILURE);
}

/***********************
 *
 * Exit function
 *
 */

void exit_fn(void)
{
  if (fSYSUAF!=NULL)
    fclose(fSYSUAF);

  if (fvoc!=NULL)
    fclose(fvoc);

  if (fout!=NULL)
    fclose(fout);
}

/*************************************
 *
 * strdup is not ANSI C function
 *
 */

char *str_dup(const char *s)
{
  char *ps;

  if ((ps=(char *)malloc(strlen(s)+1))!=NULL)
    strcpy(ps,s);

  return (ps);
}

/************************************
 *
 * strupr is not ANSI C function
 *
 */

void str_upr(char *s)
{
  for(;*s!='\0';s++)
    *s=toupper(*s);
}
