#ifndef __MYTYPES__
#define __MYTYPES__

#include <limits.h>

/* define byte (8 bit) */

#define BYTE_MAX 0xFFU

#if UCHAR_MAX==BYTE_MAX
  typedef unsigned char byte;
#elif USHRT_MAX==BYTE_MAX
  typedef unsigned short byte;
#elif UINT_MAX==BYTE_MAX
  typedef unsigned int byte;
#elif ULONG_MAX==BYTE_MAX
  typedef unsigned long byte;
#else
# error Error byte not defined
#endif

/* define word (16 bit) */

#define WORD_MAX 0xFFFFU

#if UCHAR_MAX==WORD_MAX
  typedef unsigned char word;
#elif USHRT_MAX==WORD_MAX
  typedef unsigned short word;
#elif UINT_MAX==WORD_MAX
  typedef unsigned int word;
#elif ULONG_MAX==WORD_MAX
  typedef unsigned long word;
#else
# error Error word not defined
#endif

/* define dword (32 bit) */

#define DWORD_MAX 0xFFFFFFFFUL

#if UCHAR_MAX==DWORD_MAX
  typedef unsigned char dword;
#elif USHRT_MAX==DWORD_MAX
  typedef unsigned short dword;
#elif UINT_MAX==DWORD_MAX
  typedef unsigned int dword;
#elif ULONG_MAX==DWORD_MAX
  typedef unsigned long dword;
#else
# error Error dword not defined
#endif

typedef struct {

          dword d_low;
          dword d_high;

        } qword;

typedef struct {

          word w_low;
          word w_high;

        } dword_t;

typedef struct {

          word  w0;
          dword l_mid;
          word  w3;

        } qword_t;

#endif /* __MYTYPES__ */
