#include <stdio.h>
#include <string.h>
#include <errno.h>

#define SEPCHAR1 '-'

int optind=1;
char *optarg;

static char *p=NULL;

int getopt(int argc,char *argv[],char *opt)
{
  unsigned char ch;
  char *opt_ch;

  if (argc>optind) {

    if (p==NULL) {

      if ((p=argv[optind])==NULL || (*(p++)!=SEPCHAR1)) {

        optarg=p=NULL;

        return EOF;
      }

      if (*p==SEPCHAR1) {

	optind++;
        optarg=p=NULL;

        return EOF;
      }

      if ((ch=*(p++))=='\0') {

	optind++;
        optarg=p=NULL;

        return EOF;
      }

      if ((ch==':') || ((opt_ch=strchr(opt,ch))==NULL)) {

	optarg=NULL;
	errno=EINVAL;
	perror("get command line option");
        putchar('\n');

	return('?');
      }

      if ((*(++opt_ch)==':')  || (*opt_ch=='*')) {

	optind++;

	if (*p=='\0') {

          if (*opt_ch!='*') {

	    if (argc<=optind) {

	      optarg=NULL;
	      errno=EINVAL;
	      perror("get command line option");
              putchar('\n');

	      return('?');
            }

	    p=argv[optind++];

          }
          else
            p=NULL;
        }

	optarg=p;
	p=NULL;

      }
      else {

	if (*p=='\0') {

	  optind++;
	  p=NULL;
	}

	optarg = NULL;
      }

      return ch;
    }
  }

  optarg=p=NULL;

  return EOF;
}
