Unit Protocol;

INTERFACE

Uses _Exit, DOS, CRT, TDK_Vars, DoorKit1, DoorKit2, DoorKit3, EXEC;

VAR
   SendArray     : ARRAY[1..15] OF PathStr;
   FileCount     : BYTE;
   ProtocolError : INTEGER;
   UserProtocol  : CHAR; { L - Local }
                         { X - Xmodem }
                         { 1 - Xmodem1k }
                         { Y - Ymodem }
                         { G - YmodemG }
                         { Z - Zmodem }
   DstPath : STRING;
   SrcFile : STRING;

FUNCTION  AddSendFile(Filename : STRING) : BOOLEAN;
PROCEDURE SetLocalProtocol;
PROCEDURE SetXmodem;
PROCEDURE SetXmodem1k;
PROCEDURE SetYmodem;
PROCEDURE SetYmodemG;
PROCEDURE SetZmodem;
PROCEDURE SelectProtocol;
FUNCTION  Send : BOOLEAN;
FUNCTION  Receive(Path : STRING) : BOOLEAN;
FUNCTION  PDriveInstalled : BOOLEAN;

IMPLEMENTATION

FUNCTION AddSendFile(Filename : STRING) : BOOLEAN;
BEGIN
   AddSendFile := FALSE;
   IF (FileCount = 1) AND (UserProtocol IN ['X', '1']) THEN EXIT;
   IF FileCount = 15 THEN EXIT;
   IF FExist(Filename) THEN
   BEGIN
      INC(FileCount, 1);
      SendArray[Filecount] := Filename;
      AddSendFile := TRUE;
   END;
END;

PROCEDURE SetLocalProtocol;
BEGIN
   UserProtocol := 'L';
   Log('Local protocol selected');
END;

PROCEDURE SetXmodem;
BEGIN
   UserProtocol := 'X';
   Log('Xmodem protocol selected');
END;

PROCEDURE SetXmodem1k;
BEGIN
   UserProtocol := '1';
   Log('Xmodem-1k protocol selected');
END;

PROCEDURE SetYmodem;
BEGIN
   UserProtocol := 'Y';
   Log('Ymodem protocol selected');
END;

PROCEDURE SetYmodemG;
BEGIN
   UserProtocol := 'G';
   Log('YmodemG protocol selected');
END;

PROCEDURE SetZmodem;
BEGIN
   UserProtocol := 'Z';
   Log('Zmodem protocol selected');
END;

PROCEDURE SelectProtocol;
VAR
   Ch : CHAR;

BEGIN
   IF NOT Local THEN
   BEGIN
      Ch := #0;
      REPEAT
         sWriteln('');
         InfoText('Please Select A Protocol:');
         sWriteln('');
         LineBar(1,0,33);
         CPrompt('X',' Xmodem');    sWriteln('');
         CPrompt('1',' Xmodem-1k'); sWriteln('');
         CPrompt('Y',' Ymodem');    sWriteln('');
         CPrompt('G',' YmodemG');   sWriteln('');
         CPrompt('Z',' Zmodem');    sWriteln('');
         LineBar(1,0,33);
         FancyPrompt;
         Ch := sReadKey;
         Ch := UPCASE(Ch);
         sWriteln('');
      UNTIL Ch IN ['X', '1', 'Y', 'G', 'Z'];
   END ELSE
      Ch := 'L';

   CASE Ch OF
      'L' : SetLocalProtocol;
      'X' : SetXmodem;
      '1' : SetXmodem1k;
      'Y' : SetYmodem;
      'G' : SetYmodemG;
      'Z' : SetZmodem;
   END;
END;

FUNCTION LocateFile(FName : STRING) : STRING;
VAR
   F : STRING;

BEGIN
   LocateFile := '';
   IF FExist(FName) THEN
      LocateFile := FExpand(FName)
   ELSE
      LocateFile := FSearch(FName, GetEnv('PATH'));
END;

FUNCTION LocatePDrive : STRING;
BEGIN
   LocatePDrive := Protocol.LocateFile('PDRIVE.EXE');
END;

FUNCTION PDriveParams : STRING;
VAR
   Params : STRING;

BEGIN
   Params := '';
   Params := Params + '/B' + IntToStr(DoorSys.BaudRate) + ' ';
   Params := Params + '/C' + IntToStr(DoorSys.ComPort) + ' ';
   IF Ctl.NSP THEN
   BEGIN
      Params := Params + '/H' + Ctl.HexAddr + ' ';
      Params := Params + '/I' + IntToStr(Ctl.IRQ) + ' ';
   END;
   Params := Params + '/D';
   CASE DoorSys.WhichIO OF
      InternalIO : Params := Params + '1 ';
        FossilIO : Params := Params + '2 ';
          DigiIO : Params := Params + '3 ';
   END;
   CASE UserProtocol OF
      'X' : Params := Params + '/X ';
      '1' : Params := Params + '/K ';
      'Y' : Params := Params + '/Y ';
      'G' : Params := Params + '/G ';
      'Z' : Params := Params + '/Z ';
   END;
   PDriveParams := Params;
END;

FUNCTION ExecuteProtocol(Params : STRING) : INTEGER;
VAR
   FName  : STRING;
   TheDir : STRING;

BEGIN
   FName := LocatePDrive;
   IF FName = '' THEN EXIT;

   Params := PDriveParams + Params;
   GETDIR(0, TheDir);
   SaveScreen;
   DeInitComPort;
   ProtocolError := Do_Exec(FName, Params, Use_All, $ffff, TRUE);
   InitComPort;
   RestoreScreen;
   ShowStatusBar;
   CHDIR(TheDir);
   DoorSys.IdleCount := 0;
   UpdateTime;
   ExecuteProtocol := ProtocolError;
END;

FUNCTION ProtocolErr : STRING;
BEGIN
   CASE ProtocolError OF
      $0000 : ; { PDrive will exit at error level 0 if everything goes fine. }
      $0001 : ; { PDrive will exit at error level 1 if it cannot open the }
                { comport. }
      $0006 : ; { PDrive will exit at error level 6 if the file specified by }
                { the /F= or /L= command line parameters is not found. }
      $0064 : ; { PDrive will exit at error level 100 if a user aborts an }
                { upload or download. You can trap this error level in your }
                { program in order to prevent users from "Leeching" files }
                { from your system. }
      $0065 : ; { PDrive will exit at error level 101 if the upload or }
                { download is aborted locally by you. }

      $0101 : ; { Error preparing for swap: no space for swapping }
      $0102 : ; { Error preparing for swap: program too low in memory }

      $0200 : ; { Program file not found }
      $0201 : ; { Program file: Invalid drive }
      $0202 : ; { Program file: Invalid path }
      $0203 : ; { Program file: Invalid name }
      $0204 : ; { Program file: Invalid drive letter }
      $0205 : ; { Program file: Path too long }
      $0206 : ; { Program file: Drive not ready }
      $0207 : ; { Batchfile/COMMAND: COMMAND.COM not found }
      $0208 : ; { Error allocating temporary buffer }

      $0300..
      $03FF : ; { $03xx : DOS-error-code xx calling EXEC }

      $0400 : ; { Error allocating environment buffer }

      $0500 : ; { Swapping requested, but prep_swap has not }
                { been called or returned an error. }
      $0501 : ; { MCBs don't match expected setup }
      $0502 : ; { Error while swapping out }

      $0600 : ; { Redirection syntax error }
      $0601..
      $06FF : ; { $06xx: DOS error xx on redirection }
   END;
END;

FUNCTION LocalSend : BOOLEAN;
VAR
   u  : BYTE;
   bs : STRING;
   Continue : BOOLEAN;

BEGIN
   LocalSend := FALSE;

   sGotoXY( 2, 5); IceText('Local download path : ', FALSE);
   sGotoXY(24, 5); OutTxt(15, 1, Dup(' ', 50));
   sGotoXY(24, 5); OutTxt(15, 1, DstPath);
   DstPath := NormalInput(50, DstPath);
   SetFore(7);
   SetBack(0);

   IF DstPath = '' THEN EXIT;
   DstPath := FixPath(DstPath);
   IF DExist(DstPath) THEN
   BEGIN
      sWriteln('');
      u := 1;
      Continue := TRUE;
      WHILE (u <= FileCount) AND (Continue) DO
      BEGIN
         bs := GetFilename(SendArray[u]);
         CASE CopyFile(SendArray[u], DstPath + bs) OF
            0 : ;     { Copy Ok }
            1 : BEGIN { Source = Destination }
                   sWriteln('');
                   IceText(' Source and destination are the same', TRUE);
                   Continue := FALSE;
                END;
            2 : BEGIN { Problem opening Source }
                   sWriteln('');
                   IceText(' Error occured opening Source', TRUE);
                   Continue := FALSE;
                END;
            3 : BEGIN { Problem with destination }
                   sWriteln('');  
                   IceText(' Error occured opening Destination', TRUE);
                   Continue := FALSE;
                END;
            4 : BEGIN { Problem during copy }
                   sWriteln('');  
                   IceText(' Error occured while copying', TRUE);
                   Continue := FALSE;
                END;
         END;
         INC(u, 1);
      END;
      IF NOT Continue THEN
      BEGIN
         sWriteln('');
         sWriteC(' ');
         AnyKey;
      END ELSE
      BEGIN
         FILLCHAR(SendArray, SIZEOF(SendArray), 0);
         FileCount := 0;
         LocalSend := TRUE;
      END;
   END ELSE
   BEGIN
      sWriteln('');
      IceText(' Download path does not exist!!  ', TRUE);
      sWriteln('');
      sWriteC(' ');
      AnyKey;
   END;
END;

FUNCTION Send : BOOLEAN;
VAR
   Params    : STRING;
   BatchList : Text;
   u         : BYTE;

BEGIN
   Send := FALSE;
   IF FileCount = 0 THEN EXIT;
   IF UserProtocol IN ['X', '1'] THEN
   BEGIN
      Params := Params + '/F=' + SendArray[1] + ' ';
      Log('Download : ' + SendArray[1]);
   END ELSE
   IF UserProtocol IN ['Y', 'G', 'Z'] THEN
   BEGIN
      ASSIGN(BatchList, 'BATCH.LST');
      REWRITE(BatchList);
      FOR u := 1 TO FileCount DO
      BEGIN
         Log('Download : ' + SendArray[u]);
         WRITELN(BatchList, SendArray[u]);
      END;
      CLOSE(BatchList);
      Params := Params + '/L=BATCH.LST ';
   END;

   sClrScr;
   OutTxt(9, 0, Dup('', 80));
   IceText(' File Transfer Protocol: ', FALSE);
   CASE UserProtocol OF
      'L' : IceText('Local Download', TRUE);
      'X' : IceText('Xmodem', TRUE);
      '1' : IceText('Xmodem-1k', TRUE);
      'Y' : IceText('Ymodem', TRUE);
      'G' : IceText('YmodemG', TRUE);
      'Z' : IceText('Ymodem', TRUE);
   END;
   IceText(' Start Receiving Your Files Now Or Press Ctrl-X Many Times To Abort...', TRUE);
   OutTxt(9, 0, Dup('', 80));

   CASE UserProtocol OF
      'L' : Send := LocalSend;
      'X',
      '1',
      'Y',
      'G',
      'Z' : BEGIN
               Params := Params + '/S ';
               IF ExecuteProtocol(Params) = 0 THEN
               BEGIN
                  FILLCHAR(SendArray, SIZEOF(SendArray), 0);
                  FileCount := 0;
                  Send := TRUE;
               END;
            END;
   END;
   IF UserProtocol IN ['Y', 'G', 'Z'] THEN FErase('BATCH.LST');
END;

FUNCTION LocalReceive(ReceivePath : STRING) : BOOLEAN;
VAR
   bs    : STRING;
   error : BOOLEAN;

BEGIN
   ReceivePath := FixPath(ReceivePath);

   LocalReceive := FALSE;

   sGotoXY( 2, 5); IceText('Local upload file : ', FALSE);
   sGotoXY(22, 5); OutTxt(15, 1, Dup(' ', 50));
   sGotoXY(22, 5); OutTxt(15, 1, SrcFile);
   SrcFile := NormalInput(50, SrcFile);
   SetFore(7);
   SetBack(0);

   IF SrcFile = '' THEN EXIT;
   IF FExist(SrcFile) THEN
   BEGIN
      sWriteln('');
      Error := FALSE;
      bs := GetFilename(SrcFile);
      CASE CopyFile(SrcFile, ReceivePath + bs) OF
         0 : ; { Copy Ok }
         1 : BEGIN { Source = Destination }
                sWriteln('');
                IceText(' Source and destination are the same', TRUE);
                Error := TRUE;
             END;
         2 : BEGIN { Problem opening Source }
                sWriteln('');
                IceText(' Error occured opening Source', TRUE);
                Error := TRUE;
             END;
         3 : BEGIN { Problem with destination }
                sWriteln('');
                IceText(' Error occured opening Destination', TRUE);
                Error := TRUE;
             END;
         4 : BEGIN { Problem during copy }
                sWriteln('');
                IceText(' Error occured while copying', TRUE);
                Error := TRUE;
             END;
      END;
      IF Error THEN
      BEGIN
         sWriteln('');
         AnyKey;
      END ELSE
         LocalReceive := TRUE;
   END ELSE
   BEGIN
      sWriteln('');
      IceText(' Upload file does not exist!!  ', TRUE);
      sWriteln('');
      AnyKey;
   END;
END;

FUNCTION Receive(Path : STRING) : BOOLEAN;
VAR
   Params : STRING;

BEGIN
   sClrScr;
   OutTxt(9, 0, Dup('', 80));
   IceText(' File Transfer Protocol: ', FALSE);
   CASE UserProtocol OF
      'L' : IceText('Local Upload', TRUE);
      'X' : IceText('Xmodem', TRUE);
      '1' : IceText('Xmodem-1k', TRUE);
      'Y' : IceText('Ymodem', TRUE);
      'G' : IceText('YmodemG', TRUE);
      'Z' : IceText('Ymodem', TRUE);
   END;
   IceText(' Start Sending Your Files Now Or Press Ctrl-X Many Times To Abort...', TRUE);
   OutTxt(9, 0, Dup('', 80));

   Receive := FALSE;
   IF NOT DExist(Path) THEN MakeDir(Path);
   IF NOT Local THEN
   BEGIN
      Params := '/R=' + FixPath(Path);
      IF ExecuteProtocol(Params) = 0 THEN
         Receive := TRUE;
   END ELSE
      Receive := LocalReceive(Path);
END;

FUNCTION PDriveInstalled : BOOLEAN;
BEGIN
   PDriveInstalled := LocatePDrive <> '';
END;

BEGIN
   FILLCHAR(SendArray, SIZEOF(SendArray), 0);
   FileCount := 0;
   ProtocolError := 0;
   UserProtocol := 'Z';
   DstPath := '';
   SrcFile := '';
END.
