{
          
                
              The DoorKit!
              
             
The BBS Door Development Kit By The People - For The People!


   Feel free to modify or optimize this code at will. All I ask is that if
   find a better way to do things (and you will), please send me a copy of
   your modifications. Thanks in advance!....Larry L. Athey....}

{$A+,B-,D+,E+,F+,G+,I-,L+,N-,O+,P-,Q-,R-,S-,T-,V+,X+}
UNIT ANSIUNIT;

INTERFACE

PROCEDURE DisplayANSI(Ch : CHAR);
{^ Displays a single character of an ANSI sequence to the screen, nothing
   is sent to the comport. You shouldn't ever have to call this procedure
   manually, this is taken care of by DOORKIT3.PAS / ShowScreen.}
PROCEDURE DisplayANSIstr(S : STRING);
{^ Displays a string of ANSI sequences to the screen, nothing is sent to
   the comport. You shouldn't ever have to call this procedure manually,
   this is taken care of by DOORKIT3.PAS / ShowScreen.}
PROCEDURE ResetAnsi;
{^ Resets all variables in this unit. You shouldn't ever have to call this
   procedure manually, this is taken care of by DOORKIT1.PAS / sClrScr.}

IMPLEMENTATION

USES CRT;

VAR
  ANSIst    : STRING;
  ANSI_SCPL : INTEGER;
  ANSI_SCPC : INTEGER;
  ANSI_FG   : INTEGER;
  ANSI_BG   : INTEGER;
  ANSI_C,
  ANSI_I,
  ANSI_B,
  ANSI_R    : BOOLEAN;
  P,X,Y     : INTEGER;

PROCEDURE DisplayANSI(Ch : CHAR);

PROCEDURE TABULATE;
VAR
  X : INTEGER;
BEGIN
  X := WHEREX;
  IF X < 80 THEN REPEAT INC(X) UNTIL (X MOD 8) = 0;
  IF X = 80 THEN X := 1;
  GOTOXY(X,WHEREY);
  IF X = 1 THEN WRITELN;
END;

PROCEDURE BACKSPACE;
VAR
  X : INTEGER;
BEGIN
  IF WHEREX > 1 THEN WRITE(^H,' ',^H) ELSE
  IF WHEREY > 1 THEN BEGIN
    GOTOXY(80,WHEREY - 1);
    WRITE(' ');
    GOTOXY(80,WHEREY - 1);
  END;
END;

PROCEDURE TTY(Ch : CHAR);
VAR
  X : INTEGER;
BEGIN
  IF ANSI_C THEN BEGIN
    IF ANSI_I THEN ANSI_FG := ANSI_FG OR 8;
    IF ANSI_B THEN ANSI_FG := ANSI_FG OR 16;
    IF ANSI_R THEN BEGIN
      X := ANSI_FG;
      ANSI_FG := ANSI_BG;
      ANSI_BG := x;
    END;
    ANSI_C := FALSE;
  END;
  TEXTCOLOR(ANSI_FG);
  TEXTBACKGROUND(ANSI_BG);
  CASE Ch OF
    ^G : BEGIN
           SOUND(2000);
           DELAY(75);
           NOSOUND;
         END;
    ^H : Backspace;
    ^I : Tabulate;
    ^J : BEGIN
           TEXTBACKGROUND(0);
           WRITE(^J);
         END;
    ^K : GOTOXY(1,1);
    ^L : BEGIN
           TEXTBACKGROUND(0);
           CLRSCR;
         END;
    ^M : BEGIN
           TEXTBACKGROUND(0);
           WRITE(^M);
         END;
    ELSE WRITE(Ch);
  END;
END;

PROCEDURE ANSIWrite(S : STRING);
VAR
  X : INTEGER;
BEGIN
  IF POS('[255D',S) > 0 THEN EXIT;
  FOR X := 1 TO LENGTH(S) DO TTY(S[X]);
END;

FUNCTION Param : INTEGER;
VAR
  S  : STRING;
  X,
  XX : INTEGER;
  B  : BOOLEAN;
BEGIN
  B := FALSE;
  FOR X := 3 TO LENGTH(ANSIst) DO IF ANSIst[X] IN ['0'..'9'] THEN B := TRUE;
  IF NOT B THEN Param := - 1 ELSE BEGIN
    S := '';
    X := 3;
    IF ANSIst[3] = ';' THEN BEGIN
      Param := 0;
      DELETE(ANSIst,3,1);
      EXIT;
    END;
    REPEAT
      S := S + ANSIst[X];
      X := X + 1;
    UNTIL (NOT (ANSIst[X] IN ['0'..'9'])) OR (LENGTH(S) > 2) OR (X > LENGTH(ANSIst));
    IF LENGTH(S) > 2 THEN BEGIN
      ANSIWrite(ANSIst + Ch);
      ANSIst := '';
      Param := - 1;
      EXIT;
    END;
    DELETE(ANSIst,3,LENGTH(S));
    IF ANSIst[3] = ';' THEN DELETE(ANSIst,3,1);
    VAL(S,X,XX);
    Param := X;
  END;
END;

BEGIN
  IF (Ch <> #27) AND (ANSIst = '') THEN BEGIN
    TTY(Ch);
    EXIT;
  END;
  IF Ch = #27 THEN BEGIN
    IF ANSIst <> '' THEN BEGIN
      ANSIWrite(ANSIst + #27);
      ANSIst := '';
    END ELSE ANSIst := #27;
    EXIT;
  END;
  IF ANSIst = #27 THEN BEGIN
    IF Ch = '[' THEN ANSIst := #27 + '[' ELSE BEGIN
      ANSIWrite(ANSIst + Ch);
      ANSIst := '';
    END;
    EXIT;
  END;
  IF (Ch = '[') AND (ANSIst <> '') THEN BEGIN
    ANSIWrite(ANSIst + '[');
    ANSIst := '';
    EXIT;
  END;
  IF NOT (Ch IN ['0'..'9',';','A'..'D','f','H','J','K','m','s','u']) THEN BEGIN
    ANSIWrite(ANSIst + Ch);
    ANSIst := '';
    EXIT;
  END;
  IF Ch IN ['A'..'D','f','H','J','K','m','s','u'] THEN BEGIN
    CASE Ch OF
      'A' : BEGIN
              P := Param;
              IF P = - 1 THEN P := 1;
              IF WHEREY - P < 1 THEN GOTOXY(WHEREX,1) ELSE GOTOXY(WHEREX,WHEREY - P);
            END;
      'B' : BEGIN
              P := Param;
              IF P = - 1 THEN P := 1;
              IF WHEREY + P > 25 THEN GOTOXY(WHEREX,25) ELSE GOTOXY(WHEREX,WHEREY + P);
            END;
      'C' : BEGIN
              P := Param;
              IF P = - 1 THEN P := 1;
              IF WHEREX + P > 80 THEN GOTOXY(80,WHEREY) ELSE GOTOXY(WHEREX + P,WHEREY);
              END;
      'D' : BEGIN
              P := Param;
              IF P = - 1 THEN P := 1;
              IF WHEREX - P < 1 THEN GOTOXY(1,WHEREY) ELSE GOTOXY(WHEREX - P,WHEREY);
            END;
      'H',
      'f' : BEGIN
              Y := Param;
              X := Param;
              IF Y < 1 THEN Y := 1;
              IF X < 1 THEN X := 1;
              IF (X > 80) OR (X < 1) OR (Y > 25) OR (Y < 1) THEN BEGIN
                ANSIst := '';
                EXIT;
              END;
              GOTOXY(X,Y);
            END;
      'J' : BEGIN
              P := Param;
              IF P IN [0,1,2] THEN CLRSCR;
            END;
      'K' : CLREOL;
      'm' : BEGIN
              IF ANSIst = #27 + '[' THEN BEGIN
                ANSI_FG := 7;
                ANSI_BG := 0;
                ANSI_I := FALSE;
                ANSI_B := FALSE;
                ANSI_R := FALSE;
              END;
              REPEAT
                P := Param;
                CASE P OF
                - 1 : ;
                  0 : BEGIN
                        ANSI_FG := 7;
                        ANSI_BG := 0;
                        ANSI_I  := FALSE;
                        ANSI_R  := FALSE;
                        ANSI_B  := FALSE;
                      END;
                  1 : ANSI_I  := TRUE;
                  5 : ANSI_B  := TRUE;
                  7 : ANSI_R  := TRUE;
                 30 : ANSI_FG := 0;
                 31 : ANSI_FG := 4;
                 32 : ANSI_FG := 2;
                 33 : ANSI_FG := 6;
                 34 : ANSI_FG := 1;
                 35 : ANSI_FG := 5;
                 36 : ANSI_FG := 3;
                 37 : ANSI_FG := 7;
                 40 : ANSI_BG := 0;
                 41 : ANSI_BG := 4;
                 42 : ANSI_BG := 2;
                 43 : ANSI_BG := 6;
                 44 : ANSI_BG := 1;
                 45 : ANSI_BG := 5;
                 46 : ANSI_BG := 3;
                 47 : ANSI_BG := 7;
               END;
               IF ((P >= 30) AND (P <= 47)) OR (P = 1) OR (P = 5) OR (P = 7) THEN ANSI_C := TRUE;
             UNTIL P = - 1;
           END;
     's' : BEGIN
             ANSI_SCPL := WHEREY;
             ANSI_SCPC := WHEREX;
           END;
     'u' : BEGIN
             IF ANSI_SCPL > - 1 THEN GOTOXY(ANSI_SCPC,ANSI_SCPL);
             ANSI_SCPL := - 1;
             ANSI_SCPC := - 1;
           END;
    END;
    ANSIst := '';
    EXIT;
  END;
  IF Ch IN ['0'..'9',';'] THEN ANSIst := ANSIst + Ch;
  IF LENGTH(ANSIst) > 50 THEN BEGIN
    ANSIWrite(ANSIst);
    ANSIst := '';
    EXIT;
  END;
END;

PROCEDURE DisplayANSIstr(S : STRING);
VAR
  I : BYTE;
BEGIN
  FOR I := 1 TO LENGTH(S) DO DisplayANSI(S[I]);
END;

PROCEDURE ResetAnsi;
BEGIN
  ANSIst    := '';
  ANSI_SCPL := - 1;
  ANSI_SCPC := - 1;
  ANSI_FG   := 7;
  ANSI_BG   := 0;
  ANSI_C    := FALSE;
  ANSI_I    := FALSE;
  ANSI_B    := FALSE;
  ANSI_R    := FALSE;
END;

BEGIN
  ResetAnsi;
END.
