'******************************************************************************
'*                                                                            *
'*                           D O O R   S K E L E T O N                        *
'*                                                                            *
'*       Use this skeleton to create your own door files using BC7MDM.LIB or  *
'*   QB45MDM.LIB.  Just go into the sub Main and begin your program.  This    *
'*   file will initialize the modem and look for the name of the drop file to *
'*   use on the command line when it is started.                              *
'*                                                                            *
'*       This file is only to be used as a guide.  Some modifications may be  *
'*   needed to actually create a finished product.  Use and distribute this   *
'*   file SKELETON.BAS Freely                                                 *
'*                                                                            *
'*       This file requires either BC7MDM.LIB or QB45MDM.LIB to function.     *
'*   These librarys are available on the Final Approach BBS (412) 843-7147    *
'*   14.4k Baud.  For the latest versions of these librarys and other utils   *
'*   call today!                                                              *
'*                                                                            *
'******************************************************************************


CONST YES = -1
CONST NO = 0


' ************************ Put Sub and Function Declarations here ***********

DECLARE SUB Main ()

' ***************************************************************************


'$INCLUDE: 'MDM.INC'
'$INCLUDE: 'DOOR.INC'

ON ERROR GOTO trap   '   Prevent any chances of Lock-Ups.

lin$ = COMMAND$      '   Get the Door file type.  You will run this door like
										 '   <Door> CHAIN.TXT for chain.txt, <Door> DOOR.SYS
										 '   for door.sys and so on....  if there is no command
										 '   line then it will default to local mode.

'  *******  Look for a known Drop File type **********

df% = 0
IF INSTR(lin$, "CHAIN.TXT") THEN df% = 1
IF INSTR(lin$, "DOOR.SYS") THEN df% = 2
IF INSTR(lin$, "DORINFO1.DEF") THEN df% = 3

' *******  Set up variables.  ************************


SELECT CASE df%
	CASE 0                            ' No Drop file, Local mode
		baud = 0
		lcl = -1
		LUser.useransi = -1
		LUser.handle = "SysOp"
		U.Time.Secs& = 3600
		LUser.systemn = "Final Approach"
	CASE 1                             '  Read CHAIN.TXT drop file
		rd.chain.txt
		baud = LUser.commrate
		IF LUser.baudrate = 0 THEN
			baud = 0
			lcl = -1
		END IF
		IF LUser.commrate > 2400 THEN HandShake% = 3
	CASE 2                             '  Read DOOR.SYS drop file
		rd.door.sys
		baud = LUser.commrate
		IF LUser.baudrate = 0 THEN
			baud = 0
			lcl = -1
		END IF
		IF LUser.commrate > 2400 THEN HandShake% = 3
	CASE 3                             '  Read DORINFO1.DEF dropfile
		rd.dorinfox.def 1
		baud = LUser.baudrate
		IF LUser.baudrate = 0 THEN
			baud = 0
			lcl = -1
		END IF
END SELECT

IF LUser.port = 0 THEN LUser.port = 2

Using.ANSI% = LUser.useransi              ' Set the global ANSI variable to
					  ' know weather or not the user has
					  ' ANSI

InitTime U.Time.Secs&                     ' Initialize the users time online
					  ' U.Time.Secs& was read from the
					  ' Drop file.

Door.Name$ = "Your Door Name Here "       ' Program Name to appear on the
					  ' Status Bar.

Dir.Scr.Wrt% = -1                         ' Use Direct Screen Writes

Sta.Bar% = -1                             ' Allow a status Bar

port% = LUser.port                        ' Set the port to the User's Port.

FOSSIL% = 0                               ' Don't use a fossil driver

Err.Msg$ = ""                             ' clear the error message variable

Parity% = 0                               ' use default parity for specified
					  ' com port.

WordLen% = 8                              ' 8 bits

IRQ% = 0                                  ' use defualt irq for specified port

InitPort                                  ' initialize the com port.

StatusBar                                 ' Turn On the Status Bar

Main                                      ' Call the main SUB

ClearStatusBar                            ' Turn Off Status Bar

goodbye:                                  ' Label for Error Trap

ExitProgram                               ' Terminate Program.


trap:                                     ' Generic Error trap
RESUME goodbye                            ' Any error will cause it to end.

SUB Main
'***********************[ Put your program here ]****************************


'****************************************************************************

END SUB

