/* Example of how to create a single-lined sysop function key / status line */
/* personality for OpenDoors. This program requires a Borland compiler to   */
/* compile without changes. Note that the multiple-personality system       */
/* applies only to the DOS version of OpenDoors.                            */

#include <conio.h>
#include "opendoor.h"

char abtCorner[] = {32, 0x7f};

void SingleLinePersonality(BYTE btOperation);
void ODScrnSetBoundary(BYTE btLeft, BYTE btTop, BYTE btRight, BYTE btBottom);


int main(int argc, char *argv[])
{
   /* Do the standard OpenDoors command line parsing. */
   od_parse_cmd_line(argc, argv);

   /* Add your own personality here. */
   od_add_personality("SingleLine", 1, 24, SingleLinePersonality);

   /* Make your personality the default and current one. */
   od_control.od_default_personality = SingleLinePersonality;
   od_init();
   od_set_personality("SingleLine");
   ODScrnSetBoundary(1, 1, 80, 24); /* Required in 6.0 and earlier. */

   /* Your program continues as normal here: */
   od_clr_scr();
   od_disp_str("1\n\r2\n\r3\n\r4\n\r5\n\r6\n\r7\n\r8\n\r9\n\r10\n\r11\n\r");
   od_disp_str("12\n\r13\n\r14\n\r15\n\r16\n\r17\n\r18\n\r19\n\r20\n\r21\n\r");
   od_disp_str("22\n\r");
   od_disp_str("This is an example program with a single status line.\n\r");
   od_disp_str("Press [Enter] to exit.");
   od_get_answer("\n\r");
   od_exit(0, FALSE);
   return(0);
}


/* This is the personality function that you provide to display the status */
/* line.                                                                   */
void SingleLinePersonality(BYTE btOperation)
{
   switch(btOperation)
   {
      case PEROP_DISPLAY1:
      case PEROP_UPDATE1:
         /* Display or update your primary status line here: */
         textattr(0x7f); /* Color of text on status line. */
         gotoxy(1, 25);
         cputs("                                                                               ");
         gotoxy(1, 25);
         cprintf(" %s of %s          %d minutes left",
            od_control.user_name,
            od_control.user_location,
            od_control.user_timelimit);
         puttext(80, 25, 80, 25, &abtCorner);
         break;

      case PEROP_INITIALIZE:
         /* If you also want to customize the sysop function keys, you can */
         /* optionally include the following:                              */
         od_control.key_hangup=0x2300;
         od_control.key_drop2bbs=0x2000;
         od_control.key_dosshell=0x2400;
         od_control.key_chat=0x2e00;
         od_control.key_sysopnext=0x3100;
         od_control.key_lockout=0x2600;
         od_control.key_status[0]=0x3b00;
         od_control.key_status[1]=0x0000;
         od_control.key_status[2]=0x0000;
         od_control.key_status[3]=0x0000;
         od_control.key_status[4]=0x0000;
         od_control.key_status[5]=0x0000;
         od_control.key_status[6]=0x0000;
         od_control.key_status[7]=0x0000;
         od_control.key_status[8]=0x0000;
         od_control.key_keyboardoff=0x2500;
         od_control.key_moretime=0x4800;
         od_control.key_lesstime=0x5000;
         od_control.od_page_statusline=-1;
         break;
   }
}
