{$F+,O+,V-,I-,S-,R-}
{$M 65520,0,655360}
PROGRAM KTest; {Main Menu/Program}
USES
  DOS,
  CRT_,
  KMisc,
  KDrive;
VAR
  TempStr:STRING;
  Ch:Char;
  tDir:PathStr;
  Ct,Ct1:Byte;

PROCEDURE CheckMultiStatus;
BEGIN
  cClrScr;
  cWriteLn('Multi-Status :');
  CASE RequestedDevice OF
    UartDevice   : cWriteLn('Uart Device');
    FossilDevice : cWriteLn('Fossil Device');
    Int14Device  : cWriteLn('Int14 Device');
    Digi14Device : cWriteLn('Digi14 Device');
  END;
  cWriteLn('DoorDir          : '+DoorDir);
  cWriteLn('OrigDir          : '+OrigDir);
  cWriteLn('InFiles          : '+InFiles);
  cWriteLn('InZip            : '+InZip);
  cWriteLn('OutFiles         : '+OutFiles);
  cWriteLn('OutZip           : '+OutZip);
  cWriteLn('DropFilePath     : '+DropDir);
  cWriteLn('FullDropFilePath : '+FullDropFile);
  cWriteLn('Name             : '+UserFullName);
  cWriteLn('Comport          : '+N2S(ComportNum));
  cWriteLn('cBaud            : '+N2S(CallerBaudRate));
  cWriteLn('lBaud            : '+N2S(LockedBaudRate));
  cWriteLn('Player #         : '+N2S(PlayerNumber));
  cWriteLn('Graphix          : '+N2S(Ord(Graphix)));
  cWriteLn('IsComOn          : '+B2YN(IsComOn));
  cWriteLn('IsLocal          : '+B2YN(IsLocal));
  cWriteLn('TimeLeft         : '+N2S(TimeLeft));
  cWriteLn('BBSTimeLeft      : '+N2S(BBSTimeLeft));
  Wait;
END;

PROCEDURE KeyStuff;
VAR Ch:CHAR;X,Y:Byte;
BEGIN
  cClrScr;
  cWriteLnC('Key Input Test');
  cWriteLn('');
  SetXY(x,y);
  cWrite('Last Key verifier. ESC to Exit');
  REPEAT
     Ch:=cReadKey;
     cWrite('X01Y04ZCharacter Code : '+N2S(Ord(Ch)));
     IF (Ch=#0) THEN
       IF cKeyPressed THEN BEGIN
         Ch:=cReadKey;
         cWrite('X22Y04Z : '+N2S(Ord(Ch)));
       END;
  UNTIL Ch=#27;
  Ch:=#0;
  cWriteLn('');
  ClearRegion(1,2,24);
  cGotoXY(1,1);
  cWrite('C09Last Key verifier. ESC to ExitZ');
  cGotoXY(1,2);
  REPEAT
     Ch:=cReadKey;
     IF Ch=#0 THEN
       IF cKeyPressed THEN BEGIN
         Ch:=cReadKey;
         CASE Ch OF
           #72 :  cWrite('X01Y06Z  Up');
           #77 :  cWrite('X01Y06Z  Right');
           #75 :  cWrite('X01Y06Z  Left');
           #80 :  cWrite('X01Y06Z  Down');
         END;
       END;
  UNTIL Ch IN [#27,'x','X'];
END;

PROCEDURE DisplayColors;
BEGIN
  cClrScr;
  cWriteLnC('C04KDrive C07Color codes :');
  cWriteLn('');
  cWriteLn('C0F    Background Color');
  cWriteLn('C0F     0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F');
  cWriteLn('C0FT 0 C00  C10  C20  C30  C40  C50  C60  C70  '+
    'C80  C90  CA0  CB0  CC0  CD0  CE0  CF0  ');
  cWriteLn('C0Fe 1 C01  C11  C21  C31  C41  C51  C61  C71  '+
    'C81  C91  CA1  CB1  CC1  CD1  CE1  CF1  ');
  cWriteLn('C0Fx 2 C02  C12  C22  C32  C42  C52  C62  C72  '+
    'C82  C92  CA2  CB2  CC2  CD2  CE2  CF2  ');
  cWriteLn('C0Ft 3 C03  C13  C23  C33  C43  C53  C63  C73  '+
    'C83  C93  CA3  CB3  CC3  CD3  CE3  CF3  ');
  cWriteLn('C0F  4 C04  C14  C24  C34  C44  C54  C64  C74  '+
    'C84  C94  CA4  CB4  CC4  CD4  CE4  CF4  ');
  cWriteLn('C0FC 5 C05  C15  C25  C35  C45  C55  C65  C75  '+
    'C85  C95  CA5  CB5  CC5  CD5  CE5  CF5  ');
  cWriteLn('C0Fo 6 C06  C16  C26  C36  C46  C56  C66  C76  '+
    'C86  C96  CA6  CB6  CC6  CD6  CE6  CF6  ');
  cWriteLn('C0Fl 7 C07  C17  C27  C37  C47  C57  C67  C77  '+
    'C87  C97  CA7  CB7  CC7  CD7  CE7  CF7  ');
  cWriteLn('C0Fo 8 C08  C18  C28  C38  C48  C58  C68  C78  '+
    'C88  C98  CA8  CB8  CC8  CD8  CE8  CF8  ');
  cWriteLn('C0Fr 9 C09  C19  C29  C39  C49  C59  C69  C79  '+
    'C89  C99  CA9  CB9  CC9  CD9  CE9  CF9  ');
  cWriteLn('C0F  A C0A  C1A  C2A  C3A  C4A  C5A  C6A  C7A  '+
    'C8A  C9A  CAA  CBA  CCA  CDA  CEA  CFA  ');
  cWriteLn('C0F  B C0B  C1B  C2B  C3B  C4B  C5B  C6B  C7B  '+
    'C8B  C9B  CAB  CBB  CCB  CDB  CEB  CFB  ');
  cWriteLn('C0F  C C0C  C1C  C2C  C3C  C4C  C5C  C6C  C7C  '+
    'C8C  C9C  CAC  CBC  CCC  CDC  CEC  CFC  ');
  cWriteLn('C0F  D C0D  C1D  C2D  C3D  C4D  C5D  C6D  C7D  '+
    'C8D  C9D  CAD  CBD  CCD  CDD  CED  CFD  ');
  cWriteLn('C0F  E C0E  C1E  C2E  C3E  C4E  C5E  C6E  C7E  '+
    'C8E  C9E  CAE  CBE  CCE  CDE  CEE  CFE  ');
  cWriteLn('C0F  F C0F  C1F  C2F  C3F  C4F  C5F  C6F  C7F  '+
    'C8F  C9F  CAF  CBF  CCF  CDF  CEF  CFF  ');
  cWrite('C07');
  WaitC;
END;

PROCEDURE BlinkTest;
BEGIN
  cClrScr;
  cWriteLnC('Blink Test');
  cWriteLn('');
  cWriteLn('Test blinking codes!');
  cWriteLn('Testing blink. Is this working? Grey non-blinking.');
  SetFore(128+Blue);
  cWriteLn('Testing blink. Is this working? Blue blinking.');
  cWriteLn('C84Testing blink, Red blinking. C07Is this working? light grey non-blinking.');
  SetFore(128+White);
  cWrite('Testing blink. Is this working? White blinking.');
  cWriteLn('C84I think so! Red blinking.');
  cWriteLn('C07Hello, lightgrey non-blinking.');
  WaitC;
END;

PROCEDURE ColorTest;
BEGIN
  cWrite('C07');
  cClrScr;
  cWriteLnC('Color Test');
  cWriteLn('');
  cWriteLn('C07Testing different color codes :');
  cWriteLn('C02This is Green! C0FKDrive White!');
  cWriteLn(NoColor('C02This is NOT Green! C0FKDrive White!'));
  cWriteLn(NoColor('This leaves the screen the color of the last change, light cyan.'));
  cWriteLn('Changing the color to C0EYELLOW!');
  cWriteLn(NoColor('This is in Nocolor, but should be yellow!'));
  Wait;
  cWriteLn('C08');
END;

PROCEDURE VariousTests;
VAR TempStr:STRING;Ch:Char;
CONST nsTest1 : LongInt = 123456789;
      nsTest2 : LongInt = -123456789;
BEGIN
  cClrScr;
  cWriteLn('This should print, wait for a keypressed, and clear most of this lineZ');
  Wait;
  cWriteLn('X06Y01Zworks!');
  Wait;
  TempStr:='Testing';
  cWriteln(n2s(nstest1));
  cWriteln(commaplace(nstest1));
  cWriteln(n2s(nstest2));
  cWriteln(commaplace(nstest2));
  cWrite('GetNumber :');
  GetNumber(0,WhereX,WhereY,0,115200);
  cWriteLn('');
  cWriteLn(TempStr);
  cWrite('GetString :');
  GetString(TempStr,WhereX,WhereY,20);
  cWriteLn('');
  cWriteLn(TempStr);
  cWrite('Prompt :');
  Prompt(TempStr,20,True);
  cWriteLn(TempStr);
  cWriteLn('');
  cWrite('GetName :');
  GetName('',TempStr,20);
  cWriteLn('');
  SetPromptColors(Red,Cyan,Brown,'.');
  Prompt(TempStr,40,True);
  cWriteLn('');
  cWrite('GetName :');
  GetName('',TempStr,20);
  cWriteLn('');
  cWriteLn('Log directory : '+LogDir);
  Wait;
  cClrScr;
  cWriteLn('c04');
  cWriteLn('12345678911234567892123456789312345678941234567895123456789612345678971234567898');
  cWriteLn('X100X200X300X400X500X600X700X800');
  cWriteLn('X09HelloC09');
  cWriteLn(NoColor('X09Hello'));
  cWriteLnC('In The Center!');
  cWriteLnCX(20,'In The Center of 20!');
  cWriteLnCX(60,'In The Center of 60!');
END;

PROCEDURE ExtendedLine;
VAR Count:Word;
    ColorStr:STRING;
BEGIN
  ColorStr:='C04kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'+
            'C05kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'+
            'C06kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk';
  cClrScr;
  cWriteLnC('Extended Lines Test');
  cWriteLn('');
  FOR Count:=1 to 100 DO cWrite('A');
  cWriteLn('');
  cWriteLn('12345678901234567890');
  cWriteLn('Y05');
  cWrite(ColorStr);
  cWriteLn('');
  writeln(Length(NoColor(ColorStr)));
  WaitC;
END;

PROCEDURE AnsiDisplayTest;
BEGIN
  cClrScr;
  DisplayMultiFile('ANSITEST.DAT','3');WaitC;cWriteLn('');
  DisplayMultiFile('ANSITEST.DAT','1');WaitC;cWriteLn('');
  DisplayMultiFile('ANSITEST.DAT','2');WaitC;cWriteLn('');
END;

PROCEDURE GraphicsTest;
BEGIN
  cWrite('C0FGraphics Test : ');
  CASE Graphix OF
    gAsc  : ;
    gANS  : ;
    gRip  : cWriteLnC('Rip Version '+N2S(RipVer)+'P');
    gMaxx : cWriteLnC('Maxx Version '+N2S(MaxxVer)+'P');
  END;
{  WaitC;{}
END;

PROCEDURE TestAnsi(tDir:PathStr);
BEGIN
  DisplayFile(tDir);
  WaitC;
  cClrScr;
END;

PROCEDURE BitTesting;
CONST MaxBit= 32;
VAR Ct,Bits,mNum:Word;
  PROCEDURE BitHeader;
  BEGIN
  cWriteLn('C0F                   1                   2                   3');
  cWriteLn('C0F 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2');
  END;
BEGIN
  cClrScr;
  Bits:=0;
  BitHeader;
  FOR mNum:=1 TO MaxBit DO BEGIN
    SetBit(Bits,mNum,True);
    FOR Ct:=1 TO MaxBit DO
     IF GetBit(Bits,Ct) THEN cWrite('C0C Y') ELSE cWrite('C07 n');
    cWriteLn('C0D '+N2S(mNum)+' '+N2S(Bits)+' '+'C0E');
    ToggleBit(Bits,mNum);
    If mNum=16 THEN BEGIN
      Wait;
      BitHeader;
    END;
  END;
  Wait;
END;

PROCEDURE CheckTimeLEft;
CONST tNum:LongInt = 0 ;
BEGIN
  REPEAT
    IF tNum<>TimeLeft THEN BEGIN
      cGotoXY(1,15);
      cClrEol;
      cWriteLn(N2S(TimeLeft DIV 60)+':'+PadRCh(N2S(TimeLeft MOD 60),'0',2) );
      tNum:=TimeLeft;
    END;
  UNTIL cKeyPressed;
END;

PROCEDURE MinMaxTest;
VAR a1,a2,a3:Byte;
BEGIN
  cClrScr;
  a1:=12;a2:=125;a3:=250;
  cWriteLn('MinNum');
  cWrite(N2S(a1)+' '+N2S(a2)+' ');
  cWriteLn(N2S(MinNum(a1,a2)));
  cWriteLn('MaxNum');
  cWrite(N2S(a1)+' '+N2S(a2)+' ');
  cWriteLn(N2S(MaxNum(a1,a2)));
  cWriteLn('MinMaxNum');
  cWrite(N2S(a1)+' '+N2S(a2)+' '+N2S(a3)+' ');
  cWriteLn(N2S(MinMaxNum(a1,a2,a3)));
  WaitC;
END;

PROCEDURE WindowWrap;
BEGIN
  cClrScr;
  cWriteLn('WindowWrap Test');
  cWriteLn('');
  FOR Ct:=1 TO 81 DO cWrite('X');
  cWriteln('');
  cWriteLn('1234567890123456789012345678901234567890123456789012345678901234567890123456789012');
  Wait;
END;
PROCEDURE AnsiWIndowTest;
BEGIN
  ResetAnsiWindow;
  cWriteLnC('No ansi window!');
  WaitC;
  ExtendedLine;
  cGotoXY(1,23);
  cWriteLn('1234567890123456789012345678901234567890123456789012345678901234567890123456789012');
  cGotoXY(1,3);
  SetAnsiWindow(10,11,70,20);
  cWriteLnC('Ansi window!');
  WaitC;
  SetColor(0,7);
  ResetAnsiWindow;
END;

PROCEDURE DisplayTests;
BEGIN
  GraphicsTest;
  DisplayColors;
  WindowWrap;
  ColorTest;
  BlinkTest;
  AnsiDisplayTest;
  AnsiWindowTest;
END;

PROCEDURE Main;
VAR TempStr:STRING;Ch:Char;tDir:PathStr;Ct,Ct1:Byte;
BEGIN
  IF NOT IsLocal THEN BEGIN
    IF AskYN(False,True,'Drop Carrier? ') THEN HangupModem;
  END;
  DisplayTests;
  CheckTimeLeft;
  BitTesting;
  MinMaxTest;
  KeyStuff;
  VariousTests;{}
END;

PROCEDURE  MyInstall;FAR;
BEGIN
  Wait;
END;

PROCEDURE PreInit;
VAR Ch:Char;
BEGIN
  LogDir:=Addbackslash(DoorDir)+'KTEST.LOG';
  SetKibbs(Off);
  SetBorder(Black);
  SetProgram('KTEST');
  SetVersion('99.99');
  SetStatusLineColors(LightCyan,Blue,White,LightMagenta);
  Ch:=PromptCh('Y','YNQ'+#27,'C0FInit KDrive : <C0DYC0F>es or <C0DNC0F>o? : ');
  CASE Ch OF
    'Y' : BEGIN
      InstallProc:=@MyInstall;
      InitKDrive;
    END;
    'N' : SetCom(Off);
    ELSE Exit;
  END;
END;

Procedure List;
Var  Ch:Char;
const tnewstxtdir = 'tnews.txt';
Begin
  Repeat
    Ch:=PromptCh(' ','TQ'+#27,'View <T>oday''s News, or <Q>uit? : ');
    cClrScr;
    Case UpCase(ch) Of
      'T' : IF ExistFile(TNewsTxtDir) Then DisplayFile(TNewsTxtDir);
    End;
  Until Ch in [#27,'Q'];
End;

PROCEDURE BooleanCheck;
VAR TestBool:Boolean;
BEGIN
  TestBool:=False;
  WriteLn('Test Bool       = ',B2YN(TestBool));
  WriteLn('Test Bool (NOT) = ',B2YN(NOT TestBool));
  TestBool:=True;
  WriteLn('Test Bool       = ',B2YN(TestBool));
  WriteLn('Test Bool (NOT) = ',B2YN(NOT TestBool));
END;

PROCEDURE WaitTests;
CONST S :STRING = 'P';
BEGIN
  cWriteLn('         1         2         3         4         5         6         7         ');
  cWriteLn('1234567890123456789012345678901234567890123456789012345678901234567890123456789');
  cWriteLn('This is a test!');
  cWriteLn('Test P1P1');
  cWriteLn('Test +11 +1115P');
  cWriteLnC('NoColor Test :'+NoColor('C0A<PAUSE>')+'P');
  cWriteLnC('NoColor Test :P');
  cWriteLn('NoColor Test :P');
  cWriteLnC('C0BTest - in C0DCenterP');{}
  cWriteLnC('P');{}
  cWriteLnCX(20,'CP');{}
  cWriteLn('Test - PP');
  cWriteLn('Test - P1P1');
  cWriteLn('Test - P2P2');
{  WriteLn((S[Length(S)-1]+S[Length(S)]='P'));{}
  Wait;
  cClrScr;
  DisplayMultiFileCryptic('mixer.txt','@1');
END;

PROCEDURE MegaNumCheck;
CONST Num = 2147483647;
VAR Ct:LongInt;
    sStr:STRING;
BEGIN
  cWriteLn('Meganum check');
  cWriteLn('');

  Ct:=Num;
  sStr:=L2M(Ct,6);
  cWriteLn('');
  cWriteLn('Checking number : '+N2S(Ct));
  cWriteLn('Checking L2M : '+sStr);
  sStr:=N2S(M2L(sStr));
  cWriteLn('Checking M2L : '+sStr);

  Ct:=0;
  sStr:=L2M(Ct,6);
  cWriteLn('');
  cWriteLn('Checking number : '+N2S(Ct));
  cWriteLn('Checking L2M : '+sStr);
  sStr:=N2S(M2L(sStr));
  cWriteLn('Checking M2L : '+sStr);

  Ct:=-1;
  sStr:=L2M(Ct,6);
  cWriteLn('');
  cWriteLn('Checking number : '+N2S(Ct));
  cWriteLn('Checking L2M : '+sStr);
  sStr:=N2S(M2L(sStr));
  cWriteLn('Checking M2L : '+sStr);

  Wait;
END;

PROCEDURE DisTests;
BEGIN
  DisplayFile('tnews.dat');
  Wait;
END;

BEGIN
  Randomize;
  PreInit;
  ClrScr;
  CheckMultiStatus;
{  DisTests;
  WaitTests;
  BitTesting;{}
{  Exit;{}
  BooleanCheck;
  MegaNumCheck;
  Main;
  List;
  Wait;
END.
