/* GATEWAYS.H  Copyright (c) 1988  Dynasoft  P.O. Box 915  Davis CA  95617 */
/*============ Your GAME definitions =======================*/
     /*      vvvvvv change this to the name of your game function */
#define GAME d0main
#define NUMGATES 3 /* set this to the number of gates in your game */
/* Report the number of gates your game supports to David Larson */
/* Do not use NUMGATES in your game, use the value passed to your game */
/*============= Your Compiler definitions ==================*/
#define PROTO_ON 1      /* set to 0 if function prototyping not supported */
#define USE_longjmp 1   /* set to 0 if your compiler doesnt support longjmp */
#define REDUCE_STACK 0  /* set to 1 if your compiler provides > 5K stack space*/
#define LARGE_DATA 0 /* set to 1 if your memory model has >64K for data/heap */
/* set which compiler you are using to 1 and all others to 0 */
/* If your compiler isn't here, add it and add statements here and in g0kit.c */
/* as needed and send your modifications back to David Larson */
#define IBM_MICROSOFT 0
#define IBM_TURBO 1
#define IBM_AZTEC 0
#define CPM_AZTEC 0
#define AMIGA_MANX 0
/*================ Debugging options ====================================*/
/* setting vvvvv to 0 may have no effect on random#s for some compilers */
#define RANDOM_START 1 /* if set to 0, do so TEMPORARILY */
#define VALIDATE 1 /* if set to 0, would disable kit validation */
/*        reduce vvvv to increase probability of simulated carrier loss */
#define C_LOSS_P 24000 /* this number can be between 0 and 32000 */
/* set  vvvvvvvvvvv to 0 TEMPORARILY to bypass carrier loss simulation */
#define SIM_CARRIER 1
#define MAX_PLAYERS 150
#define gss_SIZE 128
/*=============================================================*/
#if PROTO_ON
int writeline(int,char*),writestr(int,char*);
int og_open(char*,int),og_create(char*),og_close(int),keyin(void);
int keystat(void),og_mode(int),og_gateways(int),isin(char*,char);
int *og_plscore(int),irandom(int),inpstr(char*,int),readline(int,char*,int,char);
void og_onexit(void (*fn)(void)),og_carrier(void),upcfy(char*),outstr(char*);
void keyout(char),*og_malloc(int),og_free(void*),trim(char*);
int GAME(int,int,int,int);
char *og_plname(int),upchar(char);
double drandom(void);
#else
int writeline(),writestr();
int og_open(),og_create(),og_close(),keyin();
int keystat(),og_mode(),og_gateways(),isin();
int *og_plscore(),irandom(),inpstr(),readline(),writeline();
void keyout(),og_onexit(),og_carrier(),upcfy(),outstr(),trim();
void *og_malloc(),og_free();
char *og_plname(),upchar();
int GAME();
double drandom();
#endif

/* Place common include files from your compiler here */

#include <stdio.h>

#if IBM_MICROSOFT || IBM_TURBO
#include <stdlib.h>
#include <io.h>
#endif
#if IBM_TURBO
#include <math.h>
#include <string.h>
#endif
#if AMIGA_MANX
#include <stdio.h>
#include <sgtty.h>
#define memset(x,y,z) setmem((x),(z),(y))
#endif
#define uread(fd,buf,size) read(fd,buf,size)
#define uwrite(fd,buf,size) write(fd,buf,size)

#if DEF_GLOBALS /* put the globals in the current module? */
  char gss[gss_SIZE];
  void *gp0,*gp1,*gp2,*gp3,*gp4,*gp5,*gp6,*gp7,*gp8,*gp9;
  int gfd0,gfd1,gfd2; /* use for opening files */
  int gflag0,gflag1,gflag2,gflag3; /* use for global bitmaps */
#else
  extern char gss[gss_SIZE];
  extern void *gp0,*gp1,*gp2,*gp3,*gp4,*gp5,*gp6,*gp7,*gp8,*gp9;
  extern int gfd0,gfd1,gfd2; /* use for opening files */
  extern int gflag0,gflag1,gflag2,gflag3; /* use for global bitmaps */
#endif
/*---------------------------------------------------------------------*/












