
unit freedoor;

{
        FreeDoor 1.0.6
        Release Date: 10/31/2000
        (C)opyright 2000, Mike Hodgson
        EleCom is (C)opyright Maarten Bekers

        Revision History

        1.0.6   ::  Fixed slight problem with timer code
                    StatFore and StatBack actually change the statusbar's
                        colors now.

        1.0.4   ::  Added support for WWIV and Synchronet colour codes.

        1.0.2   ::  Changed Statusbar code to use SysSysMsCount instead of
                        old, complicated elapsed time routine.
                    Took redundant code out of CGetChar.

        1.0.0   ::  Additions/Fixes supplied by Michael Preslar denoted by mp
                    Additions/Fixes supplied by Rick Parrish denoted by rp
                    Added MASK_* constants for CMaskInput (see freedoor.inc)
                    Fixed some more ANSI problems
                    Compiled and tested with Virtual Pascal 2.1 prebeta

        0.9.8   ::  Fixed major bug in CWriteFile()
                    Added DORINFOx.DEF support
                    Added /N<node number> switch

        0.9.5   ::  New ANSI parser written from scratch, some code
                    fixed that was messing up colours.

        0.9.2   ::  Initial public release.

        COMMAND LINE PARAMETER EXAMPLES

        doorname.exe /L                               -- for local mode
        doorname.exe /Dc:\path\to\door.sys /P#        -- for normal FOSSIL mode, # = port number
        doorname.exe /Dc:\path\to\door.sys /T /P#     -- Telnet mode, # = port handle

        If your system is using DOOR32.SYS, /T and /P# are not required.

}

{NOTE : Modify COLORDEF.INC to select which sets of colour codes you
        would like to support}

interface

uses
{$IFDEF OS2}os2base,{$ENDIF}                                    {mp}
{$IFDEF WIN32}windows,{$ENDIF}                                  {mp}

Use32, VPUtils, VpSysLow, crt, dos, sysutils, newansi, extra, elenorm;

{$I FREEDOOR.INC}

function InitDoorDriver : boolean;
Procedure DeInitDoorDriver;
Procedure CClrScr;
Procedure CClrEol;
Procedure CursorSave;
Procedure CursorRestore;
Procedure CursorUp (Distance : Integer);
Procedure CursorDown (Distance : Integer);
Procedure CursorBack (Distance : Integer);
Procedure CursorForward (Distance : Integer);
Procedure CGotoXY (X,Y : Integer);
Procedure ErrorWriteLn (S : String); {Prints message w/o calling statbar }
Procedure CWriteLn (S : String);
Procedure CWrite (S : String);
Procedure CGetChar (var Ch: Char);  { From Manning's MDoor kit! }
Procedure CReadLn (var S: String);  { From Manning's MDoor kit! }
Procedure CWriteLong (I : LongInt);
Procedure CGetByte (var B: Byte);
Procedure CWriteLnLong (I : LongInt);
Procedure CReadLnLong (var L: LongInt);
Procedure CPause;
Procedure CWriteFile (FN : String);
Function CMaskInput (mask : String; StrLength : Byte) : String;
Procedure CWindow (X1,Y1,X2,Y2 : Integer);
Function CEXYZSend (FN : String) : Boolean;

implementation


(*************************************************************)
 Procedure LocalLogin;
(*************************************************************)
var
  tempusername : String;
begin
  clrscr;
  textcolor(7);
  textbackground(0);
  WriteLn ('Enter your name or leave blank for SYSOP');
  Write (':: ');
  TextColor(15);
  ShowCursor;                                                   {mp}
  ReadLn (tempusername);
  HideCursor;                                                   {mp}
  If (tempusername <> '') then UserInfo.RealName := tempusername;
  UserInfo.Handle := UserInfo.RealName;
  TextColor(7);
end;

(*************************************************************)
 function ReadDropFile (DropPath : String) : Boolean;
(*************************************************************)
var
  f : text;           { Dropfile file variable }
  s : string;         { Temporary String }
  i : LongInt;        { Temporary Integer }

  Procedure ReadDoorSys;
  begin
    readln (f,s);
    delete (s,1,3);
    delete (s,2,1);
    val(s,UserInfo.ComPort,i);
    if UserInfo.ComPort <> 0 then UserInfo.ConnType := 1;
    readln(f,s); { remote baud rate}
    val(s,UserInfo.Baud,i);
    readln(f,s); {dbits}
    readln(f,s); {node num}
    UserInfo.Node := s;
    readln(f,s); {actual internal bbs}
    readln(f,s); {screen on}
    readln(f,s); {printer}
    readln(f,s); {page bell}
    readln(f,s); {caller bell}
    readln(f,s); {user name}
    UserInfo.RealName := s;
    UserInfo.Handle := UserInfo.RealName;
    readln(f,s); {city,state}
    UserInfo.CityState := s;
    readln(f,s); {home phone}
    readln(f,s); {work phone}
    readln(f,s); {password}
    readln(f,s); {security}
    val(s,UserInfo.ACS,i);
    readln(f,s); {times on}
    readln(f,s); {last called}
    readln(f,s); {secs left}
    readln(f,s); {time left}
    val(s,UserInfo.TimeLeft,i);
    UserInfo.TotalTime := UserInfo.TimeLeft;
    readln(f,s); {graphics code}
    if s='GR' then UserInfo.GraphMode:=ANSI_GRAPH
    else if s='RIP' then UserInfo.GraphMode:=RIP_GRAPH
    else UserInfo.GraphMode:=ASCII_GRAPH;
    close(f);
  end;

  Procedure ReadDoor32Sys;
  begin
    readln (f,s);
    val(s,UserInfo.ConnType,i);
    readln (f,s);
    val(s,UserInfo.ComPort,i);
    readln (f,s);
    val(s,UserInfo.Baud,i);
    readln (f,s);
    UserInfo.BBSID := s;
    readln (f,s);
    val(s,UserInfo.RecPos,i);
    readln (f,s);
    UserInfo.RealName := s;
    readln (f,s);
    UserInfo.Handle := s;
    readln (f,s);
    val(s,UserInfo.ACS,i);
    readln (f,s);
    val(s,UserInfo.TimeLeft,i);
    UserInfo.TotalTime := UserInfo.TimeLeft;
    readln (f,s);
    val (s,UserInfo.GraphMode,i);
    readln (f,s);
    UserInfo.Node := s;
    close(f);
  end;

  Procedure ReadDorinfo;
  begin
    readln (f,s);
    readln (f,s);
    readln (f,s);
    readln (f,s);
    val(s,UserInfo.ComPort,i);
    readln (f,s);
    val(s,UserInfo.Baud,i);
    readln (f,s);
    readln (f,s);
    UserInfo.RealName := s;
    readln (f,s);
    UserInfo.RealName := UserInfo.RealName + ' ' + s;
    UserInfo.Handle := UserInfo.RealName;
    readln (f,s);
    UserInfo.CityState := s;
    readln (f,s);
    if (s = '0') then UserInfo.GraphMode := ASCII_GRAPH else UserInfo.GraphMode := ANSI_GRAPH;
    readln (f,s);
    val(s,UserInfo.ACS,i);
    readln (f,s);
    val(s,UserInfo.TimeLeft,i);
    UserInfo.TotalTime := UserInfo.TimeLeft;
    readln (f,s);
    close(f);
  end;

begin
  assign (f,DropPath);
  if not (FileExists(DropPath)) then
  begin
    WriteLn ('ReadDropFile :: ERROR :: DropFile not found!');
    ReadDropFile := False;
  end
  else
  begin
    reset(f);
    UserInfo.DropFile := DropPath;
    if (UserInfo.DropType = 1) then ReadDoorSys
    else if (UserInfo.DropType = 2) then ReadDoor32Sys
    else if (UserInfo.DropType = 3) then ReadDorinfo;
    ReadDropFile := True;
  end;
end;

(*************************************************************)
 function tl: word;
(*************************************************************)
begin;
  tl := (SysSysMsCount div 1000) - SavedTime;
end;

(*************************************************************)
 procedure UpdateStatusBar;
(*************************************************************)
var
  c,d: word;
  x,y: integer;
  OldTextAttr : Byte;
begin
  OldTextAttr := TextAttr;
  x:=wherex;
  y:=wherey;
  window(1,25,80,25);
  textcolor(StatFore);
  textbackground(StatBack);
  if (FirstTime = True) then
  begin
    clreol;
    gotoxy(1,1);
    write(UserInfo.RealName);
    LastTime := 30000;
    FirstTime := False;
  end;
  c:= (UserInfo.TimeLeft-1) - (tl div 60);
  d:=60- (tl mod 60);
  if ((c -1 = -1) and (d-1 = 0)) then
    begin
      textcolor(7);
      textbackground(0);
      window(1,1,80,25-1);
      gotoxy(x,y);
      ErrorWriteLn('`0CTime limit exceeded');
      delay(1);
      halt(0);
    end;
  if ((SysSysMsCount div 1000 div 60) - (LkTime div 1000 div 60)) >= 5 then
    begin
      textcolor(7);
      textbackground(0);
      window(1,1,80,25-1);
      gotoxy(x,y);
      ErrorWriteLn('User Inactive.');
      delay(10);
      halt(0);
    end;
    if d <= (LastTime - 5) then
    begin
      gotoxy(74,1);
      write ('     ');
      gotoxy(74,1);
      write(c,':');
      if d<10 then write('0');
      write(d);
      LastTime:=d;
    end;
    TextAttr := OldTextAttr;
    window(1,1,80,25-1);
    gotoxy(x,y);
end;

(*************************************************************)
 function InitDoorDriver : boolean;
(*************************************************************)
var
  TempInt  : LongInt;
  TempStr  : String;
  Code     : LongInt;
{$IFDEF WIN32}                                                  {mp}
  pp:array[0..40] of char;                                      {mp}
  pc:pchar;                                                     {mp}
{$ENDIF}                                                        {mp}

begin
  MouseOff;                                                     {mp}
  HideCursor;
{$IFDEF WIN32}                                                  {mp}
  pc:=pp;                                                       {mp}
  pc:=strpcopy(pc,progname);                                    {mp}
  setconsoletitle(pc);                                          {mp}
{$ENDIF}                                                        {mp}

  UserInfo.ConnType := 0;
  UserInfo.BBSID := 'Unknown';
  UserInfo.Handle := 'Sysop';
  UserInfo.RealName := 'Sysop';
  UserInfo.CityState := 'Somewheresville';
  UserInfo.ACS := 255;
  UserInfo.TimeLeft := 3000;
  UserInfo.TotalTime := 3000;
  UserInfo.ComPort := 0;
  UserInfo.Baud := 0;
  UserInfo.Node := '0';
  UserInfo.Graphmode := ANSI_GRAPH;
  UserInfo.DropFile := '';
  UserInfo.DropType := 0;
  if (ParamCount = 0) then
  begin
    writeln ('InitDoorDriver :: ERROR :: You didn''t tell me what to do!');
    writeln ('Exiting.');
{mp}    writeln (' If you''re trying to load this program locally, you should do a');
{mp}    writeln;
{mp}    writeln (' '+paramstr(0)+' /l');

    InitDoorDriver := False;
  end
  else
  begin
    for TempInt := 1 to ParamCount do
      begin
        if (UpperCase(ParamStr(TempInt)) = '/L') then          {Local Only?}
          isLocal := True;
        if (pos('/D',UpperCase(ParamStr(TempInt))) <> 0) then  {Read Dropfile!}
          begin
            TempStr := '';
            TempStr := ParamStr(TempInt);
            delete(TempStr,1,2);
            if (pos('DOOR.SYS',UpperCase(TempStr)) <> 0) then UserInfo.DropType := 1 else
              if (pos('DOOR32.SYS',UpperCase(TempStr)) <> 0) then UserInfo.DropType := 2 else
              if (pos('DORINFO',UpperCase(TempStr)) <> 0) then UserInfo.DropType := 3 else UserInfo.DropType := 0;
            ReadDropFile (TempStr);
          end;
        if (pos('/T',UpperCase(ParamStr(TempInt))) <> 0) then UserInfo.ConnType := 02;
        if (pos('/N',UpperCase(ParamStr(TempInt))) <> 0) then
          begin
            TempStr := '';
            TempStr := ParamStr(TempInt);
            delete (TempStr,1,2);
            UserInfo.Node := TempStr;
          end;
        if (pos('/P',UpperCase(ParamStr(TempInt))) <> 0) then
          begin
            TempStr := '';
            TempStr := ParamStr(TempInt);
            delete (TempStr,1,2);
            val(TempStr,UserInfo.ComPort,Code);
          end;
      end;
    if (UserInfo.ConnType = 0) or (UserInfo.ComPort = 0) then isLocal := True;
    if (not isLocal) then
    begin
      Com_StartUp(UserInfo.ConnType);
      Com_SetDontClose(True);
      Com_OpenQuick(UserInfo.ComPort);
      Com_SendString(#27 + '[0;37m');
    end;
    if ((isLocal) and (UserInfo.DropType = 0)) then LocalLogin;
    LkTime := SysSysMsCount;
    SavedTime := SysSysMsCount div 1000;
    UpdateStatusBar;
    CWrite(#27 + '[0;37m');
    InitDoorDriver := True;
  end;
end;

(*************************************************************)
 Procedure DeInitDoorDriver;
(*************************************************************)
begin
  ShowCursor;
  if (not isLocal) then Com_Shutdown;
end;

(*************************************************************)
 Procedure CClrScr;
(*************************************************************)
begin
  if (not isLocal) then
    Com_SendString(#27 + '[2J');
  ClrScr;
end;

(*************************************************************)
 Procedure CClrEol;
(*************************************************************)
begin
  if (not isLocal) then
    Com_SendString(#27 + '[K');
  ClrEol;
end;

(*************************************************************)
 Procedure CursorSave;
(*************************************************************)
Begin
  CWrite (#27 + '[s');
End;

(*************************************************************)
 Procedure CursorRestore;
(*************************************************************)
Begin
  CWrite (#27 + '[u');
End;

(*************************************************************)
 Procedure CursorUp (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'A');
End;

(*************************************************************)
 Procedure CursorDown (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'B');
End;

(*************************************************************)
 Procedure CursorBack (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'D');
End;

(*************************************************************)
 Procedure CursorForward (Distance : Integer);
(*************************************************************)
Var
  DummyVal : String;
Begin
  Str (Distance, DummyVal);
  CWrite (#27 + '[' + DummyVal + 'C');
End;

(*************************************************************)
 Procedure CGotoXY (X,Y : Integer);
(*************************************************************)
var
  TempX : String;
  TempY : String;
begin
  Str(X,TempX);
  Str(Y,TempY);
  CWrite (#27 + '[' + TempY + ';' + TempX + 'H');
end;

(*************************************************************)
 Procedure ErrorWriteLn (S : String); {Prints message w/o calling statbar }
(*************************************************************)
begin
  if not (isLocal) then
    Com_SendString(S + #10#13);
  WriteLn (S);
end;

(*************************************************************)
 Procedure CWrite (S : String);
(*************************************************************)
begin
  Convert_To_ANSI(S);
  if (not isLocal) then
    Com_SendString(S);
  AWrite (S);
  UpdateStatusBar;
end;

(*************************************************************)
 Procedure CWriteLn (S : String);
(*************************************************************)
begin
  CWrite(S + #10#13);
end;

(*************************************************************)
  Procedure CWriteLnLong (I : LongInt);
(*************************************************************)
var
  S : String;
begin
  str(I,S);
  CWrite (S + #10#13);
end;

(*************************************************************)
  Procedure CWriteLong (I : LongInt);
(*************************************************************)
var
  S : String;
begin
  str(I,S);
  CWrite (S);
end;

(*************************************************************)
 Procedure CGetChar (var Ch : Char);  { From Manning's MDoor kit! }
(*************************************************************)
begin
     Ch := #0;
     if (isLocal) then
     begin
          repeat
                if (KeyPressed) then
                   Ch := ReadKey;
          UpdateStatusBar;
          until (Ch <> #0);
     end else
     begin
          repeat
                if (KeyPressed) then
                   Ch := ReadKey;
                     if (Com_CharAvail) then
                        Ch := Com_GetChar;
          UpdateStatusBar;
          until (Ch <> #0) or (Not(Com_Carrier));
     end;
     LkTime := SysSysMsCount;
end;

(*************************************************************)
  Procedure CGetByte (var B : Byte);
(*************************************************************)
var
  C : Char;
  Code : LongInt;
begin
  CGetChar(C);
  val (C,B,Code);
end;

(*************************************************************)
 Procedure CReadLn (var S: String);  { From Manning's MDoor kit! }
(*************************************************************)
var
   Ch: Char;
begin
     S := '';
     Ch := #0;
     if (isLocal) then
     begin
          repeat
                CGetChar(Ch);
                CWrite(Ch);
                if (Ch <> #13) and (Ch <> #10) then
                   S := S + Ch;
          until (Ch = #13);
     end else
     begin
          repeat
                CGetChar(Ch);
                CWrite(Ch);
                if (Ch <> #13) and (Ch <> #10) then
                   S := S + Ch;
          until (Ch = #13) or (Not(Com_Carrier));
     end;
     if Not(isLocal) then
        Com_SendChar(#10);
     WriteLn;
end;

(*************************************************************)
  Procedure CReadLnLong (var L : LongInt);
(*************************************************************)
var
  S : String;
  Code : LongInt;
begin
  CReadLn(S);
  val (S,L,Code);
end;

(*************************************************************)
 Procedure CPause;
(*************************************************************)
var
  C : Char;
begin
  CWrite (PAUSE_STRING);
  CGetChar(C);
  CwriteLn('');
end;

(*************************************************************)
 Procedure CWriteFile (FN : String);
(*************************************************************)
var
  f: text;
  c: char;
begin
  Assign(f,FN);
  Reset(f);
  if not (FileExists(FN)) then
    CWriteLn ('`0A*** FILE ' + FN + ' NOT FOUND ***')
  else
  begin
    repeat
      Read (f,c);
      CWrite (c);
    until (EOF(f));
    FlushAnsi;
    close (f);
  end;
end;

(*************************************************************)
 Function CMaskInput (mask : String; StrLength : Byte) : String;
(*************************************************************)
Var
  ch : Char;
  DummyByte : Byte;
  s : String;
begin
 s:='';
 CWrite ('`1F');
 For DummyByte := 1 to StrLength + 2 do CWrite(' ');
 CursorBack (StrLength + 1);
 s := '';
 if s<>'' then CWrite(s) else begin
  repeat
   CGetChar(ch);
   if (ch<>#8) and (ch<>^M) and (Pos(UpCase(Ch), mask) = 0) and (length(s) < StrLength) then
   begin
     s:=s+ch;
     CWrite(ch);
   end;
   if (ch=chr(8)) and (length(s)>0) then
   begin
     delete(s,length(s),1);
     CWrite(chr(8)+' '+chr(8));
   end;
  until (ch=^M);
 end;
 CWriteln('`07');
 CMaskInput := s;
end;

(*************************************************************)
 Procedure CWindow (X1,Y1,X2,Y2 : Integer);
(*************************************************************)
var
  TempInt : Integer;
  StoredX : Integer;
  StoredY : Integer;
begin
  StoredX := WhereX;
  StoredY := WhereY;
  CGotoXY (X1,Y1);
  CWrite ('');
  for TempInt := (X1 + 1) to (X2 - 1) do
    CWrite ('');
  CWrite ('');
  for TempInt := (Y1 + 1) to (Y2 - 1) do
  begin
    CGotoXY(X2,TempInt);
    CWrite ('');
  end;
  CGotoXY (X1,Y2);
  CWrite ('');
  for TempInt := (X1 + 1) to (X2 - 1) do
    CWrite ('');
  CWrite ('');
  for TempInt := (Y1 + 1) to (Y2 - 1) do
  begin
    CGotoXY(X1,TempInt);
    CWrite ('');
  end;
  CGotoXY(StoredX,StoredY);
end;

(*************************************************************)
 (* Totally un-tested, not sure it even works at all *)
 Function CEXYZSend (FN : String) : Boolean;
(*************************************************************)
var
  BaudStr : String;
  PortStr : String;
begin
  if isLocal then
  begin
    CWriteLn ('`0DCannot send file, door is running in local only mode.');
  end
  else
  begin
    Str(UserInfo.Baud,BaudStr);
    Str(UserInfo.ComPort,PortStr);
    SwapVectors;
    Exec ('CEXYZ.EXE',' /l' + BaudStr + ' /b' + BaudStr + ' /p' + PortStr + ' sz ' + FN);
    SwapVectors;
    if (DOSError <> 0) then
    begin
      CWriteLn ('`0DError sending file ' + FN);
      CEXYZSend := False;
    end
    else
    begin
      CWriteLn ('`0DFile ' + FN + ' sent.');
      CEXYZSend := True;
    end;
  end;
end;

initialization
begin
end;

finalization
begin
  DeInitDoorDriver;
end;

end.
