' This file is to be $INCLUDEd in your main source.
' ------------------------------------------------

$LIB IPRINT ON           'set interpreted print ON
$LIB COM ON              'turn on PB's communications library
$COM 2048                'set 2k input buffer
$ERROR ALL ON            'all error-checking on
DEFINT A-Z               'all variables integers by default

'Declare functions from library so you can use them.

DECLARE FUNCTION AnsiBlink() AS STRING
DECLARE FUNCTION AnsiClear() AS STRING
DECLARE FUNCTION AnsiColor(INTEGER,INTEGER) AS STRING
DECLARE FUNCTION AnsiDown(INTEGER) AS STRING
DECLARE FUNCTION AnsiLeft(INTEGER) AS STRING
DECLARE FUNCTION AnsiLocate(INTEGER,INTEGER) AS STRING
DECLARE FUNCTION AnsiReset() AS STRING
DECLARE FUNCTION AnsiRestPos() AS STRING
DECLARE FUNCTION AnsiRight(INTEGER) AS STRING
DECLARE FUNCTION AnsiSavePos() AS STRING
DECLARE FUNCTION AnsiUp(INTEGER) AS STRING
DECLARE FUNCTION Display(STRING,STRING) AS STRING
DECLARE FUNCTION DoorInput(STRING,INTEGER,INTEGER,STRING,STRING) AS STRING
DECLARE FUNCTION DoorInputWrap(STRING,INTEGER,STRING,INTEGER,INTEGER,STRING) AS STRING
DECLARE FUNCTION ExtraConfig() AS STRING
DECLARE FUNCTION FixedLength(BYVAL STRING,INTEGER) AS STRING
DECLARE FUNCTION InputBuffer() AS STRING
DECLARE FUNCTION LocalBuffer() AS STRING
DECLARE FUNCTION MixedCase(BYVAL STRING) AS STRING
DECLARE FUNCTION RemoteBuffer() AS STRING
DECLARE FUNCTION StripAnsi(STRING) AS STRING

'Declare procedures from library so you can use them.

DECLARE SUB ClearBuffer()
DECLARE SUB DoorCLS()
DECLARE SUB DoorPrint(INTEGER,BYVAL STRING)
DECLARE SUB ExitDoor(INTEGER)
DECLARE SUB Initialize()
DECLARE SUB LocalPrint(INTEGER,BYVAL STRING)
DECLARE SUB Pause(STRING)
DECLARE SUB PrintArray(INTEGER,INTEGER,STRING ARRAY)
DECLARE SUB PrintFile(INTEGER,INTEGER,STRING)
DECLARE SUB RemotePrint(INTEGER,BYVAL STRING)
DECLARE SUB WriteDropFile()

'Declare public variables from library so you can use them.

PUBLIC   CRLF$,_       'variables that are preset for programmer
         _
         Remote%,_    'variables set at beginning of door execution
         Ansi%,_      'which are useful to programmer
         UserName$,_
         DropFileType%,_
         _
         DoorName$,_         'settings that programmer can change
         AsciiTextFore%,_
         AsciiTextBack%,_
         StatusbarFore%,_
         StatusbarBack%,_
         BufferInput%,_
         MorePausePrompt$,_ 
         FellAsleepMsg$,_
         OutOfTimeMsg$,_
         KbInputTimeout%,_
         MaxMinutes%,_
         _
         drRegName$,_
         drRegCode$,_
         _
         ds.ComPort$,_     'variables gotten from door.sys
         ds.BpsRate$,_    '(see dropfile.txt for descriptions)
         ds.Parity$,_
         ds.Node$,_
         ds.DTERate$,_
         ds.ScreenState$,_
         ds.Printer$,_
         ds.PageBell$,_
         ds.CallerAlarm$,_
         ds.UserName$,_
         ds.CallingFrom$,_
         ds.PhoneNumber$,_
         ds.WorkPhone$,_
         ds.Password$,_
         ds.SecurityLevel$,_
         ds.TotalCalls$,_
         ds.LastCall$,_
         ds.SecondsLeft$,_
         ds.MinutesLeft$,_
         ds.Ansi$,_
         ds.PageLength$,_
         ds.ExpertMode$,_
         ds.Conferences$,_
         ds.CurrentConference$,_
         ds.SubscriptionExpiration$,_
         ds.UserNumber$,_
         ds.DefaultProtocol$,_
         ds.TotalUploads$,_
         ds.TotalDownloads$,_
         ds.DailyKTotal$,_
         ds.DailyKLimit$,_
         ds.BirthDate$,_
         ds.NodeMainDir$,_
         ds.DoorSYSDir$,_
         ds.SysopFirst$,_
         ds.Alias$,_
         ds.EventTime$,_
         ds.ErrorCorrecting$,_
         ds.GraphicsMode$,_
         ds.RecordLocking$,_
         ds.DefaultColor$,_
         ds.TimeCreditMinutes$,_
         ds.LastNewFileCheck$,_
         ds.TimeOfCall$,_
         ds.TimeOfLastCall$,_
         ds.DailyFilesLimit$,_
         ds.DownloadsToday$,_
         ds.TotalKUploaded$,_
         ds.TotalKDownloaded$,_
         ds.UserComment$,_
         ds.DoorsOpen$,_
         ds.MessagesLeft$,_
         _
         dd.BBSname$,_          'variables gotten from dorinfo1.def
         dd.SysopFirst$,_       'or dorinfox.def
         dd.SysopLast$,_        '(see dropfile.txt for descriptions)
         dd.ComPort$,_
         dd.ComPortSettings$,_
         dd.Reserved$,_
         dd.UserFirst$,_
         dd.UserLast$,_
         dd.CallingFrom$,_
         dd.Ansi$,_
         dd.SecLvl$,_
         dd.MinutesLeft$,_
         _
         ct.UserNumber$,_       'variables gotten from chain.txt
         ct.Alias$,_            '(see dropfile.txt for descriptions)
         ct.UserName$,_
         ct.Callsign$,_
         ct.Age$,_
         ct.Sex$,_
         ct.Gold$,_
         ct.LastLogonDate$,_
         ct.Columns$,_
         ct.Rows$,_
         ct.SecLvl$,_
         ct.CoSysopFlag$,_
         ct.SysopFlag$,_
         ct.Ansi$,_
         ct.Remote$,_
         ct.SecondsLeft$,_
         ct.GFilesDir$,_
         ct.DataDir$,_
         ct.DailyLog$,_
         ct.BpsRate$,_
         ct.ComPort$,_
         ct.BBSname$,_
         ct.SysopName$,_
         ct.TimeLoggedOn$,_
         ct.SecondsUsed$,_
         ct.KUploaded$,_
         ct.Uploads$,_
         ct.KDownloaded$,_
         ct.Downloads$,_
         ct.Parity$,_
         ct.DteRate$,_
         ct.Node$

$LINK "doorroot.pbl"   'link in the library

'The following variables you can change to customize your door.
'See doorroot.doc for a description of these variables.

DoorName$ = "Sample Door"
AsciiTextFore% = 7
AsciiTextBack% = 0
StatusbarFore% = 0
StatusbarBack% = 7
BufferInput% = 0
KbInputTimeout% = 300
MaxMinutes% = 0

Initialize   'Initialize isn't a variable. Leave it alone. :)

MorePausePrompt$ = AnsiReset$+"["+AnsiColor$(15,0)+"S"+AnsiReset$+"]"+AnsiColor$(15,0)+"top, "+AnsiReset$+"["+AnsiColor$(15,0)+"ENTER"+AnsiReset$+"]"+AnsiColor$(15,0)+" for More"
FellAsleepMsg$ = "Apparently you've fallen asleep!"
OutOfTimeMsg$ = "You're outta time for today!"

'You can name this file (doorroot.inc) to anything you want. You'll
'want to have a different one of these files for each door you write, unless
'you want each one to have the same DoorName$, which I doubt.
