' Sample Door
' a demonstration of some of DoorRoot's routines

' When compiling and running this program, remember that you should either
' run it with no parameters to start it in local mode, or pass the config
' filename on the command line (sample.cfg is included for this purpose),
' in which case you should be sure to edit the dropfile path on line 1.

' It will help to refer to the docs or help file when looking at the
' particular examples of DoorRoot's routines throughout this program.
' In addition to looking over this source, compile and run it also. Then
' when you're running it and find yourself thinking, "How was that done?",
' take a look at this source again.

' Before compiling and running this door, unzip SAMPLE.ZIP into your main
' PowerBasic directory, and copy DOORROOT.PBL & DOORROOT.PBH to there also.

$INCLUDE "doorroot.inc"

' Include file containing ANSI and ASCII displays for use throughout this
' door. This file is actually a just a bunch of variable declarations, all
' put into this file with incansi.exe or incansi2.exe. See the "IncludeANSI"
' section of the docs or help file for more info.
$INCLUDE "sampans.inc"

' Define "Press any key" prompt for passing to Pause procedure each time.
PausePrompt$ = AnsiColor$(7,0) + "[" + AnsiColor$(15,0) + "Press any key" + AnsiColor$(7,0) + "]"

' Print the main menu. See the SAMPANS.INC file.
' The Display$ function returns the first parameter if ANSI is enabled,
' or the second parameter if not.
DoorPrint 0, Display$( IntroANSI$, IntroASCII$ )

' Go to bottom of screen
if Ansi% then
   'ANSI is enabled - use ANSI esc-sequence to locate cursor
   DoorPrint 0,AnsiLocate$(23,1)
else
   'ANSI is disabled - move cursor down with repeated CRLF$ strings
	while csrlin < 23
      DoorPrint 0,CRLF$
	wend
end if

'prompt for user to press any key
Pause PausePrompt$


'printing and colorizing text and locating cursor
'------------------------------------------------

'clear local & remote screens
DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "Use " + AnsiColor$(11,0) + "DoorPrint" + AnsiColor$(15,0) + " where you would normally use " + AnsiColor$(13,0) + "PRINT" + AnsiColor$(15,0) + ". If the user has ANSI enabled,"
DoorPrint -1, "you can locate the cursor and colorize text."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint 0, CRLF$
Pause AnsiColor$(3,0) + "Press ENTER to begin the ANSI demonstration..."

if Ansi% then

   'user has ANSI enabled

   DoorPrint 0, AnsiLocate$(8,17) + AnsiColor$(3,0) + AnsiBlink$ + "Peekaboo!"
   delay 1/2
   DoorPrint 0, AnsiLocate$(17,39) + AnsiColor$(15,1) + AnsiBlink$ + "Peekaboo!"
   delay 1/2
   DoorPrint 0, AnsiLocate$(6,48) + AnsiColor$(2,4) + AnsiBlink$ + "Peekaboo!"
   delay 1/2
   DoorPrint 0, AnsiReset$ + AnsiLocate$(19,1) + AnsiColor$(10,0)
   DoorPrint -1, "You can also save then restore the position of the cursor."
   DoorPrint 0,  "For example (press a key)..."
   Pause ""

   DoorPrint 0, AnsiLocate$(10,1) + AnsiColor$(9,0)
   DoorPrint 0, "The cursor position has been saved at the arrow (press a key) ->"
   Pause ""

   'save cursor position
   DoorPrint 0, AnsiSavePos$

   DoorPrint 0, CRLF$ + AnsiColor$(11,0)
   DoorPrint 0, "Now watch it jump back there. (press a key)"
   Pause ""

   'restore cursor position
   DoorPrint 0, AnsiRestPos$

   DoorPrint 0, AnsiColor$(11,0) + "Here again!"

   delay 2

   DoorPrint 0, AnsiLocate$(22,1)

   DoorPrint -1, "There are a few more things you can do with ANSI, gone over in doorroot.doc."
   Pause PausePrompt$

else

   'user has ANSI disabled

   DoorPrint -1, CRLF$ + "ANSI is disabled, so the ANSI portion of the demo will be skipped." + CRLF$
   Pause PausePrompt$

end if


'printing text to local screen
'-----------------------------

DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "To print text to the local screen only, you can use plain ol' " + AnsiColor$(5,0) + "PRINT" + AnsiColor$(15,0) + ". However,"
DoorPrint -1, "if the text to be printed includes ANSI esc-sequences, use " + AnsiColor$(13,0) + "LocalPrint" + AnsiColor$(15,0) + " instead,"
DoorPrint -1, "and it'll translate the esc-sequences as it prints."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint 0, CRLF$ + AnsiColor$(4,0)

DoorPrint -1, "A possible use for printing something on the local end only would be when"
DoorPrint -1, "your door is running maintenance at the start of execution, and you want the"
DoorPrint -1, "sysop to see what's going on, but not the user. It might look like:"

Pause CRLF$+PausePrompt$

LocalPrint -1, AnsiColor$(5,0) + "(local-only display)"
delay .2
LocalPrint -1, AnsiColor$(13,0) + "Resurrecting dead players..."
delay .4
LocalPrint -1, "Purging inactive players..."
delay .4
LocalPrint -1, "Updating daily news..."
delay .4
LocalPrint -1, "Complete!"

Pause PausePrompt$


'printing file
'-------------

DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "You can print a text/ANSI file to local & remote with one command."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint -1, AnsiColor$(12,0)
DoorPrint -1, "Shoe.ans" + AnsiColor$(3,0) + " or " + AnsiColor$(12,0) + "shoe.asc" + AnsiColor$(3,0) + " (depending on if ANSI is enabled) will now be"
DoorPrint -1, "displayed if it exists in the current directory."

Pause PausePrompt$

'The Display$ function below returns the first parameter if ANSI is enabled,
'or the second if not. The parameter it returns is the 3rd parameter passed
'to the PrintFile procedure, as you can see.
PrintFile -1, -1, Display$( "shoe.ans", "shoe.asc" )

Pause PausePrompt$


'print variable
'--------------

DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "You can assign an ANSI file to a single PB variable to print."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint -1, AnsiColor$(2,0)
DoorPrint -1, "The file printed a moment ago had to reside on disk to be printed. You can"
DoorPrint -1, "instead make the ANSI internal to your door by assigning the file to a"
DoorPrint -1, "PowerBasic variable (see the IncludeAnsi section of doorroot.doc for"
DoorPrint -1, "details)." + CRLF$

DoorPrint -1, "The file just printed has also been made internal to this door. It will now"
DoorPrint -1, "print the internal ANSI/ASCII."

Pause PausePrompt$

DoorPrint -1, Display$( ShoeSaltANSI$, ShoeSaltASCII$ )

Pause PausePrompt$


'print array
'-----------

DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "You can also print an array to local & remote."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint -1, AnsiColor$(7,0)
DoorPrint -1, "You probably noticed that the top part of the ANSIwas scrolled off the screen"
DoorPrint -1, "in the previous example. That's because it has no way of knowing what line"
DoorPrint -1, "it's on, so can't prompt every 22 lines for the user to press a key. However,"
DoorPrint -1, "there is a way to have internal ANSIs do 'more prompting' - assign the"
DoorPrint -1, "ANSI file to an array (see the IncludeAnsi2 section of doorroot.doc for"
DoorPrint -1, "details), and it'll pause after printing every 22 array elements."

DoorPrint -1, AnsiColor$(3,0)
DoorPrint -1, "The ANSI/ASCII file you've seen twice already has also been assigned to an"
DoorPrint -1, "array. So it's now internal to the door AND can pause every 22 lines. It will"
DoorPrint -1, "now be printed as the array."

Pause PausePrompt$

if Ansi% then
   PrintArray 0, -1, ShoeSaltArrayANSI$()
else
   PrintArray 0, -1, ShoeSaltArrayASCII$()
end if

Pause PausePrompt$


'input
'-----

DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "You can get input from the user using a variety of formats with the " + AnsiColor$(13,0) + "DoorInput$" + AnsiColor$(15,0)
DoorPrint -1, "function."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint -1, AnsiColor$(5,0)
DoorPrint -1, "The DoorInput$ function is extremely flexible. For example, you can prompt the"
DoorPrint -1, "user for a password and hide the input in the traditional way, like this:" + CRLF$

Prompt$ = AnsiColor$(10,0) + "Choose a Password " + AnsiColor$(2,0) + "(15 chrs max)" + AnsiColor$(10,0) + ": " + AnsiColor$(7,0)
a$ = DoorInput$( Prompt$, 15, 1, "", "." )

DoorPrint -1, CRLF$ + AnsiColor$(9,0)
DoorPrint -1, "Your password is " + a$ + CRLF$

DoorPrint -1, "Getting input from a range of possible keystrokes is easy too. Consider this"
DoorPrint -1, "little menu:" + CRLF$

DoorPrint -1, AnsiColor$(8,0) + "                   " + AnsiColor$(0,7) + "  <S>tart Game        <W>rite Message  "
DoorPrint -1, AnsiColor$(8,0) + "                   " + AnsiColor$(0,7) + "  <H>igh Scores       <Q>uit to BBS    "
DoorPrint -1, AnsiColor$(8,0) + "                   " + CRLF$

Prompt$ = AnsiColor$(6,0) + "                                   Selection: " + AnsiColor$(12,0)
a$ = DoorInput$( Prompt$, 1, 4, "SsWwHhQq", "" )

DoorPrint -1, CRLF$ + CRLF$ + a$ + " is the letter you pressed."

Pause PausePrompt$


'word wrapping
'-------------

DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "You might want the user to enter several lines of input, such as when"
DoorPrint -1, "composing a message to another user or entering a short description about"
DoorPrint -1, "oneself in a matchmaking door. Use " + AnsiColor$(14,0) + "DoorInputWrap$" + AnsiColor$(15,0) + " to accomplish this. It's"
DoorPrint -1, "like DoorInput$, but allows multiple lines of input and does word-wrapping."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint -1, AnsiColor$(7,0)
DoorPrint -1, "This example is like entering a message to another player in the door LORD." + CRLF$

DoorPrint -1, AnsiColor$(2,0) + "  Enter message now..Blank line quits!" + CRLF$
a$ = DoorInputWrap$( " >" + AnsiColor$(15,0), 78, AnsiColor$(2,0) + " >" + AnsiColor$(15,0), 200, -1, "" )

DoorPrint -1, CRLF$ + AnsiColor$(11,0)
DoorPrint -1, "If DoorInput$ and DoorInputWrap$ don't suit your needs, you can create your own"
DoorPrint -1, "input routines using " + AnsiColor$(12,0) + "InputBuffer$" + AnsiColor$(11,0) + ", " + AnsiColor$(12,0) + "RemoteBuffer$" + AnsiColor$(11,0) + ", and " + AnsiColor$(12,0) + "LocalBuffer$" + AnsiColor$(11,0) + "."

Pause PausePrompt$


'extra config vars
'-----------------

DoorCLS

DoorPrint 0, AnsiColor$(15,0)
DoorPrint -1, "It's easy to add your own extra sysop-definable settings to your door. The"
DoorPrint -1, "first 7 lines of the config file are mandatory. You can use lines 8 and on for"
DoorPrint -1, "the sysop to specify extra settings."
DoorPrint -1, AnsiColor$(1,0) + repeat$(79,"")

DoorPrint -1, AnsiColor$(6,0)
DoorPrint -1, "In sample.cfg, lines 8 and 9 have been added as examples. Line 8 represents the"
DoorPrint -1, "sysop's name, and line 9 represents the BBS name. It will now retrieve those"
DoorPrint -1, "lines."

Pause PausePrompt$

SysopName$ = ExtraConfig$()
BBSName$   = ExtraConfig$()

DoorPrint -1, CRLF$ + "The sysop's name is " + SysopName$
DoorPrint -1, "The BBS name is " + BBSName$

Pause PausePrompt$


'all done
'--------

DoorCLS

DoorPrint -1, AnsiColor$(11,0)
DoorPrint -1, "This concludes Sample Door. Not the most glamourous of doors (haha), but"
DoorPrint -1, "enough to give you a feel for it. Remember to examine this door's source code"
DoorPrint -1, "and read through doorroot.doc. Good luck on your door!"

Pause CRLF$ + PausePrompt$

ExitDoor 0
