Unit ScrnSave;

(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)
(*                                                                         *)
(*  D32 Library Source Code                     Programmed By James Coyle  *)
(*  ---------------------------------------------------------------------  *)
(*                                                                         *)
(*  This source code is provided as-is.  The author will not be held       *)
(*  responsible for any damage done by the use or misuse of this library.  *)
(*  If you do not agree to these terms, you must remove this library       *)
(*  and any of its files from storage immediately.                         *)
(*                                                                         *)
(*  ---------------------------------------------------------------------  *)
(*                                                                         *)
(*  FILE  : SCRNSAVE.PAS                                                   *)
(*  DESC  : Screen writing and save/restore functions                      *)
(*  BUILD : Revision 2: February 23, 2001                                  *)
(*  NOTES : Some code modifications were done by Maarten Berkers.  Thanks  *)
(*          again Maarten for your help/support.  These functions assume   *)
(*          a terminal size no larger than 80 columns by 25 lines.         *)
(*                                                                         *)
(*  Tested with the following operating systems and compilers:             *)
(*                                                                         *)
(*  DOS     - Turbo Pascal v7.0                                            *)
(*  Windows - Virtual Pascal v2.1                                          *)
(*  OS/2    - Virtual Pascal v2.1                                          *)
(*  Linux   - Free Pascal v1.0                                             *)
(*                                                                         *)
(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)

Interface

Type
  ScrnSavePTR = ^ScrnSaveOBJ;
  ScrnSaveOBJ = Object
  Public
    OutputHandle : Longint;

    Constructor Init;
    Destructor  Done;
    Procedure   Save;
    Procedure   Restore;
    procedure   WriteXY (const X, Y: Byte; Attr: Byte; CH: Byte);
    procedure   GetXY (const X, Y: Byte; var Attr: Byte; var CH: Byte);
  Private
    SavedX : Byte;
    SavedY : Byte;
    SavedA : Byte;
    Buffer : Array[0..3999] of Byte;
  End;

Implementation

Uses
  {$IFDEF WIN32}
    Windows,
  {$ENDIF}

  {$IFDEF OS2}
    Os2Def,
    Os2Base,
  {$ENDIF}
  CRT;

Constructor ScrnSaveOBJ.Init;
Begin
  OutputHandle := -1;

  {$IFDEF VirtualPascal}
    OutputHandle := SysFileStdOut;
  {$ENDIF}

  {$IFDEF FPC}
    OutputHandle := OutHandle;
  {$ENDIF}
End;

Destructor ScrnSaveOBJ.Done;
Begin
End;

Procedure ScrnSaveOBJ.Save;
{$IFNDEF MSDOS}
Var
  P : Word;
  X : Byte;
  Y : Byte;
{$ENDIF}
Begin
  SavedX := WhereX;
  SavedY := WhereY;
  SavedA := TextAttr;

  {$IFDEF MSDOS}
    Move (Mem[$B800:$0000], Buffer, 4000);
  {$ELSE}
    P := 0;
    For Y := 0 to 24 Do
      For X := 0 to 79 Do Begin
        begin
          GetXY(X, Y, Buffer[P], Buffer[P + 1]);
          Inc (P, 2);
        end; { if }
      End;
  {$ENDIF}
End;

Procedure ScrnSaveOBJ.Restore;
{$IFNDEF MSDOS}
Var
  X, Y    : Longint;
  P       : Longint;
{$ENDIF}
Begin
  {$IFDEF MSDOS}
    Move (Buffer, Mem[$B800:$0000], 4000);
  {$ELSE}
    P := 0;
    For Y := 0 to 24 Do
      For X := 0 to 79 Do
        begin
           WriteXY(X, Y, Buffer[P], Buffer[P + 1]);
           Inc (P, 2);
        end; { for }
  {$ENDIF}

  GotoXY (SavedX, SavedY);
  TextAttr := SavedA;
End;

procedure ScrnSaveObj.WriteXY(const X, Y: Byte; Attr: Byte; CH: Byte);
{$IFDEF WIN32}
var Cell    : TCharInfo;
    BufSize : TCoord;                   { Column-row size of source buffer }
    WritePos: TCoord;                      { Upper-left cell to write from }
    DestRect: TSmallRect;
{$ENDIF}

{$IFDEF MSDOS}
var OldX, OldY, OldA: Byte;
{$ENDIF}

{$IFDEF OS2}
var TempStr: String;
{$ENDIF}
begin
  {$IFDEF WIN32}
    BufSize.X := 01;
    BufSize.Y := 01;

    WritePos.X := 0;
    WritePos.Y := 0;

    Cell.Attributes := Attr;
    Cell.UniCodeChar := Ord(CH);

    DestRect.Left := X;
    DestRect.Top := Y;
    DestRect.Right := X;
    DestRect.Bottom := Y;

    WriteConsoleOutput(OutputHandle, @Cell, BufSize, WritePos, DestRect);
  {$ENDIF}

  {$IFDEF OS2}
    VioWrtCharStrAtt(@CH, 1, Y, X, Attr, OutputHandle);
  {$ENDIF}


  {$IFDEF MSDOS}
    OldX := WhereX;
    OldY := WhereY;
    OldA := TextAttr;

    GotoXY(X, Y);
    TextAttr := Attr;
    Write(CH);

    GotoXY(OldX, OldY);
    TextAttr := OldA;
  {$ENDIF}
end; { proc. WriteXY }


procedure ScrnSaveObj.GetXY(const X, Y: Byte; var Attr: Byte; var CH: byte);
{$IFDEF WIN32}
var Reads: DWORD;
    Coord: TCoord;

    Temp: SmallWord;
{$ENDIF}

{$IFDEF OS2}
var ScrnWord,
    ReadSize : SmallWord;
{$ENDIF}
begin
  {$IFDEF WIN32}
    FillChar(Coord, SizeOf(Coord), 0);
    Coord.X := X;
    Coord.Y := Y;

    ReadConsoleOutputCharacter(OutputHandle, @Temp, 1, Coord, Reads);
    Ch := Byte(Temp);

    ReadConsoleOutputAttribute(OutputHandle, @Temp, 1, Coord, Reads);
    Attr := Byte(Temp);
  {$ENDIF}

  {$IFDEF OS2}
    ReadSize := SizeOf(ScrnWord);
    VioReadCellStr(ScrnWord, ReadSize, Y, X, OutputHandle);

    Attr := Hi(ScrnWord) and $7f;
    CH := Lo(ScrnWord);
  {$ENDIF}

  {$IFDEF MSDOS}
    { dummy }
  {$ENDIF}
end; { proc. GetXY }

End.
