{*******************************************************}
{                                                       }
{       Turbo Pascal Runtime Library                    }
{       CRT Interface Unit                              }
{                                                       }
{       Copyright (C) 1988,92 Borland International     }
{       Altered and Corrected (C) 1998 SHARKware        }
{                                                       }
{*******************************************************}
{$I-,S-}
UNIT Crt_;
INTERFACE
CONST
{ CRT modes }
  BW40          = 0;            { 40x25 B/W on Color Adapter }
  CO40          = 1;            { 40x25 Color on Color Adapter }
  BW80          = 2;            { 80x25 B/W on Color Adapter }
  CO80          = 3;            { 80x25 Color on Color Adapter }
  Mono          = 7;            { 80x25 on Monochrome Adapter }
  Font8x8       = 256;          { Add-in for ROM font }

{ Mode constants for 3.0 compatibility }
  C40           = CO40;
  C80           = CO80;

{ Foreground and background color constants }
  Black         = 0;
  Blue          = 1;
  Green         = 2;
  Cyan          = 3;
  Red           = 4;
  Magenta       = 5;
  Brown         = 6;
  LightGray     = 7;

{ Foreground color constants }
  DarkGray      = 8;
  LightBlue     = 9;
  LightGreen    = 10;
  LightCyan     = 11;
  LightRed      = 12;
  LightMagenta  = 13;
  Yellow        = 14;
  White         = 15;

{ Add-in for blinking }
  Blink         = 128;

VAR
{ Interface variables }
  CheckBreak: Boolean;    { Enable Ctrl-Break }
  CheckEOF: Boolean;      { Enable Ctrl-Z }
  DirectVideo: Boolean;   { Enable direct video addressing }
  CheckSnow: Boolean;     { Enable snow filtering }
  LastMode: Word;         { Current text mode }
  TextAttr: Byte;         { Current text attribute }
  WindMin: Word;          { Window upper left coordinates }
  WindMax: Word;          { Window lower right coordinates }

{ Interface procedures }
FUNCTION  KeyPressed: Boolean;
FUNCTION  ReadKey: Char;
FUNCTION  WhereX: Byte;
FUNCTION  WhereY: Byte;
PROCEDURE AssignCrt(VAR F: Text);
PROCEDURE ClrEol;
PROCEDURE ClrScr;
PROCEDURE Delay(MS: Word);
PROCEDURE DelLine;
PROCEDURE GotoXY(X,Y: Byte);
PROCEDURE HighVideo;
PROCEDURE InsLine;
PROCEDURE LowVideo;
PROCEDURE NormVideo;
PROCEDURE NoSound;
PROCEDURE Sound(Hz: Word);
PROCEDURE TextBackground(Color: Byte);
PROCEDURE TextColor(Color: Byte);
PROCEDURE TextMode(Mode: Integer);
PROCEDURE Window(X1,Y1,X2,Y2: Byte);

IMPLEMENTATION

{$IFDEF DPMI}
{$L CRT_.OBP}
{$ELSE}
{$L CRT_.OBJ}
{$ENDIF}

FUNCTION  KeyPressed; EXTERNAL;
FUNCTION  ReadKey; EXTERNAL;
FUNCTION  WhereX; EXTERNAL;
FUNCTION  WhereY; EXTERNAL;
PROCEDURE AssignCrt; EXTERNAL;
PROCEDURE ClrEol; EXTERNAL;
PROCEDURE ClrScr; EXTERNAL;
PROCEDURE Delay; EXTERNAL;
PROCEDURE DelLine; EXTERNAL;
PROCEDURE GotoXY; EXTERNAL;
PROCEDURE HighVideo; EXTERNAL;
PROCEDURE Initialize; EXTERNAL;
PROCEDURE InsLine; EXTERNAL;
PROCEDURE LowVideo; EXTERNAL;
PROCEDURE NormVideo; EXTERNAL;
PROCEDURE NoSound; EXTERNAL;
PROCEDURE Sound; EXTERNAL;
PROCEDURE TextBackground; EXTERNAL;
PROCEDURE TextColor; EXTERNAL;
PROCEDURE TextMode; EXTERNAL;
PROCEDURE Window; EXTERNAL;

PROCEDURE Break;
BEGIN
  Halt(255);
END;

BEGIN
  Initialize;
  AssignCrt(Input); Reset(Input);
  AssignCrt(Output); Rewrite(Output);
END.
