{Types for DOS unit}

const
{ Flags bit masks }

  FCarry     = $0001;
  FParity    = $0004;
  FAuxiliary = $0010;
  FZero      = $0040;
  FSign      = $0080;
  FOverflow  = $0800;

{ File mode magic numbers }

  fmClosed = $D7B0;
  fmInput  = $D7B1;
  fmOutput = $D7B2;
  fmInOut  = $D7B3;

{ File attribute constants }

  ReadOnly  = $01;
  Hidden    = $02;
  SysFile   = $04;
  VolumeID  = $08;
  Directory = $10;
  Archive   = $20;
  AnyFile   = $3F;

type

{ String types }

  ComStr  = string;          { Command line string }
  PathStr = string;          { Full file path string }
  DirStr  = string;          { Drive and directory string }
  NameStr = string;          { File name string }
  ExtStr  = string;          { File extension string }

{ Typed-file and untyped-file record }

  FileRec = record
          Handle: Integer;
          Mode: Integer;
          RecSize: Cardinal;
          Private: array[1..28] of Byte;
          UserData: array[1..32] of Byte;
          Name: array[0..259] of Char;
  end;

{ Textfile record }
  PTextBuf = ^TextBuf;
  TextBuf = array[0..127] of Char;
  TextRec = record
          Handle: Integer;
          Mode: Integer;
          BufSize: Cardinal;
          BufPos: Cardinal;
          BufEnd: Cardinal;
          BufPtr: PChar;
          OpenFunc: Pointer;
          InOutFunc: Pointer;
          FlushFunc: Pointer;
          CloseFunc: Pointer;
          UserData: array[1..32] of Byte;
          Name: array[0..259] of Char;
          Buffer: TextBuf;
  end;

{ Search record used by FindFirst and FindNext }

     SearchRec = record
		Time: Integer;
		Size: Integer;
		Attr: Integer;
		Name: AnsiString;
		ExcludeAttr: Integer;
		FindHandle: THandle;
		FindData: TWin32FindData;
     end;


{ Date and time record used by PackTime and UnpackTime }

  DateTime = packed record
               Year,Month,Day,Hour,Min,Sec: Word;
             end;
