program SetDate;
(*
**
** SETDATE -- Set users' date to user defined format
**
**
** Version : 0.01
** Created : 04-Jan-2000
** Last update: 04-Jan-2000
**
**
*)
uses Crt, Dos;

type
  SmallWord      = Word;
  SmallInt       = Integer;
  Time           = String[5];
  Date           = String[8];
  MSGTOIDXrecord = String[35];
  FlagType       = array[1..4] of Byte;
  ByteArray32    = Array[1..32] of Byte;

  COMBINEDrecord = array[1..200] of SmallWord;

  USERSrecord    = record
                     Name           : MSGTOIDXrecord;
                     Location       : String[25];
                     Organisation,
                     Address1,
                     Address2,
                     Address3       : String[50];
                     Handle         : String[35];
                     Comment        : String[80];
                     PasswordCRC    : LongInt;
                     DataPhone,
                     VoicePhone     : String[15];
                     LastTime       : Time;
                     LastDate       : Date;

                     Attribute,

                      { Bit 0 : Deleted
                            1 : Clear screen
                            2 : More prompt
                            3 : ANSI
                            4 : No-kill
                            5 : Xfer priority
                            6 : Full screen msg editor
                            7 : Quiet mode }

                     Attribute2     : Byte;

                      { Bit 0 : Hot-keys
                            1 : AVT/0
                            2 : Full screen message viewer
                            3 : Hidden from userlist
                            4 : Page priority
                            5 : No echomail in mailbox scan
                            6 : Guest account
                            7 : Post bill enabled }

                     Flags          : FlagType;
                     Credit,
                     Pending        : LongInt;
                     MsgsPosted,
                     Security       : SmallWord;
                     LastRead,
                     NoCalls,
                     Uploads,
                     Downloads,
                     UploadsK,
                     DownloadsK,
                     TodayK         : LongInt;
                     Elapsed        : SmallInt;
                     ScreenLength   : SmallWord;
                     LastPwdChange  : Byte;
                     Group          : SmallWord;
                     CombinedInfo   : COMBINEDrecord;
                     FirstDate,
                     BirthDate,
                     SubDate        : Date;
                     ScreenWidth,
                     Language,
                     DateFormat     : Byte;
                     {  No.      Sort of format to use : }
                     {  01       DD-MM-YY        }
                     {  02       MM-DD-YY        }
                     {  03       YY-MM-DD        }
                     {  04       DD-Mmm-YY       }
                     {  05       DD-MM-YYYY      }
                     {  06       MM-DD-YYYY      }
                     {  07       YYYY-MM-DD      }
                     {  08       DD-Mmm-YYYY     }

                     ForwardTo      : String[35];
                     MsgArea,
                     FileArea       : SmallWord;
                     DefaultProtocol: Char;
                     FileGroup      : SmallWord;
                     LastDOBCheck   : Byte;
                     Sex            : Byte;
                     XIrecord       : LongInt;
                     MsgGroup       : SmallWord;

                     Attribute3     : Byte;

                      { Bit 0 : Mailbox check: scan selected areas only }

                     PassWord       : String[15];

                     FreeSpace      : Array[1..31] of Byte;
                   end;

function AskStr(Msg: String): Boolean;
var CH: Char;
begin
  Write(Msg, ' (y/N)?');
  
  REPEAT
    CH := UpCase(ReadKey);

    if CH = #13 then CH := 'N';
  UNTIL CH in ['Y', 'N'];

  AskStr := (CH = 'Y');
  WriteLn(#32, CH);
end; { func. AskStr }

var User_F  : File;
    UserInf : UsersRecord;
    CH      : Char;
    DateFmt : Byte;
    Code    : Integer;
begin
  WriteLn('SETDATE - (c)2000 by Maarten Bekers');
  WriteLn;

  {-- Make sure our user has a backup of his USERS.BBS ------------------------}
  if NOT AskStr('Do you have a backup of your USERS.BBS?') then
    begin
      Write('  Aborted!', ^g);
      Writeln;
      Halt(255);
    end; { if }

  {-- Ask for the desired dateformat ------------------------------------------}
  WriteLn('1).  DD-MM-YY');
  WriteLn('2).  MM-DD-YY');
  WriteLn('3).  YY-MM-DD');
  WriteLn('4).  DD-Mmm-YY');
  WriteLn('5).  DD-MM-YYYY');
  WriteLn('6).  MM-DD-YYYY');
  WriteLn('7).  YYYY-MM-DD');
  WriteLn('8).  DD-Mmm-YYYY');
  Write  ('Choose: ');

  REPEAT
    CH := ReadKey;
  UNTIL CH in [#27, '1'..'8'];

  if CH=#27 then
    begin
      Write('  Aborted!', ^g);
      Writeln;
      Halt(255);
    end
       else begin
             WriteLn(CH);
             WriteLn;
             Val(CH, DateFmt, Code);
           end; { else }

  {-- Let's perform our operation ---------------------------------------------}
  Assign(User_F, 'users.bbs');
  {$i-} Reset(User_F, 1); {$i+}
  if IoResult > 0 then
    begin
       WriteLn('Unable to open "users.bbs" - please run this program');
       WriteLn('in the messagebase directory!');
       Writeln;
       Halt(255);
    end; { if }

  While NOT Eof(User_F) do
    begin
      {$i-} BlockRead(User_F, UserInf, SizeOf(UserInf)); {$i+}
      if IoResult > 0 then BREAK;

      UserInf.DateFormat := DateFmt;

      {$i-}
        Seek(User_F, FilePos(User_F) - SizeOf(UserInf));
        BlockWrite(User_F, UserInf, SizeOf(UserInf));
      {$i+}
      if IoResult > 0 then ;
    end; { while }

  {$i-} Close(User_F); {$i+}
  if IoResult > 0 then ;

  {-- We''re all through, done. -----------------------------------------------}
  WriteLn('Done.');
  WriteLn;
end. { program SETDATE }
