{$A+,B-,D+,E+,F-,I-,L+,N-,O-,R-,S-,V-}
{$M 8192,0,0}
Program FDFORMAT;

uses dos;

{Copyright (c) 1988, Christoph H. Hochsttter}
{Written in Turbo-Pascal 5.0}
{Last Updated: 26-Mar-1989}

{$DEFINE English} {Change this to German or English}
{$IFDEF German}

const text01 = 'Fehler ';
const text02 = 'A)bbrechen, W)iederholen, I)gnorieren? ';
const t3     = 'W';
const text04 = 'Kein gltiges Laufwerk.';
const text05 = 'SUBST/ASSIGN/Netzwerk-Laufwerk.';
const text06 = 'Kein Floppy-Laufwerk.';
const text07 = 'Vllig unbekannte Laufwerksart';
const text08 = 'Ich formatiere Laufwerk ';
const text09 = ' Seite(n), ';
const text10 = ' Spuren, ';
const text11 = ' Sektoren/Spur, ';
const text12 = ' Basisverzeichniseintrge, ';
const text13 = ' Sektor(en)/Cluster, Sektoren-Versatz: ';
const text14 = 'Kopf: ';
const text15 = ', Zylinder: ';
const text16 = ', Sektor: ';
const text17 = 'Formatierfehler im Systembereich.  Programm abgebrochen.';
const text18 = 'Mehr als ';
const text19 = ' Sektoren nicht lesbar.  Programm abgebrochen.';
const text20 = ' als schlecht markiert';
const text21 = 'Format-Identifizierung:          ';
const text22 = 'Gesamtsektoren auf der Diskette: ';
const text23 = 'Sektoren pro Spur:               ';
const text24 = 'Schreib-/Lesekpfe:              ';
const text25 = 'Bytes pro Sektor:                ';
const text26 = 'Versteckte Sektoren:             ';
const text27 = 'Boot-Sektoren:                   ';
const text28 = 'Anzahl der FATs:                 ';
const text29 = 'Sektoren pro FAT:                ';
const text30 = 'Cluster auf Diskette:            ';
const text31 = ' Bytes Gesamtkapazitt';
const text32 = ' Bytes in schlechten Sektoren';
const text33 = ' Bytes auf der Diskette verfgbar';
const text34 = 'Dieses Laufwerk kann nicht formatiert werden.';
const text35 = 'Laufwerk ist physisch ';
const text36 = 'BIOS Umschaltung 40/80 Spuren: ';
const text37 = 'nach XT-Standard';
const text38 = 'nach Epson QX-16 Standard';
const text39 = 'nach AT-Standard';
const text40 = 'wird nicht untersttzt';
const text41 = 'Syntax Error beim Aufruf.';
const text42 = 'Format ist: FDFORMAT <drive>: [Optionen]';
const text43 = '  Beispiel: FDFORMAT A: T41 H2 S10 C1 D112';
const text44 = 'Parameter Bedeutung                              Voreinstellung';
const text45 = 'drive:    Laufwerk das formatiert werden soll    ----';
const text46 = 'Tnn       Anzahl der Spuren je Seite             40/80 je nach Laufwerk';
const text47 = 'Hnn       Anzahl der Seiten                      2';
const text48 = 'Snn       Anzahl der Sektoren je Spur            9/15/18 je nach Laufwerk';
const text49 = 'Cn        Anzahl der Sektoren je Cluster         1 bei HD, 2 bei DD';
const text50 = 'Dnnn      Anzahl der Basisverzeichniseintrge    224 bei HD, 112 bei DD';
const text51 = 'Inn       Interleave-Faktor                      1';
const text52 = 'P         Spezielle Einstellung fr PS/2';
const text53 = 'V         Formatierung nicht verifizieren';
const text69 = 'Bnnn      Diskettentypbyte festlegen             je nach Format');
const text70 = 'Gnnn      Gap-Lnge festlegen');                 je nach Format');
const text71 = 'Fnn       Sektoren-Versatz festlegen             0';
const text54 = 'Dieses Programm bentigt mindestens DOS 3.20.';
const text55 = 'FDFORMAT -- Formatieren von Disketten mit erhhter Kapazitt';
const text56 = 'Copyright (c) 26.03.1989, Christoph H. Hochsttter, Ver 1.20';
const text57 = 'Sie knnen nur 1 oder 2 Seiten nehmen.';
const text58 = 'Sie sollten schon mindestens eine Spur formatieren.';
const text59 = 'Interleave mu von 1-';
const text60 = ' sein.';
const text61 = 'WARNUNG! DOS verwaltet bei Disketten nur 1 oder 2 Sektoren/Cluster';
const text62 = 'WARNUNG! Zu viele Spuren. Das kann Ihr Laufwerk beschdigen';
const text63 = 'WARNUNG! DOS verwaltet bei Disketten maximal 240 Basisverzeichniseintrge';
const text64 = 'Neue Diskette in Laufwerk ';
const text65 = ': einlegen';
const text66 = 'Anschlieend ENTER drcken (ESC=Abbruch)';
const text67 = ', Sektoren-Versatz: ';
const text68 = ', Gap-Lnge: ';

{$ENDIF}
{$IFDEF English}

const text01 = 'Error ';
const text02 = 'A)bort, R)etry, I)gnore? ';
const t3     = 'R';
const text04 = 'No valid drive.';
const text05 = 'SUBST/ASSIGN/network drive.';
const text06 = 'Not a floppy drive.';
const text07 = 'Unknown drive type.';
const text08 = 'Formatting drive ';
const text09 = ' Head(s), ';
const text10 = ' Tracks, ';
const text11 = ' Sectors/track, ';
const text12 = ' Root-directory entries, ';
const text13 = ' Sector(s)/cluster, Sector shift: ';
const text14 = 'Head: ';
const text15 = ', Cylinder: ';
const text16 = ', Sector: ';
const text17 = 'Format error in system area:  Program aborted.';
const text18 = 'More than ';
const text19 = ' sectors unreadable.  Program aborted.';
const text20 = ' marked as bad';
const text21 = 'OEM entry:              ';
const text22 = 'Total sectors on disk:  ';
const text23 = 'Sectors per track:      ';
const text24 = 'Heads:                  ';
const text25 = 'Bytes per sector:       ';
const text26 = 'Hidden sectors:         ';
const text27 = 'Boot sectors:           ';
const text28 = 'Number of FATs:         ';
const text29 = 'Sectors per FAT:        ';
const text30 = 'Total clusters on disk: ';
const text31 = ' total bytes on disk';
const text32 = ' bytes in bad sectors';
const text33 = ' bytes available';
const text34 = 'This drive cannot be formatted.';
const text35 = 'Drive is physical ';
const text36 = 'BIOS double-step support: ';
const text37 = 'XT-like';
const text38 = 'Epson QX-16 like';
const text39 = 'AT-like';
const text40 = 'Not available or unknown';
const text41 = 'Syntax error.';
const text42 = '  Usage:  FDFORMAT <drive>: [options]';
const text43 = 'Example:  FDFORMAT A: T41 H2 S10 C1 D112';
const text44 = 'Option   Meaning                                 Default';
const text45 = 'drive:   drive to be formatted                   none';
const text46 = 'Tnn      number of Tracks                        40/80 (depends on drive)';
const text47 = 'Hnn      number of Heads                         2';
const text48 = 'Snn      number of Sectors per track             9/15/18 (depends on drive)';
const text49 = 'Cn       number of sectors per Cluster           1 for HD, 2 for DD';
const text50 = 'Dnnn     number of root-Directory entries        224 for HD, 112 for DD';
const text51 = 'Inn      use a specified sector Interleave       1';
const text52 = 'P        for use on PS/2 computers';
const text53 = 'V        skip Verify after format';
const text69 = 'Bnnn     use a specified BIOS descriptor Byte    (depends on format)';
const text70 = 'Gnnn     use a specified Gap length              (depends on format)';
const text71 = 'Fnn      use a specified sector shiFt            0';
const text54 = 'This program requires DOS 3.2 or higher.';
const text55 = 'FDFORMAT - Disk Formatter for High-Capacity Disks - Ver 1.20';
const text56 = 'Copyright (c) 26-Mar-1989, Christoph H. Hochsttter, Germany';
const text57 = 'Heads must be 1 or 2.';
const text58 = 'At least one track should be formatted.';
const text59 = 'Interleave must be from 1 to ';
const text60 = '.';
const text61 = 'WARNING!  DOS supports only 1 or 2 sectors per cluster.';
const text62 = 'WARNING!  That many tracks could cause damage to your drive.';
const text63 = 'WARNING!  DOS supports a maximum of 240 root-directory entries.';
const text64 = 'Insert diskette in drive ';
const text65 = ':';
const text66 = 'Press ENTER when ready (ESC=quit)';
const text67 = 'Sector shift: ';
const text68 = ', Gap length: ';

{$ENDIF}

type tabletyp = array[1..25] of record
                  t,h,s,f:byte;
		end;

     paratyp =  array[0..10] of byte;
     boottyp =  array[30..511] of byte;

     btttyp  =  array[1..20] of record
                  head:  byte;
                  track: byte;
                end;

     bpbtyp  =  record
		  jmp: array[1..3] of byte;  {Die ersten drei Bytes fr JUMP}
		  oem: array[1..8] of char;  {OEM-Eintrag}
		  bps: word;                 {Bytes pro Sektor}
		  spc: byte;                 {Sektoren pro Cluster}
		  res: word;                 {BOOT-Sektoren}
		  fat: byte;                 {Anzahl der FAT's}
		  rde: word;                 {Basisverzeichniseintrge}
		  sec: word;                 {Gesamtsektoren der Diskette}
		  mds: byte;                 {Media-Deskriptor}
		  spf: word;                 {Sektoren pro FAT}
		  spt: word;                 {Sektoren pro Spur}
		  hds: word;                 {Seiten}
		  shh: word;                 {Versteckte Sektoren}
		  boot_code: boottyp;        {Puffer fr BOOT-Code}
		end;

var regs:       registers;                {Prozessor-Register}
    track:      byte;                     {Aktuelle Spur}
    head:       byte;                     {Aktuelle Seite}
    table:      tabletyp;                 {Formatierungs-Tabelle}
    table2:     array[1..25] of byte;     {Interleave-Tabelle}
    x:          word;                     {Hilfsvariable}
    buffer:     array[0..18432] of byte;  {Puffer fr eingelesene Sektoren}
    old1E:      pointer;                  {Alter Zeiger auf die Parameterliste}
    new1E:      ^paratyp;                 {Neuer Zeiger auf die Parameterliste}
    old13:      pointer;                  {Alter Zeiger auf Interrupt 13}
    old58:      pointer;                  {Alter Zeiger auf Hilfsinterrupt 58}
    bpb:	bpbtyp;                   {Boot-Sektor mit BIOS-Parameterblock}
    chx:        Char;                     {Hilfsvariable}
    lw:         Byte;                     {Ausgewhltes Laufwerk}
    hds,sec:    word;                     {Anzahl der Seiten, Sektoren}
    trk:        word;                     {Anzahl der Spuren}
    hd,lwhd:    Boolean;                  {High-Density Flags}
    lwtrk:      byte;                     {maximale Spuren des Laufwerks}
    lwsec:      byte;                     {maximale Sektoren des Laufwerks}
    para:	String[5];                {Parameter von der Kommandozeile}
    rde:	byte;                     {Basisverzeichniseintrge}
    spc:	byte;                     {Sektoren pro Cluster}
    i,n:	byte;                     {Hilfsvariablen}
    j:		integer;                  {Hilfsvariable}
    again:      boolean;                  {Flag, ob INT 13 nochmal kommen mu}
    bttCount:   word;                     {Anzahl der schlechten Spuren}
    btt:        btttyp;                   {Tabelle der schlechten Spuren}
    Offset:     word;                     {Relative Position im FAT}
    Mask:       word;                     {Maske fr schlechten Cluster}
    bytes:	LongInt;                  {Bytes Gesamtkapazitt}
    bad:        Longint;                  {Bytes in schlechten Sektoren}
    pc80:	Byte;                     {Maske, fr 40/80 Spur nach XT-BIOS}
    at80:       Boolean;                  {TRUE, wenn 80/40 Spur nach AT-BIOS}
    ps2:        Boolean;                  {TRUE, wenn PS2}
    noverify:   Boolean;                  {TRUE, wenn Verify nicht verlangt wurde}
    DiskId:     Byte;                     {Disketten-Format-Beschreibung fr AT-BIOS}
    il:         Byte;                     {Interleave-Faktor}
    gpl:        Byte;                     {GAP-Lnge}
    shift:      Byte;                     {Sektor-Shifting}
    ModelByte:  Byte absolute $F000:$FFFE {XT/AT/386};
    ForceType:  Byte;                     {Gezwungener Diskid}

const para17:  paratyp =($df,$02,$25,$02,17,$1b,$ff,$23,$00,$0f,$08);
      para18a: paratyp =($df,$02,$25,$02,18,$1b,$ff,$02,$00,$0f,$08);
      para18:  paratyp =($df,$02,$25,$02,18,$1b,$ff,$6c,$00,$0f,$08);
      para10:  paratyp =($df,$02,$25,$02,10,$2a,$ff,$2e,$00,$0f,$08);  {GPL 26-36}
      para11:  paratyp =($df,$02,$25,$02,11,$2a,$ff,$02,$00,$0f,$08);
      para15:  paratyp =($df,$02,$25,$02,15,$1b,$ff,$54,$00,$0f,$08);
      para09:  paratyp =($df,$02,$25,$02,09,$2a,$ff,$50,$00,$0f,$08);
      para08:  paratyp =($df,$02,$25,$02,08,$2a,$ff,$58,$00,$0f,$08);
      para20:  paratyp =($df,$02,$25,$02,20,$1b,$ff,$25,$00,$0f,$08);  {GPL 17-33}
      para21:  paratyp =($df,$02,$25,$02,21,$1b,$ff,$0c,$00,$0f,$08);
      para22:  paratyp =($df,$02,$25,$02,22,$1b,$ff,$01,$00,$0f,$08);

      GetPhys: Array[0..14] of Byte =(

            $1E,               {  PUSH DS             }
	    $B8,$40,$00,       {  MOV  AX,40H         }
	    $8E,$D8,           {  MOV  DS,AX          }
            $88,$16,$41,$00,   {  MOV  [41H],DL       }
            $1F,               {  POP  DS             }
            $B8,$01,$01,       {  MOV  AX,101H        }
            $CF);              {  IRET                }

      Help58: Array[0..3] of Byte =(

            $CD,$25,           {  INT  25H            }
            $59,               {  POP  CX             }
            $CF);              {  IRET                }

{$IFDEF German}

      boot: boottyp=(
0,0,0,0,0,0,0,0,250,184,48,
0,142,208,188,252,0,251,14,31,187,7,0,190,92,124,144,138,4,70,60,
0,116,8,180,14,86,205,16,94,235,241,180,1,205,22,116,6,180,0,205,
22,235,244,180,0,205,22,51,210,205,25,13,10,68,105,101,115,101,32,68,
105,115,107,101,116,116,101,32,119,117,114,100,101,32,109,105,116,32,70,68,
70,79,82,77,65,84,32,102,111,114,109,97,116,105,101,114,116,46,32,83,
105,101,32,105,115,116,32,110,105,99,104,116,32,66,79,79,84,45,102,132,
104,105,103,46,13,10,77,105,116,32,100,101,109,32,68,79,83,45,66,101,
102,101,104,108,32,83,89,83,32,107,97,110,110,32,115,105,101,32,66,79,
79,84,45,102,132,104,105,103,32,103,101,109,97,99,104,116,32,119,101,114,
100,101,110,44,13,10,119,101,110,110,32,83,105,101,32,111,104,110,101,32,
70,68,82,69,65,68,32,103,101,108,101,115,101,110,32,119,101,114,100,101,
110,32,107,97,110,110,46,13,10,10,84,97,117,115,99,104,101,110,32,83,
105,101,32,100,105,101,32,68,105,115,107,101,116,116,101,32,106,101,116,122,
116,32,97,117,115,32,111,100,101,114,32,148,102,102,110,101,110,32,83,105,
101,32,100,105,101,32,75,108,97,112,112,101,44,13,10,119,101,110,110,32,
83,105,101,32,118,111,110,32,100,101,114,32,70,101,115,116,112,108,97,116,
116,101,32,98,111,111,116,101,110,32,109,148,99,104,116,101,110,46,13,10,
10,68,114,129,99,107,101,110,32,83,105,101,32,101,105,110,101,32,84,97,
115,116,101,13,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,85,170);

{$ENDIF}
{$IFDEF English}

      boot: boottyp=(
$00,$00,
$00,$00,$00,$00,$00,$00,$FA,$B8,$30,$00,$8E,$D0,$BC,$FC,$00,$FB,
$0E,$1F,$BB,$07,$00,$BE,$5C,$7C,$90,$8A,$04,$46,$3C,$00,$74,$08,
$B4,$0E,$56,$CD,$10,$5E,$EB,$F1,$B4,$01,$CD,$16,$74,$06,$B4,$00,
$CD,$16,$EB,$F4,$B4,$00,$CD,$16,$33,$D2,$CD,$19,$0D,$0A,$54,$68,
$69,$73,$20,$64,$69,$73,$6B,$65,$74,$74,$65,$20,$77,$61,$73,$20,
$66,$6F,$72,$6D,$61,$74,$74,$65,$64,$20,$77,$69,$74,$68,$20,$46,
$44,$46,$4F,$52,$4D,$41,$54,$2E,$20,$49,$74,$20,$69,$73,$20,$6E,
$6F,$74,$20,$62,$6F,$6F,$74,$61,$62,$6C,$65,$2E,$0D,$0A,$54,$6F,
$20,$6D,$61,$6B,$65,$20,$69,$74,$20,$62,$6F,$6F,$74,$61,$62,$6C,
$65,$20,$75,$73,$65,$20,$74,$68,$65,$20,$44,$4F,$53,$2D,$43,$6F,
$6D,$6D,$61,$6E,$64,$3A,$20,$53,$59,$53,$2E,$0D,$0A,$54,$68,$69,
$73,$20,$77,$6F,$72,$6B,$73,$20,$6F,$6E,$6C,$79,$2C,$20,$69,$66,
$20,$79,$6F,$75,$20,$63,$61,$6E,$20,$72,$65,$61,$64,$20,$74,$68,
$69,$73,$20,$44,$69,$73,$6B,$65,$74,$74,$65,$20,$77,$69,$74,$68,
$6F,$75,$74,$20,$46,$44,$52,$45,$41,$44,$2E,$0D,$0A,$0A,$50,$72,
$65,$73,$73,$20,$61,$20,$6B,$65,$79,$20,$74,$6F,$20,$72,$65,$62,
$6F,$6F,$74,$2E,$0D,$0A,$0A,$0A,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$55,$AA);

{$ENDIF}

Function ReadKey:Char;
Var r:Registers;
begin
  with r do begin
    ah:=7;
    intr($21,r);
    if al in [3,27] then begin writeln; halt end;
    ReadKey:=chr(al);
  end;
end;

Procedure int13;
var axs: word;
    chs: byte;
    chx: char;
    er:  Boolean;
begin
  again:=false;
  with regs do begin
    axs:=ax;
    repeat
      ax:=axs;
      if ah=5 then SetIntVec($1E,new1E);
      if trk>43 then dl:=dl or pc80;
      mem[$40:$90+dl]:=DiskId;
      intr($13,regs);
      SetIntVec($1E,Old1E);
      er:=ah>1;
    until ah<>6;
    if er then begin
      writeln;
      writeln(text01,regs.ah,': T',ch,' H',dh,' S',cl,'-',
              cl+lo(axs)-1,' L',dl,' C',hi(axs));
      writeln(text02);
      repeat
	chx:=Upcase(ReadKey);
        case chx of
	  'A': halt;
	  'I': er:=false;
          t3 : begin er:=false; again:=true; end;
        end;
      until chx in ['A','I',t3];
    end;
  ax:=axs;
  end;
end;

Procedure GetPhysical(Var lw:Byte);
begin
  with regs do begin
    GetIntVec($58,old58);
    GetIntVec($13,old13);
    SetIntVec($58,@help58);
    SetIntVec($13,@GetPhys);
    al:=lw; cx:=1; dx:=0;
    ds:=seg(buffer); bx:=ofs(buffer);
    intr($58,regs);
    SetIntVec($58,old58);
    SetIntVec($13,old13);
    lw:=mem[$40:$41];
  end;
end;

procedure DriveTyp(Var lw:Byte;Var hd:boolean;Var trk,sec:byte);
begin
  with regs do begin
    ax:=$4409; bl:=lw+1; bh:=0;
    intr($21,regs);
    if (FCarry and Flags) <> 0 then begin
      writeln(text04);
      trk:=0;
      exit;
    end;
    if (dx and $9200)<>0 then begin
      writeln(text05);
      trk:=0;
      exit;
    end;
    ax:=$440f; bl:=lw+1; bh:=0;
    intr($21,regs);
    if (FCarry and Flags)<>0 then begin
      writeln(text04);
      trk:=0;
      exit;
    end;
    ax:=$440d; cx:=$860; bl:=lw+1;
    bh:=0; dx:=ofs(buffer); ds:=seg(buffer);
    intr($21,regs);
    case buffer[1] of
      0: begin trk:=39; sec:= 9; hd:=false; end;
      1: begin trk:=79; sec:=15; hd:=true ; end;
      2: begin trk:=79; sec:= 9; hd:=false; end;
      7: begin trk:=79; sec:=18; hd:=true ; end;
    else
      begin
        writeln(text06);
        trk:=0;
        exit;
      end
    end;
    GetPhysical(lw);
    lw:=lw and $9f;
    if not(lw in [0..3]) then begin
      writeln(text07);
      trk:=0;
      exit;
    end;
    ModelByte:=mem[$f000:$fffe];
    at80:=(ModelByte=$f8) or (ModelByte=$fc); pc80:=0;
    if not(at80) then begin
      es:=seg(buffer); bx:=ofs(buffer);
      ax:=$201; cx:=0;
      dh:=0; dl:=lw+$20;
      intr($13,regs);
      if ah<>1 then
        pc80:=$20
      else begin
        dl:=$40+lw; ax:=$201;
        intr($13,regs);
        if ah<>1 then pc80:=$40;
      end;
    end;
  end;
end;

Procedure ATSetDrive(lw:Byte; trk,sec,Disk,SetUp:Byte);
begin
  with regs do begin
    dh:=lw; ah:=$18; ch:=trk; cl:=sec;
    intr($13,regs);
    if ah>1 then begin
      ah:=$17; al:=SetUp; dl:=lw;
      intr($13,regs);
    end;
    DiskId:=Disk;
    if ForceType=0 then
      mem[$40:$90+lw]:=Disk
    else
      mem[$40:$90+lw]:=ForceType;
  end;
end;

procedure SectorAbsolute(sector:Word;Var hds,trk,sec:Byte);
var h:word;
begin
  sec:=(sector mod bpb.spt)+1;
  h:=sector div bpb.spt;
  trk:=h div bpb.hds;
  hds:=h mod bpb.hds;
end;

Function SectorLogical(hds,trk,sec:Byte):Word;
begin
  SectorLogical:=trk*bpb.hds*bpb.spt+hds*bpb.spt+sec-1;
end;

Function Cluster(Sector: Word):Word;
Var h: byte;
begin
  Cluster:=((Sector-(bpb.rde shr 4)
            -(bpb.spf shl 1)-1)
           div Word(bpb.spc))+2;
end;

Procedure ClusterOffset(Cluster:Word; Var Offset,Mask:Word);
begin
  Offset:=Cluster*3 shr 1;
  if Cluster and 1 = 0 then
    Mask:=$ff7
  else
    Mask:=$ff70;
end;

Procedure format;
Var i:Byte;
begin
  if rde and 15 <> 0 then inc(rde,16);
  rde:=rde shr 4;
  if (spc=2) and (rde and 1 = 0) then inc(rde);
  bpb.rde:=rde shl 4;
  case sec of
    0..8:   new1E:=@para08;
    9:      new1E:=@para09;
    10:     new1E:=@para10;
    11:     new1E:=@para11;
    12..15: new1E:=@para15;
    17:     new1E:=@para17;
    18:     if lwsec>17 then
              new1E:=@para18
            else
              new1E:=@para18a;
    19..20: new1E:=@para20;
    21:     new1E:=@para21;
    22..255:new1E:=@para22;
  end;
  if gpl<>0 then
    new1E^[7]:=gpl
  else
    gpl:=new1E^[7];
  writeln;
  write(text08,chr(lw+$41),': ');
  if hd then writeln('High-Density') else writeln('Double-Density');
  writeln(hds,text09,trk,text10,sec,text11,'Interleave: ',il,text68,gpl);
  writeln(bpb.rde,text12,spc,text13,shift);
  writeln;
  bttCount:=0;
  with regs do begin
    for i:=1 to 25 do begin
      table[i].f:=2;
      table2[i]:=0;
    end;
    i:=1;
    n:=1;
    repeat
      repeat
        while table2[n]<>0 do inc(n);
        if n>sec then n:=1;
      until table2[n]=0;
      table2[n]:=i;
      n:=n+il;
      inc(i);
    until i>sec;
    ax:=0;
    bx:=0;
    dl:=lw;
    if at80 then begin
      if (trk>43) and (sec>11) then ATSetDrive(lw,79,lwsec,$14,5);
      if not(ps2) and (trk>43) and (sec<12) then ATSetDrive(lw,79,9,$53,4);
      if ps2 and (trk>43) and (sec<12) then ATSetDrive(lw,79,9,$97,4);
      if (trk<44) and (sec>11) then ATSetDrive(lw,39,lwsec,$34,3);
      if ps2 and (trk<44) and (sec<12) then ATSetDrive(lw,39,9,$B7,2);
      if not(ps2) and (trk<44) and (sec<12) then ATSetDrive(lw,39,9,$73,2);
    end;
    writeln;
    bpb.jmp[1]:=235;
    bpb.jmp[2]:=36;
    bpb.jmp[3]:=144;
    bpb.spt:=sec;
    bpb.hds:=hds;
    bpb.shh:=0;
    bpb.bps:=512;
    bpb.spc:=spc;
    bpb.res:=1;
    bpb.fat:=2;
    bpb.sec:=sec*bpb.hds*trk;
    bpb.boot_code:=boot;
    case bpb.spc of
      1:    if (trk>44) and (bpb.spt in [12..17]) then
               bpb.mds:=$f9
            else
               bpb.mds:=$f0;
      2:    if trk in [1..43] then bpb.mds:=$fd else bpb.mds:=$f9;
      else  bpb.mds:=$f8;
    end;
    bpb.spf:=trunc(bpb.sec*1.5/512/bpb.spc)+1;
    dl:=lw;
    ax:=0;
    repeat int13 until not again;
    for track:=0 to trk-1 do begin
      n:=shift mod sec;
      for i:=1 to sec do
        table[i].s:=table2[(i+n-1) mod sec + 1];
      for head:=0 to hds-1 do begin
        write(text14,head,text15,track);
        x:=SectorLogical(head,track,1);
        write(text16,x);
        x:=Cluster(x);
        if (x>1) and (x<10000) then write(', Cluster: ',x);
        for i:=1 to sec do begin
	  table[i].t:=track;
	  table[i].h:=head;
        end;
        repeat
          ah:=5;
          al:=sec;
          dl:=lw;
          dh:=head;
          ch:=track;
          cl:=1;
          es:=seg(table);
          bx:=ofs(table);
          write('  F');
          mem[$40:$41]:=0;
          int13;
          write(#8,'V        ');write(#13);
          if not(again or noverify) then begin
            ah:=2;
            dl:=lw;
	    es:=seg(buffer);
	    bx:=ofs(buffer);
            int13;
          end;
        until not again;
        if (FCarry and flags) <> 0 then begin
          if (x<2) or (x>10000) then begin
            writeln(text17);
            halt;
          end;
          inc(bttCount);
          if bttCount>20 then begin
            writeln(text18,20*sec,text19);
            halt;
          end;
          btt[bttCount].track:=track;
          btt[bttCount].head:=head;
          writeln(text14,head,text15,track,text20);
        end;
      end;
    end;
  end;
end;

Procedure WriteBootSect;
begin
  with regs do begin
    writeln; bpb.oem:='CH-FOR12'; writeln;
    writeln(text21,bpb.oem); writeln(text22,bpb.sec);
    writeln(text23,bpb.spt); writeln(text24,bpb.hds);
    writeln(text25,bpb.bps); writeln(text26,bpb.shh);
    writeln(text27,bpb.res); writeln(text28,bpb.fat);
    writeln(text29,bpb.spf); writeln(text30,Cluster(bpb.sec)-2);
    dh:=0; dl:=lw; ch:=0; cl:=1;
    al:=1; ah:=3; es:=seg(bpb);
    bx:=ofs(bpb);
    repeat int13 until not again;
    fillchar(buffer[3],18430,#0);
    buffer[0]:=bpb.mds;
    buffer[1]:=$ff;
    buffer[2]:=$ff;
    bad:=0;
    for i:=1 to bttCount do
      for j:=1 to sec do begin
        x:=SectorLogical(btt[i].head,btt[i].track,j);
        x:=Cluster(x);
        ClusterOffset(x,Offset,Mask);
        if buffer[Offset] and Lo(Mask)=0 then inc(bad,bpb.spc*512);
        buffer[Offset]:=buffer[Offset] or Lo(Mask);
        buffer[Offset+1]:=buffer[Offset+1] or Hi(Mask);
      end;
    es:=seg(buffer);
    bx:=ofs(buffer);
    inc(cl);
    al:=bpb.spf;
    repeat int13 until not again;
    SectorAbsolute(bpb.spf+1,dh,ch,cl);
    ah:=3;
    dl:=lw;
    if bpb.spf+cl>sec+1 then al:=sec-cl+1;
    repeat int13 until not again;
    if bpb.spf+cl>sec+1 then begin
      bx:=bx+al*512;
      al:=bpb.spf-al;
      inc(dh);
      cl:=1;
      repeat int13 until not again;
    end;
    Bytes:=LongInt(Cluster(bpb.sec)-2)*512*LongInt(bpb.spc);
    writeln;
    writeln(Bytes:9,text31);
    if bad<>0 then writeln(bad:9,text32);
    writeln(Bytes-bad:9,text33);
    writeln;
  end;
end;

Procedure DrivePrt;
begin
  writeln;
  if lwtrk=0 then begin
    writeln(text34);
    exit;
  end;
  write(text35,chr(lw+$41));
  if lwhd then
    write(': High-Density, ')
  else
    write(': Double-Density, ');
  writeln(lwtrk+1,text10,lwsec,text11);
  write(text36);
  if pc80=$20 then writeln(text37);
  if pc80=$40 then writeln(text38);
  if at80 then writeln(text39);
  if not(at80) and (pc80=0) then writeln(text40);
  writeln;
end;

Procedure SyntaxError;
begin
  writeln; writeln(text41); writeln;
  writeln(text42); writeln(text43); writeln;
  writeln(text44); writeln; writeln(text45);
  writeln(text46); writeln(text47); writeln(text48);
  writeln(text49); writeln(text50); writeln(text51);
  writeln(text52); writeln(text53);
  writeln(text69); writeln(text70);
  writeln(text71); writeln;
  halt;
end;

Procedure CheckDos;
var Version: Word;
begin
  Version:=swap(DosVersion);
  if Version<$314 then begin
    writeln(text54);
    halt;
  end;
end;

begin
  writeln;
  writeln(text55);
  writeln(text56);
  CheckDos;
  GetIntVec($1E,old1E);
  new1E:=old1E;
  para:=paramstr(1);
  ps2:=false;
  noverify:=false;
  if (length(para)<>2) or (para[2]<>':') then SyntaxError;
  lw:=ord(UpCase(para[1]))-$41;
  DriveTyp(lw,lwhd,lwtrk,lwsec);
  DrivePrt;
  if (lwtrk=0) and (para<>'') then halt;
  rde:=0;
  il:=0;
  spc:=0;
  gpl:=0;
  shift:=0;
  ForceType:=0;
  trk:=lwtrk+1;
  sec:=lwsec;
  hds:=2;
  for i:=2 to paramcount do
    if paramstr(i)<>'' then begin
      para:=paramstr(i);
      chx:=para[1];
      if length(para)=1 then
        case UpCase(chx) of
          'P': ps2:=true;
          'V': noverify:=true;
        end
      else begin
        val(copy(para,2,255),n,j);
        if j<>0 then SyntaxError;
        case UpCase(para[1]) of
          'T':trk:=n;
          'H':hds:=n;
          'S':sec:=n;
          'D':rde:=n;
          'C':spc:=n;
          'I':il:=n;
          'G':gpl:=n;
          'F':shift:=n;
          'B':ForceType:=n;
        end;
      end;
    end;
  if sec>11 then hd:=true else hd:=false;
  if rde=0 then
    case hd of
      true:  rde:=224;
      false: rde:=112;
    end;
  if spc=0 then
    case hd of
      true:  spc:=1;
      false: spc:=2;
    end;
  if il=0 then
    if sec-lwsec in [3..8] then il:=2 else il:=1;
  if not(hds in [1..2]) then begin
    writeln(text57);
    halt;
  end;
  if trk<1 then begin
    writeln(text58);
    halt;
  end;
  if il>=pred(sec) then begin
    writeln(text59,pred(sec),text60);
    halt;
  end;
  if not(spc in [1..2]) then
    writeln(text61);
  if ShortInt(trk-lwtrk)>4 then
    writeln(text62);
  if rde>240 then
    writeln(text63);
  writeln;
  writeln(text64,chr(lw+$41),text65);
  writeln(text66);
  chx:=ReadKey;
  format;
  WriteBootSect;
end.
