
; From: cgs@umd5.umd.edu (Chris G. Sylvain)
; Newsgroups: comp.sys.ibm.pc
; Subject: Swapping LPT1 and LPT2 without moving cables
; Date: 18 Mar 89 17:40:10 GMT
; Organization: University of Maryland, College Park

; What this program does:
; ----------------------
;
; SWAPPORT.COM swaps the I/O port numbers for LPT1 and LPT2. After running
; the first time, DOS will use LPT2 when LPT1 or PRN is specified, and LPT1
; when LPT2 is specified. Subsequent invokations reverse the existing situation.
;
; Program History and Attributions:
; --------------------------------
;
;	3/18/89 Tested program before inflicting it on MASMless masses. Found
;	address printed in the DEBUG script didn't get anywhere near the BIOS
;	Data Area. Fixed program to swap the LPT1 and LPT2 base addresses as
;	was originally intended. --- Chris G. Sylvain
;
;	This MASM version of SWAPPORT was derived from a DEBUG script printed
;	in the Q&A article of the January 1989 issue of PC Resource. The
;	script was written by the PCResource Staff in response to a reader
;	(Mary E. Campbell, Fort Wayne, Ind.) query. The printed DEBUG script
;	includes code comments, but the instruction is to leave the comments
;	out when creating SWAPPORT.SCR. This version includes comments and
;	avoids using the "archaic" INT 20h DOS exit service.
;
;	The entire contents of the January 1989 issue of PC Resource is
;	Copyright (c) 1988 by IDG Communications/Peterborough, Inc.
;
; Motivation for using this program:
; ---------------------------------
;
;	If you have two printers connected to your machine, and would rather
;	not switch cables when you wish for the STDPRN device to be LPT2
;	instead of LPT1, then you will want to use this program. You can
;	automate the switching back in forth in a batch file, for instance.
;
; The source code for the program:
; -------------------------------
;
BIOSarea	EQU	040h	; segment where the BIOS Data Area lives
PRNPoffs	EQU	008h	; offset into BIOS Data Area where the LPTx
				; port numbers are stored
CSEG	SEGMENT
	ASSUME CS:CSEG, DS:NOTHING
;
	ORG	100h		; use .COM memory layout
;
START:	mov	AX, BIOSarea	; load value of data Segment
	mov	DS, AX		; set data Segment to 0040h
	mov	SI, PRNPoffs	; DS:SI will point to BIOS printer port data
	mov	AX, [SI]	; get LPT1 port address
	mov	BX, [SI+2]	; get LPT2 port address
	xchg	AX, BX		; exchange register contents
	mov	[SI], AX	; put LPT2 address in place of LPT1
	mov	[SI+2], BX	; put LPT1 address in place of LPT2
	mov	AX, 4C01h
	int	21h		; exit with return code == 01
;
CSEG	ENDS
;
	END	START

;   ARPA: cgs@umd5.UMD.EDU     BITNET: cgs%umd5@umd2
;   UUCP: ..!uunet!umd5.umd.edu!cgs
