
; What this program does:
; ----------------------
;
; SWAPCOM.COM swaps the I/O port numbers for COM1 and COM2. After running
; the first time, DOS will use COM2 when COM1 is specified, and COM1 when
; COM2 is specified. Subsequent invokations reverse the existing situation.
;
; Motivation for using this program:
; ---------------------------------
;
;	If you have two modems connected to your machine, and would rather
;	not switch cables when you wish for the AUX device to be COM2
;	instead of COM1, then you will want to use this program. You can
;	automate the switching back in forth in a batch file, for instance.
;
; The source code for the program:
; -------------------------------
;
BIOSarea	EQU	040h	; segment where the BIOS Data Area lives
COMPoffs	EQU	000h	; offset into BIOS Data Area where the COMx
				; port numbers are stored
CSEG	SEGMENT
	ASSUME CS:CSEG, DS:NOTHING
;
	ORG	100h		; use .COM memory layout
;
START:	mov	AX, BIOSarea	; load value of data Segment
	mov	DS, AX		; set data Segment to 0040h
	mov	SI, COMPoffs	; DS:SI will point to BIOS COM port data
	mov	AX, [SI]	; get COM1 port address
	mov	BX, [SI+2]	; get COM2 port address
	xchg	AX, BX		; exchange register contents
	mov	[SI], AX	; put COM2 address in place of COM1
	mov	[SI+2], BX	; put COM1 address in place of COM2
	mov	AX, 4C00h
	int	21h		; exit with return code 00 to show no error
;
CSEG	ENDS
;
	END	START
