NAME	INTRPT
;**********************************************************************
;*							      *
;*	INTERRUPT HANDLER FOR USE WITH IBM PERSONAL COMPUTER PASCAL   *
;*	PROGRAMS TO ALLOW DIRECT CALLING OF DOS INTERRUPT FUNCTIONS   *
;*	FROM WITHIN A PASCAL PROGRAM.				      *
;*								      *
;**********************************************************************
;
;
FRAME	  STRUC 			;Define structure (DSECT)
SAVEBP	  DW	?			;Caller's BP
SAVERET   DD	?			;Four byte return address
					;pushed by PASCAL
DXREG	  DW	?			;Address of word with DX value
CXREG	DW	?			;Address of word with CX value
BXREG	  DW	?			;Address of word with BX value
AXREG	  DW	?			;Address of word with AX value
NUMBER	  DW	?			;Interrupt to be performed
FRAME	  ENDS
;
CSEG	  SEGMENT	'CODE'
DGROUP	  GROUP 	DATA,STACK,CONST,HEAP,MEMORY
	  ASSUME	CS:CSEG,DS:DGROUP,ES:DGROUP,SS:DGROUP
INTRPT	  PROC		FAR
	  PUBLIC	INTRPT
	  PUSH		BP
	  MOV		BP,SP			;Point SP at FRAME structure
	  MOV		AL,BYTE PTR [BP].NUMBER ;Move the interrupt number
						;into the right place
	  MOV		CS:INTERUPT+1,AL
	  MOV		SI,[BP].AXREG		;Set up regs for interrupt
	  MOV		AX,[SI]
	  MOV		SI,[BP].BXREG
	  MOV		BX,[SI]
	  MOV		SI,[BP].CXREG
	  MOV		CX,[SI]
	  MOV		SI,[BP].DXREG
	  MOV		DX,[SI]
	  PUSH		BP
INTERUPT  EQU		THIS BYTE		;Perform the interrupt
	  INT		16
	  POP		BP
	  MOV		SI,[BP].AXREG		;Save the registers in
						;VAR parameters, so that
						;Pascal can access them
	  MOV		[SI],AX
	  MOV		SI,[BP].BXREG
	  MOV		[SI],BX
	  MOV		SI,[BP].CXREG
	  MOV		[SI],CX
	  MOV		SI,[BP].DXREG
	  MOV		[SI],DX
	  POP		BP
	  RET		10
INTRPT	  ENDP
CSEG	  ENDS
	  END
