(*********************************************************************)
program dodos(input,output);
(*********************************************************************)
{	Declare external procedures and functions                     }
{							              }
{		The following routines are not predeclared Pascal     }
{	procedures/functions and must be declared using the EXTERN    }
{	directive.						      }
(*********************************************************************)
procedure date(var s:string); extern;
function dosxqq(command:byte; parm:word):byte; extern;

(*********************************************************************)
{								      }
{	Declare Global variables				      }
{								      }
(*********************************************************************)
var
  doscall : byte;			{DOS return code (value in AL)}
  command : byte;			{DOS function #		      }
  parm    : word;			{DOS parameter list (DS:DX)   }
  smonth  : lstring(2);			{Month string.		      }
  sday    : lstring(2);			{Day string.		      }
  syear   : lstring(4);			{Year string. 	      }
  delim   : lstring(1);			{An arbitrary delimiter.      }
  month   : word;			{Current month.		      }
  day     : word;			{Current day.		      }
  message : lstring(80);		{Character string to be prtd. }
  answer  : string(10);			{MM-DD-YYYY		      }
  crcxqq [extern] : word;		{Ext. variable (val. in CX)   }
  crdxqq [extern] : word;		{Ext. variable (val. in DX)   }

begin
{*********************************************************************}
{								      }
{	DOS function call #09:					      }
{								      }
{	PRINT STRING - On entry, DS:DX must point to a character      }
{	string in memory terminated by a "$" (24H).  Each character   }
{	in the string will be output to the display.		      }
{								      }
{*********************************************************************}
  command := #09;			{Set Function # for Prt. Strg.}
  parm := wrd(adr message[1]);		{Point DS:DX at string	      }
  message := 'Today''s date is: $';	{$ terminates string.	      }
  doscall := dosxqq(command,parm);	{Call DOS to print string.    }
{*********************************************************************}
{								      }
{	DOS Function call #2A:					      }
{ 							      }
{	GET DATE - Returns date in CX:DX.  CX has the year (1980-     }
{	2099 in binary), DH has the month (1=Jan, 2=Feb, etc) and     }
{	DL has the day.  If the time-of-day clock rolls over to       }
{	the next day, the date is adjusted accordingly, taking into   }
{	account the number of days in each month and leap years.      }
{	Note that the resulant variable, doscall, will contain the    }
{	value in AL upon return from DOS; however, in this particu-   }
{	lar case the information is meaningless.		      }
{								      }
{*********************************************************************}
  command := #2A;			{Set function # for Get Date. }
  doscall := dosxqq(command,parm);	{Call DOS to get date.	      }
  month := hibyte(crdxqq);		{Month is returned in DH      }
  day := lobyte(crdxqq);		{Day is returned in DL        }
  writeln(month:2,'-',day:2,'-',crcxqq:4); {Use conventional writeln  }
  writeln('Enter new date as MM-DD-YYYY:');{Prompt for new date.      }
  readln(smonth,delim,sday,delim,syear);{Get new MM-DD-YYYY           }
{*********************************************************************}
{								      }
{	Do simple preliminary check to catch any format errors        }
{							              }
{*********************************************************************}
  if (decode(smonth,month) and decode(sday,day) and decode(syear,crcxqq))
     then
     else repeat
       writeln('Invalid format...reenter.');
         readln(smonth,delim,sday,delim,syear);
     until (decode(smonth,month and decode(sday,day) and decode(syear,crcxqq));
{*********************************************************************}
{								      }
{	DOS Function call #2B:					      }
{								      }
{	SET DATE - On entry, CRCXQQ must have a valid year (as set    }
{	above); PARM must have a valid month and day value (as set    }
{	below).  If the date is valid the function value returned     }
{	will be a 00, otherwise the returned value will be set to FF. }
{								      }
{*********************************************************************}
  parm := byword(month,day);		{Make month,day into a word.  }
  command := #2B;			{Set function # to SET DATE.  }
  if (dosxqq(command,parm) = 0)		{If valid date 	      }
    then
      begin
        writeln('Date has been reset.');
        date(answer);
        writeln('New date is: ',answer);
      end
    else writeln('Error in DOS set-date function.')
end.
