INTERFACE;
UNIT IOSTUFF(GetMode,SetMode,CursorSize,CursorOff,PutCursor,FindCursor,
	    ClearScreen,ClearLine,ClearEOL,ClearEOP,ClearField,ScrollUp,ScrollDn,
	    ScrollField,SetAttr,Writeline,GetStatus,GetDefault,
	    ReadSector,WriteSector,GetKey,GetShift,

	    {Names above are procedures. Names below are data types}

	    Lines,Columns,Modes,CursorValues,Dirs,TxtType,AttrLen,AttributeTypes,
	    BlinkType,ULineType,Normal,Reverse,Hilite,NoDisp,Blink,NoBlink,
	    ULine,NoUline,Drive,Track,Head,Sector,SecBuf,BuffAddr);

TYPE
     Lines = 1..25;			{Number of lines on screen}
     Columns = 1..80;			{Number of columns on screen}
     Modes = 1..7;			{Video display mode numbers}
     CursorValues = 0..13;		{Max. no. of lines in cursor}
     Dirs = 1..2;			{Scroll directions. 1=Up 2=Down}
     TxtType = LString(81);		{Line of text to be written to screen}
     AttrLen = 1..2000; 		{Number of chars to set attrib. byte}
     AttributeTypes = (Normal,Reverse,Hilite,NoDisp);
     BlinkType = (Blink,NoBlink);
     ULineType = (ULine,NoULine);
     Drive = 0..3;
     Track = 0..39;
     Head = 0..1;
     Sector = 1..8;
     SecBuf = Array [0..511] of Byte;	{Buffer used to read sector into}
     BuffAddr = Adrmem; 		{Buffer start address}

PROCEDURE GetMode(var Mode: Modes);
{Find out what video display is being used and what mode it is in}

PROCEDURE SetMode(Mode: Modes);
{Set the video display to the desired mode}

PROCEDURE CursorSize(Bottom,Top: CursorValues);
{Set the size of the cursor.  Bottom line is 0, top line is 13.  Monochrome}
{cursor is 13 lines high.  Color mode cursor is 7 lines high max.  Lines   }
{wrap around if they exceed the maximum value.}

PROCEDURE CursorOff;
{Turns the cursor off completely.  Can be turned back on with CursorSize.}

PROCEDURE PutCursor(Line:Lines; Column:Columns);
{Positions the cursor on the screen at Line,Column.  Line must be in the}
{range 1-25 and Column must be in the range 1-80.}

PROCEDURE FindCursor(var Line:Lines; var Column:Columns);
{Locates the cursor and returns the values to the calling routine.}
{Line and column are same range as above.}

PROCEDURE ClearScreen;
{Clears the entire screen to blanks.  Leaves the cursor position unchanged.}

PROCEDURE ClearLine(Line: Lines);
{Clears one line on the screen.  Procedured is passed the line number (1-25)}
{to be erased.}

PROCEDURE ClearEOL;
{Clears from the cursor to the end of the current line.}

PROCEDURE ClearEOP;
{Clears the screen from the line following the current cursor line}
{to the bottom of the page.}

PROCEDURE ClearField(Line:Lines; Column:Columns; Width:Columns; Height:Lines);
{Will clear to blanks a designated field on the screen .  The procedure is}
{passed the Line and Column of the upper left-hand corner of the field to}
{be cleared, the desired width of the field in columns, and the numer of}
{lines high the field is to be.}

PROCEDURE ScrollUp;
{Scrolls the entire screen up one line, replacing the bottom line with}
{a row of blanks.}

PROCEDURE ScrollDn;
{Scrolls the entire screen down one line, replacing the top line with}
{a row of blanks.}

PROCEDURE ScrollField(Line:Lines; Column:Columns; Width:Columns; Height:Lines;
		      Number:Lines; Direction:Dirs);
{Will scroll a designated area of the screen up or down one line.  The}
{procedure is passed the Line and Column of the upper left-hand corner}
{of the field to be scrolled, the desired width in columns, the number}
{of lines high the field is to be and the direction to scroll. }

PROCEDURE SetAttr(Line:Lines; Column:Columns; Len:Attrlen; Attr:AttributeTypes;
		  ABlink:BlinkType; AUL:UlineType);
{Sets the attribute byte on the screen beginning at Line, Column and}
{continuing for Len characters.  Will set the attribute, blink and underline.}

PROCEDURE WriteLine(Line:Lines; Column:Columns; Txt:TxtType);
{Writes a line of text up to 80 characters long on the display beginning}
{at Line, Column.}

PROCEDURE GetStatus(var Drv:Drive;var Side:Head;var Trk:Track;var Sect:Sector);
{Interrogates operating system to find out the status of the last disk access.}

PROCEDURE GetDefault(var Default:Drive);
{Interrogates operating system to find the current default disk drive.}

PROCEDURE ReadSector(Drv:Drive; Side:Head; Trk:Track; Sect:Sector; BufPtr:Adrmem);
{Reads the desired sector directly from a disk, given the Drive number, side}
{of the disk, and track and sector to be read.	Also points to the beginning}
{address of a buffer in which to store the 512 bytes read from disk.}

PROCEDURE WriteSector(Drv:Drive; Side:Head; Trk:Track; Sect:Sector; BufPtr:Adrmem);
{Same as above, but writes instead.}

PROCEDURE GetKey(var Key:Byte; var Scan:Byte);
{Checks the keyboard buffer and waits for a key to be pressed if none are}
{available.  Returns the value of the key pressed and the scancode.}

PROCEDURE GetShift(var Shift:Byte);
{Checks the keyboard to determine the current shift status.  See detailed}
{explanation of shift status in the Technical Reference Manual.}

END;


