/*
**  folder.h (InterMail)
**
**  Copyright 1989-1993 Peter Stewart & InterZone Software, Inc.
**  All rights reserved.
**
**  Definitions for each record in FOLDER.CFG
**
**  Last revision:  90-02-22
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*/
/*
**  Constant long bit values
*/
#define RESTRICT    0x00000001L
#define ECHO_INFO   0x00000002L
#define EXPORT_OK   0x00000004L
#define USE_XLAT    0x00000008L
#define PRIVATE     0x00000010L
#define READONLY    0x00000020L
#define QUICKBBS    0x10000000L
#define DELETED     0x20000000L         /* Never written to disk */
#define LOCAL       0x40000000L
#define ECHOMAIL    0x80000000L


/*
**  User access mask
*/
#define USER_1      0x00000001L
#define USER_2      0x00000002L
#define USER_3      0x00000004L
#define USER_4      0x00000008L
#define USER_5      0x00000010L
#define USER_6      0x00000020L
#define USER_7      0x00000040L
#define USER_8      0x00000080L
#define USER_9      0x00000100L
#define USER_10     0x00000200L


/*
**  Folder structure
**
**  The "path" and "title" fields below are NUL terminated.
*/
typedef struct
    {
    char    path[65],       /* Path if "board==0", otherwise emtpy */
            title[41];      /* Title to appear on screen */
    byte    origin;         /* Default origin line, 0-19 */
    long    behave;         /* Behavior, see above */
    long    pwdcrc;         /* CRC32 of password or -1L if unprotected */
    long    userok;         /* Users with initial access */
    byte    useaka;         /* AKA to use, 0==primary */
    word    board;          /* QuickBBS/RemoteAccess board number */
    }
    FOLDER, far *FOLDERPTR;

/* end of file "folder.h" */
