/*
**  event.h (InterMail)
**
**  Copyright 1989-1993 Peter Stewart & InterZone Software, inc.
**  All rights reserved
**
**  Definitions for record in EVENT.0##
**
*/

/*
**  Day values, non-exclusive bit values
**
**  I.e. If the event was active on Monday and Tuesday, the day field
**       would contain 0x03. If the event is active on all days, the
**       day field should only contain 0x80.
*/

#define MONDAY      0x01
#define TUESDAY     0x02
#define WEDNESDAY   0x04
#define THURSDAY    0x08
#define FRIDAY      0x10
#define SATURDAY    0x20
#define SUNDAY      0x40
#define ALL         0x80


/*
**  Behavior, non-exclusive bit values
**
**  I.e. If an event had FREQ_OK and DO_PICKUP enabled, the behavior field
**       would be 0x00000018L.
**
*/

#define USERS_OK        0x00000001L /* Allow users to interrupt event */
#define MAIL_EXIT       0x00000002L /* Exit when mail is received */
#define CRASH_ONLY      0x00000004L /* Only send Crash mail */
#define FREQ_OK         0x00000008L /* Honor inbound file requests */
#define DO_PICKUP       0x00000010L /* Pickup mail during outbound calls */
#define ALLOW_PICKUP    0x00000020L /* Allow calling nodes to pickup mail */
#define SEND_ONLY       0x00000040L /* Send only, don't wait between calls */
#define RECV_ONLY       0x00000080L /* Receive only, don't make any calls */
#define FORCED          0x00000100L /* Event is forced and MUST be executed */
#define ENDNOMAIL       0x00000200L /* End event when no more outgoing mail */
#define SENDTOCM        0x00000400L /* Send to CM systems only */
#define SENDTONOCM      0x00000800L /* Send to non-CM systems only */
#define ONLYONCE        0x00001000L /* Only call a node once during event */
#define PICKUPFREQ      0x00002000L /* Honor file requests on outbound calls */
#define HOLDFREQ        0x00004000L /* Don't send file requests during event */
#define HOLDFILES       0x00008000L /* Don't send file attaches during event */

/* .. gap .. */

#define DELETED         0x40000000L /* Never written to disk */
#define INACTIVE        0x80000000L


/*
**  The first record in EVENT.CFG must be the EVENTBASE and have the tag
**  field set to "@".
*/

typedef struct
 {
   char    tag;        /* Event tag A-Z (X==External) */
   byte    day;        /* Days to execute event on, non-exclusive value */
   char    mud,        /* - Subtract, + Add, * Don't use eventbase */
           s_hr,       /* Starting hour, 24 hour format */
           s_mi,       /* Starting minute */
           l_hr,       /* Length (hours), 24 hour format */
           l_mi;       /* Length (minute) */
   byte    level;      /* Errorlevel on X-events, ignored on non-X events */
   dword   behave;     /* Event behavior, non-exclusive value */
   int     cost;       /* Maxmium cost of mail to go out, -1 don't care */
   int     lastrun;    /* Packed DOS date when last executed */
   byte    usealias;   /* AKA to use for event, 0==Primary  */
   word    timer;      /* Delay between calls in seconds, 0==Default */
   word    mincost;    /* Minimum cost for messages to go out */
   char    RESERVED;   /* Don't touch this! */
   char    comment[38];/* Comment (user supplied) */
 }
 EVENT, *EVENTPTR;

#ifdef OLDSTUFF   /* Old version of event record, IM 2.10 and earlier */

typedef struct
 {
   char    tag;        /* Event tag A-Z (X==External) */
   byte    day;        /* Days to execute event on, non-exclusive value */
   char    mud,        /* - Subtract, + Add, * Don't use eventbase */
           s_hr,       /* Starting hour, 24 hour format */
           s_mi,       /* Starting minute */
           l_hr,       /* Length (hours), 24 hour format */
           l_mi;       /* Length (minute) */
   byte    level;      /* Errorlevel on X-events, ignored on non-X events */
   dword   behave;     /* Event behavior, non-exclusive value */
   int     cost;       /* Maxmium cost of mail to go out, -1 don't care */
   int     lastrun;    /* Packed DOS date when last executed */
   byte    usealias;   /* AKA to use for event, 0==Primary  */
   word    timer;      /* Delay between calls in seconds, 0==Default */
   word    mincost;    /* Minimum cost for messages to go out */
   char    RESERVED;   /* Don't touch this! */
 }
 OLDEVENT, *OLDEVENTPTR;

#endif OLDSTUFF

#endif _NOTEVENT_

/* end of file "event.h" */

