/*
**  modem2.h (InterMail)
**
**  Copyright 1989-1993 Peter Stewart & InterZone Software, Inc.
**  All rights reserved.
**
**  Definitions for MODEM.0##
**
**  -------------------------------------------------------------------------
**  This information is not necessarily final and is subject to change at any
**  given time without further notice
**  -------------------------------------------------------------------------
*/

#define byte  unsigned char
#define word  unsigned int
#define dword unsigned long

#define MODEM_ARQ   0x0001       //  for connect_msg struct
#define MODEM_DEL   0x80000000L  //   "        "        "


typedef struct
 {

   dword     flags;           // misc flags

   byte      modemport;       // comport
   word      modembaud;       // port bps (30,12,75,24,48,96,19,38,57,11)

   byte      modemdelay;      // delay between strings to modem
   byte      answerdelay;     // delay before answer string is sent

   byte      begin_hour;      // <Ŀ
   byte      begin_minute;    //   
   byte      end_hour;        //    limited hours
   byte      end_minute;      // <

   /* ASCIIZ strings */

   char      escapestr    [11],     // <Ŀ
             offhookstr   [11],     //        
             reconnectstr [11],     //        
             init1        [50],     //        
             init2        [50],     //        
             init3        [50],     //        
             resetstr     [50],     //         commands to modem
             downstr      [50],     //        
             hangupstr    [11],     //        
             dialstr      [11],     //        
             modemanswer  [11],     //        
             prefix       [31],     //        
             postfix      [31],     // <

             errormsg     [16],     // <Ŀ
             busymsg      [16],     //        
             carriermsg   [16],     //        
             okmsg        [16],     //        
             ringmsg      [16],     //         messages from modem
             nodialmsg    [16],     //        
             noanswmsg    [16],     //        
             voicemsg     [16],     // <
             reserved1    [128],    // < empty space...
             modem_name   [51];     // name of modem in modemalt.im
   word      connect_msgs;          // number of connect message records
   char      dial_file    [13];     // name of file for dial control.
   char      reserved2    [106];    // reserved for future use
 }
 modem_ctl;

typedef struct        // <Ŀ
 {                    //     
   char string[51];   //     
   long location;     //       used only for reading 'modemalt.im'
 }                    //     
 modemalt_rec;        // <


/*-------------------------------04-20-92-----------------------------------
 *
 * below is the structure of the records at the end of the modem.xxx file.
 *
 --------------------------------------------------------------------------*/

typedef struct
 {
   char   string[41];     // string from modem
   char   reserv[8];      // reserved space
   byte   bbsexit;        // errorlevel for bbs exit
   byte   termlevel;      // terminate with errorlevel
   dword  speed;          // speed of connections in bps
   dword  flags;          // flags associated with connect. (ie ARQ)
 }
 connect_msg, far *connectptr;


