  (* Record definition EVENT.SYS (Event file) *)

  (* Copyright 1988-1993 Peter Stewart & InterZone Software, Inc. *)

CONST
  E_MONDAY    = $01;    { Day values for event day bitmask }
  E_TUESDAY   = $02;
  E_WEDNESDAY = $04;
  E_THURSDAY  = $08;
  E_FRIDAY    = $10;
  E_SATURDAY  = $20;
  E_SUNDAY    = $40;
  E_ALL       = $80;

(* --------------------------------------------------------------------------*)
(* BEHAVIOR BITS:                                                            *)
(* --------------------------------------------------------------------------*)

  E_USERS_OK      : LongInt = $00000001;
  E_MAIL_EXIT     : LongInt = $00000002;
  E_CRASH_ONLY    : Longint = $00000004;
  E_FREQ_OK       : Longint = $00000008;
  E_DO_PICKUP     : Longint = $00000010;
  E_ALLOW_PICKUP  : Longint = $00000020;
  E_SEND_ONLY     : Longint = $00000040;
  E_RECV_ONLY     : Longint = $00000080;
  E_FORCED        : LongInt = $00000100;
  E_ENDNOMAIL     : LongInt = $00000200;
  E_SENDTOCM      : LongINt = $00000400;
  E_SENDTONOCM    : LongInt = $00000800;
  E_NOREPACK      : LongInt = $00001000;
  E_PICKUPREQUEST : LongInt = $00002000;
  E_HOLDFREQ      : LongInt = $00004000;
  E_HOLDFILES     : LongInt = $00008000;

  E_ERASED        : LongInt = $40000000;  { only used internally by setup }
  E_INACTIVE      : Longint = $80000000;

(* --------------------------------------------------------------------------*)
TYPE
  eventrec = RECORD
               tag         : Char;           (* TAG ... A-Z *)
               day         : Byte;
               modifier    : Char;  (* + Add, - Subtract from Eventbase *)
               starthour,
               startminute,
               lenhour,
               lenminute,
               level       : Byte;
               behavior    : LongInt;      { behavior flags, see above }
               cost        : Word;         { max cost                  }
               lastrundate : Word;         { packed DOS format date    }
               usealias    : Byte;         { 0 - 20                    }
               redialdel   : Word;
               mincost     : word;
               reserved    : byte;
               comment     : array[1..38] of char;
             END;


