{---------------------------------------------------------------------------
    InterMail Control file

    Copyright 1986-93 Peter Stewart & InterZone Software, Inc.
    All rights reserved
---------------------------------------------------------------------------}

{ Mailer ----------------------------------------------------------------- }

{ --- Loglevels }

CONST
  LOGFATAL   = $0001;                 { !    Fatal errors                  }
  LOGERROR   = $0002;                 { ?    Errors                        }
  LOGBRIEF   = $0004;                 { +    Major changes in action       }
  LOGACCT    = $0008;                 { $    Accounting information        }
  LOGXFER    = $0010;                 { *    Sent/Received files           }
  LOGTRIVIAL = $0020;                 { -    Minor changes in action       }
  LOGEFF     = $0040;                 { %    Transfer efficiencies         }
  LOGMODEM   = $0080;                 { =    Modem activities / resp.      }
  LOGROUTING = $0100;                 { :    Rerouting of messages etc.    }
  LOGSESSION = $0200;                 { ~    Session info, SysOp, etc.     }
  LOGDEBUG   = $8000;                 {      All loglevels enabled         }

{ --- Miscellaneous MAILER flags }

  NOUNLISTED      = $00000001;        { Don't allow unlisted systems       }
  CREATE_BATCH    = $00000002;        { Create batchfile when BBS caller   }
  TERMONLY        = $00000004;        { Running as Terminal-Only           }
  DTR_HANGUP      = $00000008;        { Use DTR to hangup                  }
  DTR_DIAL        = $00000010;        { Toggle DTR prior to dialing        }
  DTR_BUSY        = $00000020;        { Use DTR to signal BUSY             }
  MANUAL_ANSWER   = $00000040;        { Use manual answer                  }
  CONNECT_RESET   = $00000080;        { Reset modem to connect speed       }
  MODEM_FIXED     = $00000100;        { Use constant speed against modem   }
  NOMAIL_NOPWD    = $00000200;        { No mail from unsecured systems     }
  DELAYFIRST      = $00000400;        { Delay before first call            }
  CLOCK           = $00000800;        { Display clock                      }
  KILLNULL        = $00001000;        { Remove messages with no text       }
  MAILONLY        = $00002000;        { Don't allow human callers          }
  LIMITED_ANSWER  = $00004000;        { Limited hours to answer            }
  EXIT_NETMAIL    = $00008000;        { Exit when netmail received         }
  ZONE_ADAPTION   = $00010000;        { Adopt called/calling zone          }
  PRINTNEWMSGS    = $00020000;        { Print received messages            }
  NOUNKNOWNPOINTS = $00040000;        { Don't accept unlisted points       }
 {FORCEDCARRIER   = $00080000;}       { Carrier is forced. Ring required   }
 {NULLMODEM       = $00100000;}       { Initiate session when CD high      }
  MAILER43LINES   = $00200000;        { Use 43/50 line mode in mailer      }
  SWAPTOEMSDISK   = $00400000;        { Swap file to LIM/EMS/DISK w/shell  }
  MAILEREMSOK     = $00800000;        { Swap to EMS if available           }
  PRESENTAKAS     = $01000000;        { Present all our AKAs to remote?    }
  NOBLINKMAIL     = $02000000;        { Don't flash the mail waiting sign  }
  EXITONANYFILE   = $04000000;        { Exit after any files has been rcvd }

{ --- Audible flags }

  CLOCKNOISE      = $0001;            { Tic-tac-tic-tac-tic-tac            }
  INMAILNOISE     = $0002;            { Unpacked any mail                  }
  INCRASHNOISE    = $0004;            { Unpacked crash or immediate mail   }
  INCONNECTNOISE  = $0008;            { Incoming MAIL call (connect)       }
  INCALLERNOISE   = $0010;            { Incoming human caller passed >BBS  }
  MAILWAITING     = $0020;            { Mail is waiting                    }
  OUTMAILNOISE    = $0040;            { Sent mail (after session)          }
  OUTCONNECTNOISE = $0080;            { Outgoing MAIL call (connect)       }
  ERRORNOISE      = $0100;            { S.O.S.                             }

{ --- Request types }

  REQALL          = $01;              { Anybody can request                }
  REQNONE         = $02;              { No one can request                 }
  REQLISTED       = $04;              { Only listed systems and their pts  }
  REQLIMITED      = $08;              { Limited hours                      }

{ --- Modem connect flags }

  MODEM_ARQ = $01;
{-----------------------------------------------------------------------------}
  MAXKEY    = 24;

TYPE
  PrefixType = array[0..10] of array[1..31] of Char;
  arr5 = array[1..5] of char;

mailrec = record
	{-------------------------------------------------------------------}
	{ LOG      - PATHNAME FOR LOGFILE                                   }
	{-------------------------------------------------------------------}
    log  : array[1..71] of Char;  {* NO LONGER USED! Moved to MAILER.001 etc. *}
    loglevel : word;

	{-------------------------------------------------------------------}
	{ PREFIXES ARE ADDED TO NUMBERS TO BE DIALED. PREFIXES 1-10 ARE USED}
	{ WHEN COMPILING THE NODELIST. PREFIX[0] IS DIALED BEFORE EVERY     }
	{ DIALED NUMBER. POSTFIX IS ADDED TO DIALED NUMBER (APPENDED)       }
	{-------------------------------------------------------------------}
    prefix : Prefixtype;
    postfix : array[1..31] of Char;

    flags          : longint;              { See --- Miscellaneous flags    }
    flags_reserved : longint;
    audio          : word;                 { See --- Audio flags            }
    synchtimer     : byte;                 { Number of seconds for sync M/O }

	{-------------------------------------------------------------------}
	{ CRASHEXIT - ERRORLEVEL FOR EXIT AFTER CRASHMAIL RECEIVED          }
	{-------------------------------------------------------------------}
    crashexit : Byte;
	{-------------------------------------------------------------------}
	{ ERRORLEVELS TO EXIT WITH AT DIFFERENT CONNECT SPEEDS              }
	{-------------------------------------------------------------------}
       bbs300 : Byte;             { if any field contains 0 the speed }
      bbs1200 : Byte;             { should be EXCLUDED for HUMANS     }
      bbs1275 : Byte;             { NO LONGER USED!                   }
      bbs2400 : Byte;             { Moved to MODEM.001 .002 etc.      }
      bbs4800 : Byte;
      bbs9600 : Byte;
     bbs19200 : Byte;
     bbs38400 : Byte;

  {-------------------------------------------------------------------}
	{ MISC MODEM SETTINGS. MODEMFIXED MEANS USE CONSTANT SPEED AGAINST  }
	{ MODEM.  MODEMPORT IS COM PORT 1-4                                 }
	{-------------------------------------------------------------------}
      modembaud : word;                     { Maxbaud modem supports }
      modemport : Byte;                             { COM Port (1-4) }
      modemdelay : byte;         { Moved to MODEM.001 .002 etc.      }

	{-------------------------------------------------------------------}
	{ MODEM RESPONSECODES (NUMERICAL) AND ACTION/COMMAND STRINGS        }
	{-------------------------------------------------------------------}
      modemmsg : array[1..16] of array[1..16] of Char;

        { No longer used: Moved to MODEM.001 .002 etc.      }
	{1}	{ Result msg for CONNECT 300	}
	{2}	{ Result msg for CONNECT 1200	}
	{3}	{ Result msg for CONNECT 1275	}
	{4}	{ Result msg for CONNECT 2400	}
	{5}	{ Result msg for CONNECT 4800	}
	{6}	{ Result msg for CONNECT 9600	}
	{7}	{ Result msg for CONNECT 19200	}
	{8}	{ Result msg for CONNECT 38400	}
	{9}	{ Result msg for ERROR		}
	{10}{ Result msg for BUSY		}
	{11}{ Result msg for NO CARRIER	}
	{12}{ Result msg for OK		}
	{13}{ Result msg for RING		}
	{14}{ Result msg for NO DIALTONE	}
	{15}{ Result msg for NO ANSWER	}
	{16}{ Result msg for VOICE		}

      modemescape    : array[1..11] of Char; { Moved to MODEM.001 .002 etc.      }
      modemoffhook   : array[1..11] of Char;
      modemreconnect : array[1..11] of Char;
      modeminit1     : array[1..50] of Char;
      modeminit2     : array[1..50] of Char;
      modeminit3     : array[1..50] of Char;
      modemreset     : array[1..50] of Char;
      modemdown      : array[1..50] of Char;
      modemhangup    : array[1..11] of Char;
      modemdial      : array[1..11] of Char;
	{-------------------------------------------------------------------}
	{ String for making the modem answer the phone                      }
	{-------------------------------------------------------------------}
    modemanswer : array[1..11] of Char; { Moved to MODEM.001 .002 etc.      }

	{-------------------------------------------------------------------}
	{ Delay before sending modem answer string                          }
	{-------------------------------------------------------------------}
    answerdelay : byte;  { Moved to MODEM.001 .002 etc.      }
        {-------------------------------------------------------------------}
        {  Limited answer start and end times                               }
        {-------------------------------------------------------------------}
    beginhour,
    beginmin,
    endhour,
    endmin      : byte;
	{-------------------------------------------------------------------}
	{ CALLRETRY - HOW MANY TIMES DO WE ATTEMPT SUCCESSFUL CONNECTION?   }
	{                                                                   }
	{ BUSY   - BUMPED ON BUSY RECEIVED                                  }
	{ RESEND - CONNECTED, BUT NEVER FINISHED                            }
	{ DELAY  - DELAY BETWEEN RE-TRIES                                   }
	{-------------------------------------------------------------------}
    callretry : record
                  busy,
                  resend,
                  delay : Byte;
                end;
        {-------------------------------------------------------------------}
        {  File request control                                             }
        {-------------------------------------------------------------------}
    reqlist    : array[1..71] of char; { List to scan for reqable dirs      }
    reqalias   : array[1..71] of char; { Magic filenames		    }
    reqmessage : array[1..71] of char; { Appended to FAILED REQUEST message }
	{-------------------------------------------------------------------}
	{ PICKUP ACCESS - DEFINES WHOM OR WHAT MAY INITIATE A FILE REQUEST  }
	{ TYP (BYTE) CAN BE 1, 2 OR 3 AS DEFINED BELOW                      }
	{                                                                   }
	{ ALL - 1 == ANYONE MAY REQUEST FILE(S)                             }
	{ NO  - 2 == NO FILE REQUESTS ACCEPTED OR HONORED                   }
	{ LST - 3 == Only nodes listed in nodelist can request files        }
	{-------------------------------------------------------------------}
    reqtype    : byte;		       { Bit field                          }
    reqmaxfiles: byte;                 { Max number of files to send on 1 req - 0=unlimited}
    reqmaxtime : word;                 { Maximum number of minutes for req  }
    reqmaxsize : word;                 { Maximum size (in KB) for req	     }
    reqminbaud : word;                 { Minimum baudrate for req	     }
    reqstarthr : byte;                 { Start time for file requests, can be }
    reqstartmin: byte;                 { combined with the reqdays field.   }
    reqendhr   : byte;
    reqendmin  : byte;
    reqdays    : byte;              { 7 6 5 4 3 2 1 0x80==All days
                                       - - - - - - -
                                             
                                              Saturday
                                             Friday
                                            Thursday
                                           Wednesday
                                          Tuesday
                                         Monday
                                        Sunday				}

	{-------------------------------------------------------------------}
	{ FILE TO USE FOR BANNER WHEN HUMAN CALLER CALLS UP AND ARE LET THRU}
	{-------------------------------------------------------------------}
      bbsname : array[1..11] of char;
      banner  : array[1..71] of Char;

	{-------------------------------------------------------------------}
	{ USER INSTALLABLE KEYS FROM THE MAILER CONSOLE (ALT + FKEY)        }
	{-------------------------------------------------------------------}
      key : array[1..MAXKEY] of record                    { Function key }
              cmd      : array[1..61] of Char;
              title    : array[1..26] of Char;
              behavior : byte;
            end;

	{-------------------------------------------------------------------}
	{ Colors                                                            }
	{-------------------------------------------------------------------}
    col : record
            head,                               {  1 = header		}
            hitext,                             {  2 = highlight	}
            clock,                              {  3 = clock		}
            entry,                              {  4 = data entry	}
            error,                              {  5 = error		}
            normtext,                           {  6 = normal text	}
            frame,                              {  7 = frame		}
            wtext,                              {  8 = window text	}
            wframe,                             {  9 = window frame	}
            wbar,                               { 10 = window select	}
            whigh : Byte;                       { 11 = window highlght	}
	end;

	{ Number of days to keep entries in history files }

    keep_history : byte;

	{ IMServer password, if none given, server is INactive }

    slavepwd : array[1..21] of char;

	{ File displayed to users when system is in event for no callers }

    ineventfile : array [1..71] of char;

	{ File displayed when human callers are seen on mail-only system }

    mailonlyfile : array[1..71] of char;

	{ External programs to run on certain "wake-up" strings }

    externmail : array[1..10] of record
                    wakeupstr  : array[1..40] of char;
                    errorlevel : byte;
                  end;

        {-------------------------------------------------------------------}
        {  Limited noise start and end times                                }
        {-------------------------------------------------------------------}
    audio_beginhour,
    audio_beginmin,
    audio_endhour,
    audio_endmin      : byte;

		min_undial_cost		: word;

	{ RESERVED FIELD }

    RESERVERAT: array[1..957] of char;
    modemtype : array[1..61] of char;
  END;  {record mailrec}
{ Editor ----------------------------------------------------------------- }

CONST
  EDITOR43LINES  = $00000001;
  SHOWHARDCRS    = $00000002;
  EDITORSWAP     = $00000004;              { Swap file to LIM/EMS/DISK w/shell}
  EDITOREMSOK    = $00000008;

{ Netmail folder behavior }

  RESTRICTED     = $00000001;
  EXPORTOK       = $00000004;
  USEXLATTABLES  = $00000008;
  EDREADONLY     = $00000020;

  MAXORIGIN      = 20;

TYPE

{---------------------------------------------------------------------------}
{ EDITOR STRUCTURE                                                          }
{---------------------------------------------------------------------------}
 editrec = record
	{-------------------------------------------------------------------}
	{ MACRO KEYS IN EDITOR. ALT + 'KEY' TO ACTIVATE. | = CR             }
	{-------------------------------------------------------------------}
	macro : array[1..MAXKEY] of
		  array[1..61] of Char;          	{ Macro definition  }

	{-------------------------------------------------------------------}
	{ Right margin in editor, defaults to 65                            }
	{-------------------------------------------------------------------}
      margin      : Byte;

	{-------------------------------------------------------------------}
	{ Default message attribute in editor                               }
	{-------------------------------------------------------------------}
      msgbits     : Word;

  {-------------------------------------------------------------------}
  {  Miscellaneous settings                                           }
  {-------------------------------------------------------------------}
      flags  : longint;

	{-------------------------------------------------------------------}
	{ Origin lines                                                      }
	{-------------------------------------------------------------------}
      origin : array[1..MAXORIGIN] of array[1..61] of Char;

	{-------------------------------------------------------------------}
	{ Colors                                                            }
	{-------------------------------------------------------------------}
      col : record
                topline,                        { 1 = top line on screen  }
                status,                         { 2 = statusline          }
                error,                          { 3 = error               }
                text,                           { 4 = normal text         }
                textquotes,                     { 5 = quotes              }
                textreverse,                    { 6 = reversed text       }
                texthardCRs,                    { 7 = hard CRs            }
                header,                         { 8 = message header      }
                headerdata,                     { 9 = header data         }
                headerdatahilite,               {10 = hilite for header   }
                entry,                          {11 = data entry fields   }
                wframe,                         {12 = window frame        }
                wtext,                          {13 = window text	        }
                wbar,                           {14 = window select       }
                whigh : Byte;                   {15 = window hghlght      }
              end;

    NetBehave : LongInt;

	{-------------------------------------------------------------------}
	{ Translate tables from and to disk                                 }
	{-------------------------------------------------------------------}
    transin  : array[0..255] of Char;
    transout : array[0..255] of Char;

    qbbsdir  : array[1..71] of Char;    { Hudson format message files }

    Reserved : array[1..1024] of Byte;

  END;  {record editrec}

{ Shared data ------------------------------------------------------------- }

CONST
  FASTKEY    = $00000001;
  FLICKER    = $00000002;
  BLACKSCR   = $00000004;
  HAVEXKBD   = $00000008;
  FORCE24HR  = $00000010;

  SUPERUSER  = $00000001;            { User flags                        }
  ADMINUSER  = $00000002;
  USER       = $00000004;
  BYPASSRO   = $00010000;
  BYPASSEXP  = $00020000;

  OLDMAXAKA  = 10;
  MAXAKA     = 20;
  MAXUSER    = 10;
  MAXLANUSER = 255;

  PROTECT_MEXIT   = $00000001;
  PROTECT_MSHELL  = $00000002;
  PROTECT_MKEYS   = $00000004;
  PROTECT_MFREQ   = $00000008;
  PROTECT_MXMIT   = $00000010;
  PROTECT_MSEND   = $00000020;
  PROTECT_MPOLL   = $00000040;
  PROTECT_MNCOMP  = $00000080;
  PROTECT_MQUE    = $00000100;
  PROTECT_MPRN    = $00000200;

TYPE

{---------------------------------------------------------------------------}
{ SHARED record STRUCTURE                                                   }
{---------------------------------------------------------------------------}
  shrdrec = record

	{-------------------------------------------------------------------}
	{ SYSTEM FILE PATH. SOURCE/COMPILED NODELIST, etc etc               }
	{-------------------------------------------------------------------}
      system : array[0..70] of Char;

	{-------------------------------------------------------------------}
	{        MAILPATH - INCOMING MESSAGES ARE UNPACKED AND STORED HERE  }
	{                   AS WELL AS OUTGOING MESSAGES BEFORE GETTING     }
	{                   'BUNDLED'. THIS IS ALSO REFERED TO AS FOLDER 0  }
	{-------------------------------------------------------------------}
      mailpath : array[0..70] of Char;
      swappath : array[0..70] of char;

	{-------------------------------------------------------------------}
	{ MISCELANEOUS PATH NAMES (BUT STILL VITAL)                         }
	{                                                                   }
	{        FILEPATH - INCOMING FILES ARE STORED HERE                  }
	{                                                                   }
	{        PACKETS  - TEMPORARY 'BUNDLE' AREA FOR OUTGOING PACKETS    }
	{-------------------------------------------------------------------}
      semaphore       : array[1..71] of char;
      securefiledir   : array[1..71] of char;
      filepath        : array[1..71] of Char;
      packets         : array[1..71] of Char;
      NodeDir         : array[1..71] of char;

	{-------------------------------------------------------------------}
	{ COUNTRY CODE (DOS)                                                }
	{-------------------------------------------------------------------}
     country : Word;

	{-------------------------------------------------------------------}
	{ AKAS ARE ALTERNATE NET ADDRESSES: ZONE:NET/NODE.POINT             }
	{-------------------------------------------------------------------}
     aka : array[0..OLDMAXAKA] of record  { NO LONGER USED, but still }
              zone,                       { maintained by IMSetup     }
              net,                        { see below!                }
              node,
              point	: Word;
            end;

     flags          : longint;
     blackout_time  : byte;

     user : array[1..MAXUSER] of record
               name    : array[1..37] of Char;
               pwdcrc  : longint;
               flags   : longint
             end;

     exitpwdcrc     : longint;
     exitflags      : longint;
     filler         : array[1..120] of byte;
     domstuff       : array[1..20] of record
                        gate : word;
                        junk : word;
                        name : array[1..28] of char;
                      end;
     systemname    : array[1..50] of char;
     systemloc     : array[1..40] of char;
     systemphone   : array[1..24] of char;
     fill          : word;
     xtra          : longint; 
     systemflags   : array[1..20] of char;
     systemcountry : array[1..26] of char;
     serial        : array[1..14] of char;
     Reserved      : array[1..72] of Byte;
  END;  {record shrdrec}


{ Terminal --------------------------------------------------------------- }

CONST
  CONNECT_NOISE   = $00000001;
  TRANSFER_NOISE  = $00000002;
  USE_TRANSLATE   = $00000004;
  USE_43LINES     = $00000008;
  AUTOZMODEM      = $00000010;
  NOWRAPAROUND    = $00000020;
  LOCALECHO       = $00000040;
  NOAVATAR        = $00000080;

TYPE
  termrec = record
	{-------------------------------------------------------------------}
	{ Modem init strings for terminal mode                              }
	{-------------------------------------------------------------------}
    initstring : array[1..41] of Char;

    scrollsize : word;  { scroll buffer size }

	{-------------------------------------------------------------------}
	{ Default emulation                                                 }
	{-------------------------------------------------------------------}
    Defemulation : Byte;	{ 1 = TTY, 2 = VT100 }

	{-------------------------------------------------------------------}
	{ Default protocol                                                  }
	{-------------------------------------------------------------------}
    protocol : Byte; 	{ T=Telink, X=xmodem, y=xmodem/1K, s=SEAlink, z=xmodem }

	{-------------------------------------------------------------------}
	{ Macro keys in terminal                                            }
	{-------------------------------------------------------------------}
    shiftkey : array[1..12] of array[1..31] of char;
    ctrlkey  : array[1..12] of array[1..31] of char;
	{-------------------------------------------------------------------}
	{ Where to put downloaded files                                     }
	{-------------------------------------------------------------------}
    downloadpath : array[1..60] of char;
    uploadpath   : array[1..60] of char;

	{-------------------------------------------------------------------}
	{ Translate tables for incoming and outgoing characters             }
	{-------------------------------------------------------------------}
    translatein  : array[0..255] of Char;
    translateout : array[0..255] of Char;

	{-------------------------------------------------------------------}
	{ Time to wait between redial attempts                              }
	{-------------------------------------------------------------------}
    retrywait : Byte;

	{-------------------------------------------------------------------}
	{ Behavior and miscellaneous options such as noise.. etc.           }
	{-------------------------------------------------------------------}
    behavior     : longint;

    directorypwd : longint;

    editor    : array[1..60] of char;  { Invoked with Alt-I }

    reserved : array[1..796] of byte;

    newaka : array[0..MAXAKA] of record  { location of new AKA list!!! }
              zone,
              net,
              node,
              point	: Word
            end
  end;

{ Printer ---------------------------------------------------------------- }
  CONST
    PAGE_FORMAT   = $00000001;
    PAGE_FFEED    = $00000002;
    EJECT         = $00000004;
    MANUAL_PAPER  = $00000008;
    HIDE_KLUDGE   = $00000010;
    CONTINUOUS    = $00000020;

	{-------------------------------------------------------------------}
	{ Printer control						     }
	{-------------------------------------------------------------------}
  TYPE
    printrec = record
      port      : Byte;	{ 0-2 = LPT1 - LPT3, 3-4 = COM1, COM2 }
      baud      : Byte;	{ 0=9600, 1=4800, 2=2400, 3=1200 }
      stopbits  : Byte;  { 0=1, 1=2.....! }
      databits  : Byte;	{ 0=7, 1=8	 }
      parity    : Byte;	{ 0=even, 1=odd, 2=none }
      pglength  : Byte;
      behavior  : LongInt;
      init      : array[1..71] of char;
      reset     : array[1..71] of char;
      boldon    : array[1..31] of char;
      boldoff   : array[1..31] of char;
      underon   : array[1..31] of char;
      underoff  : array[1..31] of char;
      italon    : array[1..31] of char;
      italoff   : array[1..31] of char;
      pagewidth : Byte;
      leftmarg  : Byte;
      botmargin : Byte;
      topmargin : Byte;
      translate : array[char] of char;
      reserved  : array[1..39] of char;
      printtype : array[1..61] of char;
    end;

{ Global control file ------------------------------------------------------

 Don't use ANY of the data in the file if the CRC values are NOT correct.
----------------------------------------------------------------------------}

CONST
  THISREV = $0100;

type
  ctlrec = record
    fingerprint : arr5;     { 'JoHo'#0  }    { TosScan needs this... }
    sysrev      : word;     { = thisrev }
    ctlcrc      : longint;  { crc32 of record except first 11 & last 4 bytes }
    _m          : mailrec;
    _e          : editrec;
    _s          : shrdrec;
    imsignature : longint;  { = $0000fd0b }
    _t          : termrec;
    _p          : printrec;
    ctlcrc2     : longint;  { crc32 of record except last 4 bytes }
  end; {ctlrec}

{
  crc calculation, assuming:
    var
      ctl : ctlrec;

     ctl.ctlcrc := crc32(ctl._m, sizeof(ctl._m) + sizeof(ctl._e)
            + sizeof(ctl._s) + 4 + sizeof(ctl._t) + sizeof(ctl._p), -1);

     ctl.ctlcrc2 := crc32(ctl, sizeof(ctl)-4, -1);

    Use standard CCITT 32 bit Cyclic Redundancy Check algorithm,
    with -1 as the seed value.

}
{---------------------------------------------------------------------------}
{ User record for LAN version                                               }
{---------------------------------------------------------------------------}
    userstruc = array[1..MAXLANUSER] of record
                  name  : String[36];
                  pwd   : longint;
                  flags : longint
                end;
{---------------------------------------------------------------------------}
{ Control structure for mailer node file:  MAILER.0##                       }
{---------------------------------------------------------------------------}
  mailinfrec = record
                 pkdir    : array[0..70] of char; { packet directory }
                 logfile  : array[0..70] of char; { log file name    }
                 systname : array[0..49] of char; { system name      }
                 systloc  : array[0..39] of char; { system location  }
                 systcount: array[0..25] of char; { country          }
                 systphone: array[0..23] of char; { phone number     }
                 systflags: array[0..19] of char  { nodelist flags   }
               end;
{---------------------------------------------------------------------------}
{---------------------------------------------------------------------------}
{ Control structure for modem info, file:  MODEM.0##                        }
{---------------------------------------------------------------------------}
    modem_ctl = record
                  flags         : longint;
                  modemport     : byte;
                  modembaud     : word;
                  modemdelay    : byte;   { delay between strings to modem }
                  answerdelay   : byte;   { delay before answer string is sent }

                  begin_hour    : byte;   { for limited hours }
                  begin_minute  : byte;
                  end_hour      : byte;
                  end_minute    : byte;
                  escapestr     : array [1..11] of char;
                  offhookstr    : array [1..11] of char;
                  reconnectstr  : array [1..11] of char;
                  init1         : array [1..50] of char;
                  init2         : array [1..50] of char;
                  init3         : array [1..50] of char;
                  resetstr      : array [1..50] of char;
                  downstr       : array [1..50] of char;
                  hangupstr     : array [1..11] of char;
                  dialstr       : array [1..11] of char;
                  modemanswer   : array [1..11] of char;
                  prefix        : array [1..31] of char;
                  postfix       : array [1..31] of char;

                  errormsg      : array [1..16] of char; { modem messages }
                  busymsg       : array [1..16] of char;
                  carriermsg    : array [1..16] of char;
                  okmsg         : array [1..16] of char;
                  ringmsg       : array [1..16] of char;
                  nodialmsg     : array [1..16] of char;
                  noanswmsg     : array [1..16] of char;
                  voicemsg      : array [1..16] of char;
                  reserved1     : array [1..128] of char;
                  modemname     : array [1..51] of char;
                  modem_msgs    : word;  { number of modem msgs following }
                  dialfile      : array [1..13] of char;
                  reserved2     : array [1..106] of char; { for future use }
                end; {modem_ctl}

{---------------------------------------------------------------------------}
{ modem connect message struct, a number specified in "modem_msgs"          }
{ of these follow the above struct                                          }
{---------------------------------------------------------------------------}
     msrec = record
               ms        : array[1..41] of char;
               reserv    : array[1..8] of byte;
               bbsexit   : byte;              { errorlevel for bbs exit   }
               termlevel : byte;              { terminate with errorlevel }
               bps       : longint;           { speed of connection       }
               flags     : longint;
             end;
{---------------------------------------------------------------------------}
{ Flags affecting modem behavior, stored in MODEM.0##                       }
{---------------------------------------------------------------------------}
  const
    modem_mask = DTR_HANGUP + DTR_DIAL + DTR_BUSY + MANUAL_ANSWER
               + CONNECT_RESET + MODEM_FIXED + LIMITED_ANSWER
               + FORCEDCARRIER + NULLMODEM;


