#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <process.h>
#include <stdlib.h>
#include "collect.hpp"

extern "C" {
extern void far OvrProfileProc (void);
extern long far _OVRHOOK__;                // external def for the overlay hook addr.
void far _loadds my_hook (unsigned a, unsigned s, unsigned o);
long get_hook ();
void set_hook (void (far *p)(void));
}


typedef unsigned short uint;
typedef unsigned long ulong;
typedef unsigned char uchar;

static ulong timer = 0;
static uint log_all = 0;
static FILE *outstrm = NULL;

static char ErrorStr[80] = {0};
struct Data
{
  uint addr;
  ulong curTic;
  uint count;
  char module[14];
  Data () : addr (0), curTic (0), count (0) {}
};

static tPTRLIST<Data> *list = NULL;

static void LoadMapFile (void)
{
  FILE *fp = NULL;
  char temp[100] = "";
  char *ret = NULL, *cp;
  char *p;
  Data *data;

  strcpy (temp, _argv[0]);
  p = strrchr (temp, '.');
  if (p)
  {
    p++;
    strcpy (p, "MAP");
  }

  if ((fp = fopen (temp, "rt")) == NULL)
  {
    sprintf (ErrorStr, "%s:%s", sys_errlist[errno], temp);
    if (outstrm)
    {
      fprintf (outstrm, "%s\n", ErrorStr);
      ErrorStr[0] = 0;
    }

    return;
  }
  while (strstr (temp, "Detailed map of segments") == 0)
  {
    if (fgets (temp, 90, fp) == NULL)
      if (feof (fp))
      {
        return;
      }
  }

  if (log_all)
    fprintf (outstrm, "Loading modules from .MAP file...\n");

  while (1)
  {
    if (strncmp (&temp[16], "C=STUBSEG", 9) == 0)
    {
      if (strncmp (&temp[11], "0000", 4) != 0)
      {
        data = new Data;

        data->addr = (uint) strtol (&temp[1], NULL, 16);

        ret = strstr (temp, "M=");
        if (ret == NULL)
        {
          delete data;
          break;
        }
        ret += 2;
        cp = strchr (ret, ' ');
        if (cp)
          cp[0] = '\0';

        strncpy (data->module, ret, 13);
        data->module[13] = 0;

        if (!list)
        {
          list = new tPTRLIST<Data> (20,5);
        }

        list->insert (data);

        if (log_all)
          fprintf (outstrm, "%04X %s\n", data->addr, data->module);

      }
    }
    if (fgets (temp, 90, fp) == NULL)
      if (feof (fp))
        break;
  }
}

static int FindMapIdent (uint x, ulong m, ulong t)
{
  uint i;

  if (!list)
    return 0;

    for(i=0; i<list->count; i++ )
    {
        if ( list->items[i]->addr == x )
        {
          list->items[i]->count++;
          list->items[i]->curTic = m;
          if (log_all)
          {
            fprintf (outstrm, "%04X, [%05u], {%04ld}, (%07ld), %s\n",
                     list->items[i]->addr,
                     list->items[i]->count,
                     t,
                     list->items[i]->curTic,
                     list->items[i]->module);

          }
          return 1;
        }
    }
    return 0;
}

#pragma argsused
void far _loadds my_hook (unsigned a, unsigned s, unsigned o)
{
  unsigned x;
  ulong far *ptime = (ulong *)MK_FP (0x40, 0x6C);
  ulong _t;

  if (timer)
    _t = *ptime - timer;
  else
    _t = 0;

  x = (s-_psp-0x10);
  FindMapIdent (x, *ptime, _t);
  timer = *ptime;
}

static void Results ()
{
  uint i;

  if (!list)
    return;

  fprintf (outstrm, "\n--------- Results -------------\n");
  fprintf (outstrm, "Segment, [Count], (Current Tics), ModuleName\n");

  for(i=0; i<list->count; i++ )
  {
    fprintf (outstrm, "%04X, [%05u], (%07ld), %s\n",
             list->items[i]->addr,
             list->items[i]->count,
             list->items[i]->curTic,
             list->items[i]->module);
  }
}

static void set_hook (void (far *p)(void))
{
  *((void (far**)())&_OVRHOOK__) = p;
}

static void openfile (void)
{
  char *p;
    p = getenv ("OVRPROF");
    if (p == NULL)
      outstrm = stdout;
    else
    if ((outstrm = fopen (p, "wt")) == NULL)
    {
      perror (p);
      exit (-2);
    }

  if (ErrorStr[0])
  {
    fprintf (outstrm, "%s\n", ErrorStr);
  }
}

static void _start ()
{
  if (strstr (strupr (getenv("OVRPROFALL")), "Y"))
  {
    log_all = 1;
    openfile ();
  }

  LoadMapFile ();

  if (log_all)
  {
    fprintf (outstrm, "Segment, [Count], {Elapsed Tics}, (Current Tics), ModuleName\n");
  }
  set_hook (OvrProfileProc);
}

static void _end ()
{
  if (!outstrm)
    openfile();
  Results ();
  fprintf (outstrm, "----- Results finished ----- (Global destructor code may follow...)\n"

  );
}

#pragma startup _start  64
#pragma exit    _end    64

extern "C" {
  void ovr_prof_init (void)
  {
  }
}
