# Nmake macros for building Windows 32-Bit apps
!include <ntwin32.mak>

all: scanaplt.dll

scanaplt.obj: scanaplt.c
    $(cc) $(cflags) $(cvarsdll) $(cdebug) scanaplt.c

scanaplt.res: scanaplt.rc scanaplt.h
	rc -r scanaplt.rc

scanaplt.rbj: scanaplt.res
	cvtres -$(CPU) scanaplt.res -o scanaplt.rbj

scanaplt.lib: scanaplt.obj scanaplt.def
    $(cvtobj) $(cvtdebug) scanaplt.obj
    lib32 -machine:$(CPU) \
    -def:scanaplt.def   \
    scanaplt.obj        \
    -out:scanaplt.lib

scanaplt.dll: scanaplt.obj scanaplt.def scanaplt.rbj scanaplt.lib
    $(link) $(linkdebug)      \
    -base:0x1C000000          \
    -dll                      \
    -entry:LibMain$(DLLENTRY) \
    -out:scanaplt.dll         \
    scanaplt.exp scanaplt.obj scanaplt.rbj advapi32.lib \
       $(guilibsdll)

