# Nmake macros for building Windows 32-Bit apps
!include <ntwin32.mak>

all: hpscanap.dll hpscanap.lib

hpscanap.obj: hpscanap.c
    $(cc) $(cflags) $(cvarsdll) $(cdebug) hpscanap.c

hpscanap.res: hpscanap.rc scanaplt.h hpscanap.h
	rc -r hpscanap.rc

hpscanap.rbj: hpscanap.res
	cvtres -$(CPU) hpscanap.res -o hpscanap.rbj

hpscanap.lib: hpscanap.obj hpscanap.def
    $(cvtobj) $(cvtdebug) hpscanap.obj
    lib32 -machine:$(CPU)  \
    -def:hpscanap.def      \
    hpscanap.obj           \
    -out:hpscanap.lib

hpscanap.dll: hpscanap.obj hpscanap.def hpscanap.rbj hpscanap.lib
    $(link) $(linkdebug)       \
    -base:0x2C000000           \
    -dll                       \
    -entry:LibMain$(DLLENTRY)  \
    -out:hpscanap.dll          \
    hpscanap.exp hpscanap.obj hpscanap.rbj $(guilibsdll)

