/* for "Preparing a C application for non-English 
speaking users"
 * William F. Dudley Jr.
 *
 * Usage:       makemsg msg_file c_file c_file2 . . .
 * Example:     makemsg msg_file ../*.c
 *
 * Note: all the hooks are in place for sorting the strings for
 *   faster searching. We are doing linear search for now, but if
 *   speed becomes a problem, we can wire it up.
 */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <errno.h>
#if __TURBOC__
#include <mem.h>
#include <alloc.h>
#elif MSC
#include <memory.h>
#include <malloc.h>
#define MAXPATH 80
#define MAXDRIVE 3
#define MAXDIR 66
#define MAXFILE 9
#define MAXEXT 5
#define EXTENSION 0x02
#define FILENAME  0x04
#define DIRECTORY 0x08
#define DRIVE     0x10
int fnsplit (char *, char *, char *, char *, char *);
void fnmerge (char *, char *, char *, char *, char *);
#endif

#define FALSE 0
#define TRUE  1
#define MAIN  1
#include "makemsg.h"

int loadmsgs (unsigned *, struct msg *, FILE *, int);
FILE *xsrc, *xold, *xnew, *xmsg, *xhdr;
char qsrc[MAXPATH], qold[MAXPATH], qnew[MAXPATH], qmsg[100];
char p[100], q[100], pout[100], psav[100];

int jmsg, jcomment, jquote, kquote, jprintf, jif;
int i, j, k, l, m, n;

main (argc, argv)
int   argc;
char      **argv;
{
  int error = 0;
  unsigned int cnt;
  char qdisk[MAXDRIVE], qpath[MAXDIR], qfname[MAXFILE], qext[MAXEXT];
  char *tok;
  int exists;
  int pathbits, files, argcnt;

                /* Open message file and find highest number. */
    if (argc > 1)

@CSOURCE7 =         strcpy (qmsg, argv[1]);
    else {
        printf ("Msg file -- ");
        scanf ("%s", qmsg);
    }
    xmsg = fopen (qmsg, "r");
    if (xmsg == NULL) {
        printf ("No message file %s found.\n", qmsg);
        exit (9);
    }

    /* read existing message file into memory */
    cnt = sizeof (txt)/sizeof (struct msg);
    error = loadmsgs (&cnt, txt, xmsg, 1);
    if (error) exit (error);
    jmsg = cnt;
    fclose (xmsg);
    xmsg = fopen (qmsg, "a");

    if (argc > 2) {
        strcpy (qsrc, argv[2]);
        files = argc - 2;
    }
    else {
        printf ("Source file -- ");
        scanf ("%s", qsrc);
        files = 1;
    }
    for(argcnt =  0 ; argcnt < files ; argcnt++) {
        /* first src file is already in qsrc, strcpy not needed */
        /* subsequent src files need to be gotten, however */
        if (argcnt) strcpy (qsrc, argv[argcnt+2]);
        xsrc = fopen (qsrc, "r");
        if (xsrc == NULL) {
            printf ("No source file %s found.\n", qsrc);
            exit (9);
        }

        /* strip off disk and path */
        pathbits = fnsplit (qsrc, qdisk, qpath, qfname, qext);
        fnmerge (qold, NULL, NULL, qfname, qext);
        /* make qnew have no drive or directory, new files made in 
CWD */
        fnmerge (qnew, NULL, NULL, qfname, qext);
        /* if source is not in another directory,
         * append 'n' & 'o' to file names           */
        if (!(pathbits & (DIRECTORY | DRIVE))) {
            strcat (qold, "o");
            strcat (qnew, "n");
        }

        xnew = fopen (qnew, "w");

        jcomment = FALSE;  jprintf = FALSE;  jif = FALSE;
        while (TRUE) {
            fgets (q, 128, xsrc);
            if (feof (xsrc))  break;

            jquote = 0;
            kquote = 0;
            if (q[0] != '#') {

@CSOURCE7 =                 for (j = 0; q[j]; j++) {
                    if (!strncmp(&q[j], "printf", 6))  jprintf 
=  TRUE;
                    if (!strncmp(&q[j], "#if", 3))     jif 
=  TRUE;
                    if (!strncmp(&q[j], "#endif", 6))  jif 
= FALSE;

                    if (q[j] == '/' && q[j+1] == '*')  jcomment = 
TRUE;
                    if (q[j] == '*' && q[j+1] == '/')  jcomment = 
FALSE;

                    if (jprintf == TRUE  && jcomment == FALSE &&
                            jif == FALSE && q[j] == '\"')
                    {
                        if      (jquote == 0)  jquote = j;
                        else if (kquote == 0)  kquote = j;
                    }
                }
            }
            if (jquote && kquote) {
                        /* extract the string, save it in psav[], 
*/
                        /* expand it into pout[] */
                k = 0;
                for (j = jquote+1; j < kquote; j++)  {  psav[k] = 
q[j];  k++;  }
                psav[k] = 0;
                for (j = 0, tok = psav; *tok ; tok++) {
                    if (*tok != '\\')
                        pout[j++] = *tok;
                    else {
                        switch (tok[1]) {
                            case 'n' :/* we found "\n" */
                                pout[j++] = '\n';
                                break;
                            case 't' :
                                pout[j++] = '\t';
                                break;
                            case 'v' :
                                pout[j++] = '\v';
                                break;
                            case 'b' :
                                pout[j++] = '\b';
                                break;
                            case 'r' :
                                pout[j++] = '\r';
                                break;
                            case 'f' :
                                pout[j++] = '\f';
                                break;
                            case '0' : case '1' : case '2' : case 
'3' :
                            case '4' : case '5' : case '6' : case 
'7' :
                                i=tok[3]-'0'+(tok[2]-'0')*8+(tok[1]-'0')*8;
                                tok += 2;
                                pout[j++] = (char)i;
                                break;
                            case '\\' :
                                pout[j++] = '\\';
                                break;
                            default :
                                tok<197>; /* don't skip 2 chars */
                                break;
                        }
                        tok++;    /* because we prob. found "\n" 
*/
                    }

@CSOURCE7 =                 }
                pout[j] = '\0';
                if (kquote-jquote < 3) {
                    fprintf (xnew, "%s", q);
                }
                else {
                    exists = -1;
                    /* is string found in existing message file ? 
*/
                    for(j = 0 ; j <= jmsg ; j++) {
                        if(!strcmp(pout, txt[j].s)) break; 
                    }
                    /* does string exists in message file already 
? */
                    if (j != jmsg+1) exists = txt[j].index;
                    if (exists >= 0)
                        printf ("%s: string found in msg 
file, #%d: Fixing.\n", qsrc, exists);
                    else {
                        /* does user want to move string out of source 
file ? */
Query:
                        printf ("\n%s\n", q);
                        printf ("\t\tLeave it or Fix it?  ");  scanf 
("%s", p);
                        if(p[0] == 'l' || p[0] == 'L') {
                            fprintf (xnew, "%s", q);
                            continue;
                        }
                        else if (p[0] != 'f' && p[0] != 'F')
                            goto Query;
                    }

                    if (exists < 0) {
                        /* then we haven't seen this string before 
*/
                        jmsg++;         /* Bump message counter. */
                        if (jmsg > MAX_MSGS) {
                            fprintf (stderr, "too many strings\n");
                            exit (ENOMEM);
                        }
                                /* now store message in bufr array 
*/
                        j = strlen (pout);
                        txt[jmsg].s = calloc (j+1, 1);
                        if (txt[jmsg].s == NULL) {
                            fprintf(stderr,"can't alloc more memory, 
line %u\n", msg);
                            exit (ENOMEM);
                        }
                        strcpy (txt[jmsg].s, pout);
                        txt[jmsg].index = jmsg;
                        exists = jmsg;
                        fprintf (xmsg, "%d %s_%03d\n", jmsg, 
qfname, jmsg);
                        fprintf (xmsg, "%s\n\004\n", pout);
                    }
                              /* Print the line without quoted string. 
*/
                    strncpy(p, q, jquote); k = jquote;
                    k += sprintf (p+k, "txt[%d]", exists);
                    for (j = kquote+1; q[j]; j++)  {  p[k] = q[j];  k++;  }
                    p[k] = '\0';
                    fprintf (xnew, "%s", p);
                        /* And put a comment into the code with the 
string. */
                    m = 60-strlen(psav);
                    while (m > 7)  {  fprintf (xnew, "\t");  m 
-= 8;  }
                    while (m > 0)  {  fprintf (xnew, " 
");   m -= 1;  }

                    fprintf (xnew, "/* >> %s << */\n", 
psav);
                }
            }
            else fprintf (xnew, "%s", q);
        }
        fclose (xsrc);
        fclose (xnew);
        if (!(pathbits & (DIRECTORY | DRIVE))) {
            unlink (qold);
            rename (qsrc, qold);
            rename (qnew, qsrc);
        }
    }

    fclose (xmsg);
    jmsg++;
    xhdr = fopen ("menuload.h", "w");
    fprintf (xhdr, "char *txt[%d];\n", jmsg);
    fclose (xhdr);

    exit (0);
}

#ifdef MSC
/* this function is in the Turbo-C library */

int fnsplit (path,  disk,  dir,  name,  ext)
char        *path, *disk, *dir, *name, *ext;
{
char bdisk[MAXDRIVE], bdir[MAXDIR], bname[MAXFILE], bext[MAXEXT];
char *cp1, *cp2;
register int i;
int result;

    i = 0;
    cp1 = strchr(path, ':');
    if (cp1 == NULL) cp1 = &path[-1];
    else for( ; &path[i] <= cp1 ; i++) bdisk[i] = path[i];
    bdisk[i] = '\0';
    cp2 = strrchr(path, '\\');
    i = 0;
    if (cp2 == NULL) cp2 = strrchr(path, '/');
    if (cp2 == NULL) cp2 = cp1;
    else for( cp1++ ; cp1 <= cp2 ; i++, cp1++) bdir[i] = *cp1;
    bdir[i] = '\0';
    for( i = 0, cp2++ ; ((*cp2)&&(i < 8)&&(*cp2!='.')) ; i++, 
cp2++) {
        bname[i] = *cp2;
    }
    bname[i] = '\0';
    for( i = 0 ; ((*cp2)&&(i < 4)) ; i++, cp2++) {
        bext[i] = *cp2;
    }
    bext[i] = '\0';
    if (disk!=NULL) strcpy(disk, bdisk);
    if (dir!=NULL) strcpy(dir, bdir);
    if (name!=NULL) strcpy(name, bname);
    if (ext!=NULL) strcpy(ext, bext);
    result  = (strlen(bdisk)) ? DRIVE : 0 ;
    result += (strlen(bdir)) ? DIRECTORY : 0 ;
    result += (strlen(bname)) ? FILENAME : 0 ;

    result += (strlen(bext)) ? EXTENSION : 0 ;
    return(result);
}

void fnmerge (path,  disk,  dir,  name,  ext)
char         *path, *disk, *dir, *name, *ext;
{
    sprintf (path, "%s%s%s%s%s", path, disk, dir, name, ext);
}
#endif
