/*****************************************************/
/* modeless.c                                        */
/* -- Demonstrates modeless common dialogs.          */
/* -- To compile:                                    */
/*    cc modeless.c modeless.rc toolhelp.lib         */
/*****************************************************/

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <toolhelp.h>
#include "modeless.h"

LRESULT CALLBACK __export LWndProc(HWND, UINT, WPARAM,
                                                    LPARAM);
BOOL    FHook(HWND, UINT, WPARAM, LPARAM);
BOOL    ModelessChooseFont(HWND);

char    szApp[] = "Modeless";   /* App's name. */
HWND    hwndEdit;               /* Edit control */

#define didEdit     1       /* Edit control id. */
#define didApply    0x402   /* Apply button id. */

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
                                       LPSTR lsz, int wShow)
    {
    MSG     msg;
    HWND    hwnd;

    if (hinsPrev == NULL)
        {
        WNDCLASS    wcs;

        wcs.style = CS_HREDRAW | CS_VREDRAW;
        wcs.lpfnWndProc = LWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = MAKEINTRESOURCE(midFonts);
        wcs.lpszClassName = szApp;
        if (!RegisterClass(&wcs))
            return 0;
        }

    msg.wParam = 0;
    if ((hwnd = CreateWindow(szApp, "Modeless Common "
      "Dialog Demo", WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hins, NULL)) != NULL)
        {
        ShowWindow(hwnd, wShow);
        while (GetMessage(&msg, NULL, 0, 0))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }

    return msg.wParam;
    }

LRESULT CALLBACK __export LWndProc(HWND hwnd, UINT wm,
                               WPARAM wParam, LPARAM lParam)
    {
    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        if ((hwndEdit = CreateWindow("edit", "Type here",
          WS_CHILD | WS_VISIBLE | WS_VSCROLL |
            ES_MULTILINE, 0, 0, 0, 0, hwnd,
          (HMENU)didEdit, GetWindowInstance(hwnd),
          NULL)) == NULL)
            return -1;
        break;

    case WM_SIZE:
        SetWindowPos(hwndEdit, NULL, 0, 0,
          LOWORD(lParam), HIWORD(lParam),
          SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
        break;

    case WM_COMMAND:
        if (wParam == idmFonts)
            ModelessChooseFont(hwnd);
        break;

    case WM_DESTROY:
        PostQuitMessage(0);
        break;

    case WM_USER:
        return FHook(((LPMSG)lParam)->hwnd,
          ((LPMSG)lParam)->message,
          ((LPMSG)lParam)->wParam,
          ((LPMSG)lParam)->lParam);
        }

    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

BOOL FHook(HWND hwnd, UINT wm, WPARAM wParam, LPARAM lParam)
/*****************************************************/
/* -- ChooseFont dialog filter.                      */
/*****************************************************/
    {
    LOGFONT         gft;
    static HFONT    hfnt;
    HFONT           hfntNew;

    if (wm == WM_INITDIALOG)
        {
        EnableWindow(GetWindowOwner(hwnd), TRUE);
        return TRUE;
        }

    if (wm != WM_COMMAND ||
      !(wParam == didApply || wParam == IDOK))
        return FALSE;

    SendMessage(hwnd, WM_CHOOSEFONT_GETLOGFONT, 0,
      (LPARAM)(LPLOGFONT)&gft);
    if ((hfntNew = CreateFontIndirect(&gft)) != NULL)
        {
        SendMessage(hwndEdit, WM_SETFONT,
          (WPARAM)hfntNew, TRUE);
        if (hfnt != NULL)
            DeleteObject(hfnt);
        hfnt = hfntNew;
        }

    return wParam == didApply;
    }

BOOL ModelessChooseFont(HWND hwnd)
/*****************************************************/
/* -- Display the choose font common dialog.         */
/* -- Create another task to carry out this request. */
/* -- hwnd  : Owner window for dialog.               */
/*****************************************************/
    {
    HINSTANCE       hins;
    TASKENTRY       tsk;
    LPCHOOSEFONT    lpcsf;

    if ((hins = (HINSTANCE)WinExec("dlgservr.exe", 0))
      < HINSTANCE_ERROR)
        return FALSE;

    /* Find task.  Return false if we can't find it. */
    tsk.dwSize = sizeof tsk;
    if (!TaskFirst(&tsk))
        return FALSE;
    do
        if (tsk.hInst == hins)
            break;
    while (TaskNext(&tsk));
    if (tsk.hInst != hins)
        return FALSE;

    /* Get block big enough for CHOOSEFONT, LOGFONT, */
    /* and lpszStyle string. */
    if ((lpcsf = GlobalAllocPtr(GHND | GMEM_SHARE,
      sizeof(CHOOSEFONT) + sizeof(LOGFONT) +
      LF_FACESIZE)) == NULL)
        {
        TerminateApp(tsk.hTask, NO_UAE_BOX);
        return FALSE;
        }

    lpcsf->lStructSize = sizeof(CHOOSEFONT);
    lpcsf->hwndOwner = hwnd;
    lpcsf->lpLogFont = (LPLOGFONT)((LPBYTE)lpcsf +
      sizeof(CHOOSEFONT));
    lpcsf->Flags = CF_SCREENFONTS | CF_EFFECTS |
      CF_APPLY | CF_ENABLEHOOK |
      CF_INITTOLOGFONTSTRUCT | CF_USESTYLE |
      CF_FORCEFONTEXIST;
    lpcsf->lpszStyle = (LPSTR)lpcsf->lpLogFont +
      sizeof(LOGFONT);
    lpcsf->nFontType = SCREEN_FONTTYPE;

    /* Store pointer here so it gets passed to hook */
    /* via WM_INITDIALOG. */
    lpcsf->lCustData = (LPARAM)lpcsf;

    PostAppMessage(tsk.hTask, WM_USER, 0,
      (LPARAM)lpcsf);
    return TRUE;
    }
