/* editmdi.c                                         */
/* -- Demo uses global memory for each MDI edit.     */
/* -- Compile with "cc editmdi.c"                    */

#include <windows.h>
#include <windowsx.h>
#include "editmdi.h"

HWND    hwndClient;    /* MDI client. */

/* Class names. */
char    szFrame[]    = "EditMdiFrame";  /* Frame. */
char    szChild[]    = "EditMdiChild";  /* MDI kid. */
char    szApp[]      = "EditMdi";       /* App name. */

#define cbMinEdit   1024    /* Initial edit memory. */
#define didEdit     1       /* Edit control ID. */

LRESULT CALLBACK __export
  ChildWndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK __export
  FrameWndProc(HWND, UINT, WPARAM, LPARAM);
void    NewMdiChild(void);
void    TestSetHandle(LPSTR);

int PASCAL WinMain(HINSTANCE hinsThis, HINSTANCE hinsPrev,
  LPSTR lszCmdLine, int wCmdShow)
    {
    MSG     msg;
    HWND    hwnd;

    if (hinsPrev == NULL)
        {
        WNDCLASS  wcs;

        /* Register the frame class. */
        wcs.style = 0;
        wcs.lpfnWndProc = FrameWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hinsThis;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground =
          (HBRUSH)(COLOR_APPWORKSPACE + 1);
        wcs.lpszMenuName = MAKEINTRESOURCE(idmMDI);
        wcs.lpszClassName = szFrame;
        if (!RegisterClass(&wcs))
            return FALSE;

        /* Register the MDI child class. */
        wcs.lpfnWndProc = ChildWndProc;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.lpszMenuName = NULL;
        wcs.cbWndExtra = 0;
        wcs.lpszClassName = szChild;
        if (!RegisterClass(&wcs))
            return FALSE;
        }

    /* Create the frame. */
    if (!(hwnd = CreateWindow(szFrame, "MDI",
      WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
      NULL, NULL, hinsThis, NULL)))
        return FALSE;

    ShowWindow(hwnd, wCmdShow); /* Show frame. */
    while (GetMessage(&msg, NULL, 0, 0))
        if (!TranslateMDISysAccel(hwndClient, &msg))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }

    return msg.wParam;
    }

LRESULT CALLBACK __export FrameWndProc(HWND hwnd,
                      UINT wm, WPARAM wParam, LPARAM lParam)
    {
    CLIENTCREATESTRUCT  ccs;

    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        /* Window menu to list children. */
        ccs.hWindowMenu = GetSubMenu(GetMenu(hwnd), 1);
        ccs.idFirstChild = 0x1000;

        /* Create the MDI client. */
        return (hwndClient = CreateWindow("mdiclient",
          NULL, WS_CHILD | WS_VISIBLE, 0, 0, 0, 0,
          hwnd, 0, GetWindowInstance(hwnd),
          (LPSTR)&ccs)) == NULL ? -1 : 0;

    case WM_COMMAND:
        switch (wParam)
            {
        default:
            break;

        case idmNew:
            NewMdiChild();
            return 0;

        case idmTest:
            TestSetHandle("This is a test");
            return 0;
            }
        break;

    case WM_CLOSE:
        DestroyWindow(hwnd);
        return 0;

    case WM_DESTROY:
        PostQuitMessage(0);
        return 0;
        }

    return DefFrameProc(hwnd, hwndClient, wm, wParam,
      lParam);
    }

LRESULT CALLBACK __export ChildWndProc(HWND hwnd,
                      UINT wm, WPARAM wParam, LPARAM lParam)
    {
    switch (wm)
        {
    default:
        break;

    case WM_CREATE:
        {
        HGLOBAL hgbl;
        HWND    hwndEdit;

        /* Allocate a global block for the edit */
        /* control. */
        if ((hgbl = GlobalAlloc(GHND, cbMinEdit)) ==
            NULL ||
          (hwndEdit = CreateWindow("edit", NULL,
            WS_CHILD | WS_VISIBLE | WS_VSCROLL |
              ES_MULTILINE, 0, 0, 0, 0, hwnd,
            (HMENU)didEdit, hgbl, NULL)) == NULL)
            return -1;

        /* Remove the text length limit. */
        SendMessage(hwndEdit, EM_LIMITTEXT, 0, 0);
        }
        break;

    case WM_SIZE:
        /* Fill the child's client area with the */
        /* edit control window. */
        SetWindowPos(GetDlgItem(hwnd, didEdit), NULL,
          0, 0, LOWORD(lParam), HIWORD(lParam),
          SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
        break;
        }

    return DefMDIChildProc(hwnd, wm, wParam, lParam);
    }

void NewMdiChild(void)
    {
    MDICREATESTRUCT mcs;
    HWND            hwnd;

    mcs.szTitle = "Edit Me";
    mcs.szClass = szChild;
    mcs.hOwner = GetWindowInstance(hwndClient);
    mcs.x = mcs.y = mcs.cx = mcs.cy = CW_USEDEFAULT;
    mcs.style = 0;

    /* Tell MDI to create the child. */
    if ((hwnd = (HWND)SendMessage(hwndClient,
      WM_MDICREATE, 0,
      (LONG)(LPMDICREATESTRUCT)&mcs)) != NULL)
           ShowWindow(hwnd, SW_SHOW);
    }

void TestSetHandle(LPSTR lsz)
/*****************************************************/
/* -- Test use of EM_SETHANDLE for global memory     */
/*      edit control.                                */
/*****************************************************/
    {
    HWND    hwnd;
    WORD    wDS;
    HLOCAL  hlcl;
    PSTR    pch;

    /* Get the edit control handle in the active MDI */
    /* child. */
    if ((hwnd = (HWND)SendMessage(hwndClient,
      WM_MDIGETACTIVE, 0, 0)) == NULL)
        return;
    hwnd = GetDlgItem(hwnd, didEdit);

    /* Get the current buffer and free it. */
    hlcl =
      (HLOCAL)SendMessage(hwnd, EM_GETHANDLE, 0, 0);
    wDS = (WORD)GetWindowInstance(hwnd);
    _asm    push    ds; /* Save DS to restore later. */
    _asm    mov     ds, wDS;

    /* LocalFree() uses DS to identify heap. */
    LocalFree(hlcl);

    /* Allocate a new buffer, fill with string, and */
    /* give it to the edit control. */
    hlcl = LocalAlloc(LHND, lstrlen(lsz) + 1);
    pch = LocalLock(hlcl);
    lstrcpy(MAKELP(pch, wDS), lsz);
    LocalUnlock(hlcl);
    _asm    pop     ds;
    SendMessage(hwnd, EM_SETHANDLE, (WPARAM)hlcl, 0);
    }
