/* WMENU application launcher -- Al Williams
 *
 *  To compile:   cc wmenu.c
 */
#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#if defined(__BORLANDC__) || defined(__ZTC__)
    #include <dir.h>
    #define CHDIR   chdir
    #define STRDUP  strdup
    #define GETCWD  getcwd
#else
    #include <direct.h>
    #define CHDIR   _chdir
    #define STRDUP  _strdup
    #define GETCWD  _getcwd
#endif
#include "wmenu.h"

HANDLE hInst;       /* current instance */
HWND topwindow;     /* main window */
HMENU topmenu;      /* Main menu */
char string[1025];  /* GP string */
char *menulines[100];/* array of menu items */
char *execerr[] =   /* WinExec errors */
  {
  "Out of memory",
  NULL,
  "File not found",
  "Path not found",
  NULL,
  "Can't dynamically link task",
  "Library requires separate data segments",
  NULL,
  NULL,
  NULL,
  "Incorrect Windows version",
  "Bad EXE format",
  "OS/2 application",
  "DOS 4.0 application",
  "Unknown EXE type",
  "Incorrect Windows version",
  "Can't run multiple copies of this program",
  "Can't run multiple copies of this program",
  "This program requires protected mode",
  };

/* Main window function */
int PASCAL WinMain (HANDLE hInst, HANDLE prev,
                           LPSTR cmdline, int show)
  {
  MSG msg;
  char cwd[81];
  if (!init (hInst, prev, show))   /* set up app */
    return FALSE;
  topmenu = GetMenu (topwindow);   /* Get handle for menu */
  if (!file_read (cmdline))        /* process file */
    return FALSE;
/* Get directory from profile */
  GetProfileString ("WMENU", "CurrentDirectory", "\\",
                    cwd, sizeof (cwd));
/* Set directory */
  if (CHDIR (cwd))
      {
      MessageBox (topwindow, "Invalid working directory",
                  "Warning", MB_OK | MB_ICONSTOP);
      };

  while (GetMessage (&msg, NULL, NULL, NULL))
      {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
      }
  return (msg.wParam);
  }

/* Start up stuff */
int init (HANDLE hInst, HANDLE prev, int show)
  {
  if (!prev)
      if (!init_app (hInst))
        return FALSE;
  if (!init_inst (hInst, show))
    return FALSE;
  return TRUE;
  }

/* Create window class here */
BOOL init_app (HANDLE hInstance)
  {
  WNDCLASS wc;
  wc.style = NULL;
  wc.lpfnWndProc = (void _far *) win_proc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
  wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
  wc.hCursor = LoadCursor (NULL, IDC_ARROW);
  wc.hbrBackground = GetStockObject (WHITE_BRUSH);
  wc.lpszMenuName = "WMENU";
  wc.lpszClassName = "WMENU_Class";
  return (RegisterClass (&wc));
  }

/* Create window here */
BOOL init_inst (HANDLE hInstance, int nCmdShow)
  {
  HWND hWnd;
/* Save the instance handle in global variable */
  hInst = hInstance;
/* Create the main window */
  topwindow = hWnd = CreateWindow ("WMENU_Class", "WMENU",
         WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,
         0, 0, GetSystemMetrics (SM_CXFULLSCREEN),
         GetSystemMetrics (SM_CYMENU) +
         GetSystemMetrics (SM_CYCAPTION) + 2, NULL, NULL,
         hInstance, NULL);
  if (!hWnd)
    return FALSE;

  ShowWindow (hWnd, nCmdShow);
  UpdateWindow (hWnd);
  return (TRUE);
  }

long FAR PASCAL _export win_proc (HWND hWnd, WORD message,
                                 WORD wParam, LONG lParam)
  {
  switch (message)
      {
/* menu commands .... */
      case WM_COMMAND:
      menu (hWnd, wParam);
      break;

/* End of the road... */
    case WM_DESTROY:
      PostQuitMessage (0);
      break;

    default:
      return (DefWindowProc (hWnd, message,
                             wParam, lParam));
      }
  return NULL;
  }

/* Menu handling code */
void menu (HWND hWnd, int wParam)
  {
  char cmd[512];
  char *line, *cd;
  int stat;
/* If wParam>=200 then this is a user menu item */
  if (wParam >= 200)
      {
      int offset = 0;
/* adjust to 0 */
      wParam -= 200;
/* skip space */
      while (isspace (menulines[wParam][offset]))
        offset++;
/* If edit requested */
      if (menulines[wParam][offset] == '*')
          {
/* skip asterisk */
          offset += 1;
/* skip space again */
          while (isspace (menulines[wParam][offset]))
            offset++;
/* get line */
          strcpy (cmd, menulines[wParam] + offset);
/* edit it */
          line = get_input (cmd, sizeof (cmd),
              "Edit command line", "Current directory=%s",
                            cd = GETCWD (NULL, 128));
          free (cd);
/* if line is NULL, then cancel */
          if (line)
/* otherwise run command */
            stat = WinExec (line, SW_SHOW);
          }
      else
/* No editing, just run command */
        stat = WinExec (menulines[wParam] + offset, SW_SHOW);
      if (stat < 32)
          {
/* ERROR! */
          if (stat > sizeof (execerr) / sizeof (char *)
              || execerr[stat] == NULL)
            line = "Unknown error";
          else
            line = execerr[stat];
          MessageBox (topwindow, line, NULL,
                      MB_OK | MB_ICONSTOP);
          }

      return;
      }
/* "Normal" menu code (from file menu) */
  switch (wParam)
      {
    case IDM_ABOUT:
      MessageBox (topwindow,
                  "WMENU Version 1.0 by Al Williams",
                  "About", MB_OK | MB_ICONINFORMATION);
      return;

    case IDM_DIR:
/* Change working directory */
      GETCWD (cmd, sizeof (cmd));
      line = get_input (cmd, sizeof (cmd),
        "Enter working directory", "Current directory=%s",
                        cd = GETCWD (NULL, 128));
      if (line)
          {
          if (CHDIR (line))
              {
              MessageBox (NULL, "Bad directory",
                          NULL, MB_OK | MB_ICONSTOP);
              return;
              }
/* Save in INI file */
          WriteProfileString ("WMENU", "CurrentDirectory",
                              line);
          }
      return;

    case IDM_QUIT:
      DestroyWindow (hWnd);
      return;

      }
  }

/* Process file */
int file_read (LPSTR cmdline)
  {
  FILE *f;
  char far *p, *sp = string;
/* get filename from cmdline. We must copy it to a local
   buffer since we will probably want to use small model.
   fopen() won't take an LPSTR (long pointer to string)
   as an argument. */
/* skip spaces */
  while (isspace (*cmdline))
    cmdline++;
  p = cmdline;
/* skip to next space */
  while (*p && !isspace (*p))
    *sp++ = *p++;
/* if no file name use wmenu.dat in current directory */
  if (p == cmdline)
    strcpy (string, "wmenu.dat");
  else
    *sp = '\0';
  f = fopen (string, "r");
  if (!f)
      {
      MessageBox (topwindow, "Usage: WMENU filename",
                  "Filename Required",
                  MB_OK | MB_ICONSTOP);
      return FALSE;
      }
  else
      {
      int menuid = 200;
      char *p;
/* get line */
      fgets (string, sizeof (string), f);
/* chop off \n */
      p = strchr (string, '\n');
      if (p)
        *p = '\0';
/* Set title (first line) */
      SendMessage (topwindow, WM_SETTEXT, 0,
                                       (long)(LPSTR)string);
/* Get subsequent lines */
      while (fgets (string, sizeof (string), f))
          {
          HMENU pop;
/* chop of \n */
          char *p = strchr (string, '\n');
          if (p)
            *p = '\0';
/* is this a popup line or a item line? */
          p = strchr (string, ':');
          if (!p)
              {
/* popup -- create new one */
              pop = CreatePopupMenu ();
              AppendMenu (topmenu,
                          MF_STRING | MF_POPUP | MF_ENABLED,
                          pop, string);
              }
          else
              {
              *p = '\0';
/* save command line */
              menulines[menuid - 200] = STRDUP (p + 1);
/* add to current popup menu */
              AppendMenu (pop, MF_STRING | MF_ENABLED,
                          menuid++, string);
              }
          }
/* fix menu bar */
      DrawMenuBar (topwindow);
      fclose (f);
      }
  return TRUE;
  }

/* Stuff for general purpose input function */
static char *ibuf;
static int isize;
static char print_buf[513];

/* Dialog callback for input function */
BOOL FAR PASCAL _export inp_dlg (HWND hDlg,
                 unsigned message, WORD wParam, LONG lParam)
  {
  switch (message)
      {
      case WM_INITDIALOG:
/* Set title */
      SendMessage (hDlg, WM_SETTEXT, 0, lParam);
/* Set prompt */
      SetDlgItemText (hDlg, 101, print_buf);
/* Set field */
      SetDlgItemText (hDlg, 102, ibuf);
      return (TRUE);

    case WM_COMMAND:
      if (wParam == IDOK)
          {
/* read input */
          GetDlgItemText (hDlg, 102, ibuf, isize);
          EndDialog (hDlg, TRUE);
          return (TRUE);
          }
/* return NULL for cancel */
      if (wParam == IDCANCEL)
          {
          ibuf = NULL;
          EndDialog (hDlg, TRUE);
          return TRUE;
          }
      break;
      }
  return FALSE;
  }


/* Input function -- buf of siz bytes contains string to
   edit (or \0). title is the edit box's title, fmt is a
   printf-style format for the prompt. Other arguments
   are for % args in fmt. */
char *get_input (char *buf, unsigned siz,
                      char *title, char *fmt,...)
  {
  FARPROC dlgfunc;
  int rc;
  va_list alist;
  va_start (alist, fmt);
/* print prompt to print_buf */
  rc = vsprintf (print_buf, fmt, alist);
  if (rc != -1)
      {
      dlgfunc = MakeProcInstance ((FARPROC)inp_dlg, hInst);
      if (!dlgfunc)
        return NULL;
      else
          {
/* call dialog */
          ibuf = buf;
          isize = siz;
          rc = DialogBoxParam (hInst, "InputBox",
                               NULL, dlgfunc, (long) title);
          FreeProcInstance (dlgfunc);
          if(rc < 0)
            return NULL;
          }
      }
  return ibuf;
  }
