/*
    DskLabel.H - Remove & Set Disk Volume Label for DOS
    Copyright (c) Smuth Nakpansua, 1992, 1993.  All rights reserved.
    Create date:  Nov 25, 1992
    Last Update:  March 23, 1993
 
*/
 
#ifndef _DSKLABEL_H_
#define _DSKLABEL_H_
 
#pragma pack(1)
 
typedef struct _tagXFCB {   /* Extened File Control Block */
    char flag;              /* -1 for extended FCB */
    char reserved1[5];      /* must be zero */
    unsigned char attr;     /* attribute byte */
    char drive;             /* 0=default, 1=A, 2=B, etc */
    char name[8];           /* file & extension name must be left justified */
    char ext[3];            /*   and padded with blanks */
    short cur_block;        /* current-block number */
    short recsize;          /* record size */
    long filesize;          /* file size */
    struct {
        unsigned  day   : 5;
        unsigned  month : 4;
        unsigned  year  : 7;
    } ldate;                /* date created/updated */
    struct {
        unsigned  sec  : 5;
        unsigned  min  : 6;
        unsigned  hour : 5;
    } ltime;                /* time created/updated */
    char reserved2[16];     /* must be zero */
    char cur_rec;           /* current record number */
    char relate_rec;        /* relative-record number */
} XFCB;
 
#pragma pack()
 
int _DosRemoveVolumeLabel(int DrvNum);
int _DosSetVolumeLabel(int DrvNum, char *VolumeName);
 
#endif  /* _DSKLABEL_H_ */
/* eof: dsklabel.h */
