#include <math.h>      
#include "winlin.h"

// -------------------------------------------------------
//  Draw a basic Moire pattern that fills the window.  Use
//  red if we're buffered, blue if not.  The algorithm is
//  slow on purpose to emphasize the buffered redraw effect.
//
void TWinBufLines::prvDraw(HDC hdc, HDC hdc2)
{
    HPEN hpen, hpenSave, hpenSave2;
    if(bBufferedRedraw)
        hpen = CreatePen(PS_SOLID, 0, RGB(255,0,0));
    else     
        hpen = CreatePen(PS_SOLID, 0, RGB(0,0,255));
   
    hpenSave    = SelectPen(hdc, hpen);
    if(hdc2)
        hpenSave2   = SelectPen(hdc2, hpen); 

    for(int i=0; i<size.cx; i+=2) {
        for(int j=0; j<size.cy; j+=2) {
            long x = i - size.cx / 2;
            long y = j - size.cy / 2;
            int d = (int)sqrt(x*x + y*y);
            if(d & 1) {
                MoveTo(hdc, i, j);
                LineTo(hdc, i+1, j);
                if(hdc2) {
                    MoveTo(hdc2, i, j);
                    LineTo(hdc2, i+1, j);
                }
            }
        }
    }

    SelectPen(hdc, hpenSave);
    if(hdc2)
        SelectPen(hdc2, hpenSave2);
    DeletePen(hpen);
}

