#ifndef _WINLIN_H
#define _WINLIN_H

#ifndef _WINBUF_H
#   include "winbuf.h"
#endif

// ______________________________________________________-
//  TWinBufLines ("TWinBufLin")
//
//  A window to demonstrate the effectiveness of buffered 
//  redraws.  Click the right mouse button in the window
//  to toggle buffering on and off.
//
class _EXPORT TWinBufLines : public TWinBuffered
{
public:
    TWinBufLines(PTWindowsObject AParent, 
                 LPSTR           ATitle, 
                 PTModule        AModule          = NULL,
                 BOOL            bBufferedRedraw_ = TRUE)
        :TWinBuffered(AParent, ATitle, AModule, 
                      bBufferedRedraw) { }
protected:
    virtual LPSTR GetClassName() { return "TWinBuffered"; 
}

    virtual void WMRButtonDown(RTMessage)
        = [WM_FIRST + WM_RBUTTONDOWN]
        { SetbBufferedRedraw(!bBufferedRedraw); }

    virtual void prvDraw(HDC hdc, HDC hdc2 = 0);
};
#endif // #ifndef _WINLIN_H

